/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.model;

import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.AvailableZoneEnum;
import com.obs.services.model.BucketTypeEnum;
import com.obs.services.model.ExtensionBucketPermissionEnum;
import com.obs.services.model.StorageClassEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CreateBucketRequest {
    private String bucketName;
    private String location;
    private String epid;
    private StorageClassEnum storageClass;
    private AccessControlList acl;
    private Map<ExtensionBucketPermissionEnum, Set<String>> extensionPermissionMap;
    private AvailableZoneEnum availableZone;
    private Map<String, String> extensionHeaderMap;
    private BucketTypeEnum bucketType = BucketTypeEnum.OBJECT;

    public CreateBucketRequest() {
    }

    public CreateBucketRequest(String bucketName) {
        this.bucketName = bucketName;
    }

    public CreateBucketRequest(String bucketName, String location) {
        this.bucketName = bucketName;
        this.location = location;
    }

    public void grantExtensionPermission(String domainId, ExtensionBucketPermissionEnum extensionPermissionEnum) {
        if (extensionPermissionEnum == null || !ServiceUtils.isValid(domainId)) {
            return;
        }
        Set<String> users = this.getExtensionPermissionMap().get((Object)extensionPermissionEnum);
        if (users == null) {
            users = new HashSet<String>();
            this.getExtensionPermissionMap().put(extensionPermissionEnum, users);
        }
        users.add(domainId.trim());
    }

    public void withdrawExtensionPermission(String domainId, ExtensionBucketPermissionEnum extensionPermissionEnum) {
        if (extensionPermissionEnum == null || !ServiceUtils.isValid(domainId)) {
            return;
        }
        domainId = domainId.trim();
        Set<String> domainIds = this.getExtensionPermissionMap().get((Object)extensionPermissionEnum);
        if (domainIds != null && domainIds.contains(domainId)) {
            domainIds.remove(domainId);
        }
    }

    public void withdrawExtensionPermissions(String domainId) {
        if (ServiceUtils.isValid(domainId)) {
            domainId = domainId.trim();
            for (Map.Entry<ExtensionBucketPermissionEnum, Set<String>> entry : this.getExtensionPermissionMap().entrySet()) {
                if (!entry.getValue().contains(domainId)) continue;
                entry.getValue().remove(domainId);
            }
        }
    }

    public Set<ExtensionBucketPermissionEnum> getAllGrantPermissions() {
        return this.getExtensionPermissionMap().keySet();
    }

    public Set<String> getDomainIdsByGrantPermission(ExtensionBucketPermissionEnum extensionPermissionEnum) {
        Set<String> domainIds = this.getExtensionPermissionMap().get((Object)extensionPermissionEnum);
        if (domainIds == null) {
            domainIds = new HashSet<String>();
        }
        return domainIds;
    }

    public Set<ExtensionBucketPermissionEnum> getGrantPermissionsByDomainId(String domainId) {
        HashSet<ExtensionBucketPermissionEnum> grantPermissions = new HashSet<ExtensionBucketPermissionEnum>();
        if (ServiceUtils.isValid(domainId)) {
            for (Map.Entry<ExtensionBucketPermissionEnum, Set<String>> entry : this.getExtensionPermissionMap().entrySet()) {
                if (!entry.getValue().contains(domainId.trim())) continue;
                grantPermissions.add(entry.getKey());
            }
        }
        return grantPermissions;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getEpid() {
        return this.epid;
    }

    public void setEpid(String epid) {
        this.epid = epid;
    }

    public AccessControlList getAcl() {
        return this.acl;
    }

    public void setAcl(AccessControlList acl) {
        this.acl = acl;
    }

    public StorageClassEnum getBucketStorageClass() {
        return this.storageClass;
    }

    public void setBucketStorageClass(StorageClassEnum storageClass) {
        this.storageClass = storageClass;
    }

    public AvailableZoneEnum getAvailableZone() {
        return this.availableZone;
    }

    public void setAvailableZone(AvailableZoneEnum availableZone) {
        this.availableZone = availableZone;
    }

    Map<ExtensionBucketPermissionEnum, Set<String>> getExtensionPermissionMap() {
        if (this.extensionPermissionMap == null) {
            this.extensionPermissionMap = new HashMap<ExtensionBucketPermissionEnum, Set<String>>();
        }
        return this.extensionPermissionMap;
    }

    public Map<String, String> getExtensionHeaderMap() {
        if (this.extensionHeaderMap == null) {
            this.extensionHeaderMap = new HashMap<String, String>();
        }
        return this.extensionHeaderMap;
    }

    public String toString() {
        return "CreateBucketRequest [bucketName=" + this.bucketName + ", location=" + this.location + ", storageClass=" + (Object)((Object)this.storageClass) + ", acl=" + this.acl + ", extensionPermissionMap=" + this.extensionPermissionMap + ", availableZone=" + (Object)((Object)this.availableZone) + ",epid=" + this.epid + "]";
    }

    public BucketTypeEnum getBucketType() {
        return this.bucketType;
    }

    public void setBucketType(BucketTypeEnum bucketType) {
        this.bucketType = bucketType;
    }
}

