/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.configuration;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.mangofactory.swagger.configuration.SwaggerApiListingJsonSerializer;
import com.mangofactory.swagger.configuration.SwaggerResourceListingJsonSerializer;
import com.mangofactory.swagger.models.DefaultModelPropertiesProvider;
import com.wordnik.swagger.model.ApiListing;
import com.wordnik.swagger.model.ResourceListing;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

public class JacksonSwaggerSupport
implements ApplicationContextAware {
    private ObjectMapper springsMessageConverterObjectMapper;
    private RequestMappingHandlerAdapter requestMappingHandlerAdapter;
    private ApplicationContext applicationContext;

    public ObjectMapper getSpringsMessageConverterObjectMapper() {
        return this.springsMessageConverterObjectMapper;
    }

    private Module swaggerSerializationModule() {
        SimpleModule module = new SimpleModule("SwaggerJacksonModule");
        module.addSerializer(ApiListing.class, (JsonSerializer)new SwaggerApiListingJsonSerializer());
        module.addSerializer(ResourceListing.class, (JsonSerializer)new SwaggerResourceListingJsonSerializer());
        return module;
    }

    @Autowired
    public void setRequestMappingHandlerAdapter(RequestMappingHandlerAdapter requestMappingHandlerAdapter) {
        this.requestMappingHandlerAdapter = requestMappingHandlerAdapter;
    }

    @PostConstruct
    public void setup() {
        List messageConverters = this.requestMappingHandlerAdapter.getMessageConverters();
        for (HttpMessageConverter messageConverter : messageConverters) {
            if (!(messageConverter instanceof MappingJackson2HttpMessageConverter)) continue;
            MappingJackson2HttpMessageConverter m = (MappingJackson2HttpMessageConverter)messageConverter;
            this.springsMessageConverterObjectMapper = m.getObjectMapper();
            this.springsMessageConverterObjectMapper.registerModule(this.swaggerSerializationModule());
        }
        Map beans = this.applicationContext.getBeansOfType(DefaultModelPropertiesProvider.class);
        for (DefaultModelPropertiesProvider defaultModelPropertiesProvider : beans.values()) {
            defaultModelPropertiesProvider.setObjectMapper(this.springsMessageConverterObjectMapper);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

