/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.core;

import com.google.common.collect.Sets;
import com.mangofactory.swagger.core.ResourceGroupingStrategy;
import com.mangofactory.swagger.core.StringUtils;
import com.mangofactory.swagger.scanners.ResourceGroup;
import com.wordnik.swagger.annotations.Api;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

@Component
public class ClassOrApiAnnotationResourceGrouping
implements ResourceGroupingStrategy {
    private static final Logger log = LoggerFactory.getLogger(ClassOrApiAnnotationResourceGrouping.class);

    @Override
    public String getResourceDescription(RequestMappingInfo requestMappingInfo, HandlerMethod handlerMethod) {
        String group = this.getClassOrApiAnnotationValue(handlerMethod);
        return group;
    }

    @Override
    public Integer getResourcePosition(RequestMappingInfo requestMappingInfo, HandlerMethod handlerMethod) {
        Class controllerClass = handlerMethod.getBeanType();
        Api apiAnnotation = (Api)AnnotationUtils.findAnnotation((Class)controllerClass, Api.class);
        if (null != apiAnnotation && !org.apache.commons.lang.StringUtils.isBlank((String)apiAnnotation.value())) {
            return apiAnnotation.position();
        }
        return 0;
    }

    @Override
    public Set<ResourceGroup> getResourceGroups(RequestMappingInfo requestMappingInfo, HandlerMethod handlerMethod) {
        String group = this.getClassOrApiAnnotationValue(handlerMethod).toLowerCase().replaceAll(" ", "-");
        Integer position = this.getResourcePosition(requestMappingInfo, handlerMethod);
        return Sets.newHashSet((Object[])new ResourceGroup[]{new ResourceGroup(group.toLowerCase(), position)});
    }

    private String getClassOrApiAnnotationValue(HandlerMethod handlerMethod) {
        Class controllerClass = handlerMethod.getBeanType();
        String group = StringUtils.splitCamelCase(controllerClass.getSimpleName(), " ");
        Api apiAnnotation = (Api)AnnotationUtils.findAnnotation((Class)controllerClass, Api.class);
        if (null != apiAnnotation && !org.apache.commons.lang.StringUtils.isBlank((String)apiAnnotation.value())) {
            group = apiAnnotation.value();
        }
        return group;
    }
}

