/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.readers.operation.parameter;

import com.google.common.base.Strings;
import com.mangofactory.swagger.readers.Command;
import com.mangofactory.swagger.scanners.RequestMappingContext;
import com.wordnik.swagger.annotations.ApiParam;
import java.lang.annotation.Annotation;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

public class ParameterNameReader
implements Command<RequestMappingContext> {
    @Override
    public void execute(RequestMappingContext context) {
        MethodParameter methodParameter = (MethodParameter)context.get("methodParameter");
        ApiParam apiParam = (ApiParam)methodParameter.getParameterAnnotation(ApiParam.class);
        String name = "";
        if (null != apiParam && !StringUtils.isBlank((String)apiParam.name())) {
            name = apiParam.name();
        } else {
            name = this.findParameterNameFromAnnotations(methodParameter);
            if (Strings.isNullOrEmpty((String)name)) {
                String parameterName = methodParameter.getParameterName();
                name = Strings.isNullOrEmpty((String)parameterName) ? String.format("param%s", methodParameter.getParameterIndex()) : parameterName;
            }
        }
        context.put("name", name);
    }

    private String findParameterNameFromAnnotations(MethodParameter methodParameter) {
        Annotation[] methodAnnotations = methodParameter.getParameterAnnotations();
        if (null != methodAnnotations) {
            for (Annotation annotation : methodAnnotations) {
                if (annotation instanceof PathVariable) {
                    return ((PathVariable)annotation).value();
                }
                if (annotation instanceof ModelAttribute) {
                    return ((ModelAttribute)annotation).value();
                }
                if (annotation instanceof RequestParam) {
                    return ((RequestParam)annotation).value();
                }
                if (!(annotation instanceof RequestHeader)) continue;
                return ((RequestHeader)annotation).value();
            }
        }
        return null;
    }
}

