/*
 * Decompiled with CFR 0.152.
 */
package org.nsclient4j;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import org.nsclient4j.NSClient4JException;
import org.nsclient4j.NSClient4JServerException;

public class NSClient4j {
    protected String hostName = null;
    protected int portNumber = 1248;
    protected String password = "None";
    protected Socket socket = null;
    protected OutputStream os = null;
    protected InputStream is = null;
    protected BufferedInputStream bis = null;
    protected ByteArrayOutputStream baos = null;
    protected int socketTimeout = 5000;
    protected boolean inited = false;

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public NSClient4j(String hostName) throws NSClient4JException {
        this.hostName = hostName;
        this.initSocket();
    }

    public NSClient4j(String hostName, int portNumber) throws NSClient4JException {
        this.hostName = hostName;
        this.portNumber = portNumber;
        this.initSocket();
    }

    public NSClient4j(String hostName, int portNumber, String password) throws NSClient4JException {
        this.hostName = hostName;
        this.portNumber = portNumber;
        this.password = password;
        this.initSocket();
    }

    public NSClient4j(String hostName, String password) throws NSClient4JException {
        this.hostName = hostName;
        this.password = password;
        this.initSocket();
    }

    public NSClient4j() {
        this.inited = false;
    }

    public void setSocketTimeOut(int timeout) {
        this.socketTimeout = timeout;
    }

    public void init() throws NSClient4JException {
        this.initSocket();
    }

    protected void initSocket() throws NSClient4JException {
        if (!this.inited) {
            try {
                this.socket = new Socket();
                this.socket.setSoTimeout(this.socketTimeout);
                this.socket.setTcpNoDelay(true);
                this.socket.connect(new InetSocketAddress(this.hostName, this.portNumber), this.socketTimeout);
                this.is = this.socket.getInputStream();
                this.os = this.socket.getOutputStream();
                this.bis = new BufferedInputStream(this.is);
                this.baos = new ByteArrayOutputStream();
                this.inited = true;
            }
            catch (UnknownHostException ex) {
                this.inited = false;
                throw new NSClient4JException("Unknown Host:" + this.hostName, ex);
            }
            catch (IOException ex) {
                this.inited = false;
                throw new NSClient4JException("Exception Connecting to " + this.hostName + ":" + this.portNumber + " -> " + ex, ex);
            }
        }
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void finalize() {
        try {
            this.socket.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getNSClientVersion() throws NSClient4JException {
        String result = this.submittRequest(this.password + "&1");
        return result;
    }

    public String getUsedDiskSpace(String diskVol) throws NSClient4JException {
        String[] result = NSClient4j.split(this.submittRequest(this.password + "&4&" + diskVol), "&");
        double freeSpace = Double.parseDouble(result[0]);
        double totalSpace = Double.parseDouble(result[1]);
        return "" + (totalSpace - freeSpace);
    }

    public String getFreeDiskSpace(String diskVol) throws NSClient4JException {
        String[] result = NSClient4j.split(this.submittRequest(this.password + "&4&" + diskVol), "&");
        double freeSpace = Double.parseDouble(result[0]);
        return "" + freeSpace;
    }

    public String getTotalDiskSpace(String diskVol) throws NSClient4JException {
        String[] result = NSClient4j.split(this.submittRequest(this.password + "&4&" + diskVol), "&");
        double totalSpace = Double.parseDouble(result[1]);
        return "" + totalSpace;
    }

    public String getUsedPercentDiskSpace(String diskVol) throws NSClient4JException {
        String[] result = NSClient4j.split(this.submittRequest(this.password + "&4&" + diskVol), "&");
        double freeSpace = Double.parseDouble(result[0]);
        double totalSpace = Double.parseDouble(result[1]);
        double usedSpace = totalSpace - freeSpace;
        int percent = (int)(usedSpace / totalSpace * 100.0);
        return "" + percent;
    }

    public String getFreePercentDiskSpace(String diskVol) throws NSClient4JException {
        String[] result = NSClient4j.split(this.submittRequest(this.password + "&4&" + diskVol), "&");
        double freeSpace = Double.parseDouble(result[0]);
        double totalSpace = Double.parseDouble(result[1]);
        int percent = (int)(freeSpace / totalSpace * 100.0);
        return "" + percent;
    }

    public String getPerfMonCounter(String counterName) throws NSClient4JException {
        if (counterName.equalsIgnoreCase("CPU")) {
            return this.getCPUUsage();
        }
        String result = this.submittRequest(this.password + "&8&" + counterName);
        return result;
    }

    public String getCPUUsage() throws NSClient4JException {
        String result = this.submittRequest(this.password + "&2&1&1&1");
        return result;
    }

    public int getUpTimeSeconds() throws NSClient4JException {
        String result = this.submittRequest(this.password + "&3");
        return Integer.parseInt(result);
    }

    public int getUpTimeMinutes() throws NSClient4JException {
        String result = this.submittRequest(this.password + "&3");
        int secs = Integer.parseInt(result);
        int minutes = secs / 60;
        return minutes;
    }

    public int getUpTimeHours() throws NSClient4JException {
        String result = this.submittRequest(this.password + "&3");
        int secs = Integer.parseInt(result);
        int hours = secs / 60 / 60;
        return hours;
    }

    public float getUpTimeDays() throws NSClient4JException {
        String result = this.submittRequest(this.password + "&3");
        float secs = Float.parseFloat(result);
        float days = secs / 60.0f / 60.0f / 24.0f;
        return days;
    }

    public Date getUpTimeDate() throws NSClient4JException {
        String result = this.submittRequest(this.password + "&3");
        long startTime = System.currentTimeMillis() - Long.parseLong(result) * 1000L;
        return new Date(startTime);
    }

    public boolean isServiceUp(String serviceName) throws NSClient4JException {
        String result = this.submittRequest(this.password + "&5&ShowAll&" + serviceName);
        String[] results = NSClient4j.split(result, ":");
        return results[1].trim().equalsIgnoreCase("Started");
    }

    public boolean isProcessUp(String processName) throws NSClient4JException {
        String result = this.submittRequest(this.password + "&6&ShowAll&" + processName);
        String[] results = NSClient4j.split(result, ":");
        return results[1].trim().equalsIgnoreCase("Running");
    }

    public Date getFileDate(String fileName) throws NSClient4JException {
        String result = this.submittRequest(this.password + "&9&" + fileName);
        String[] results = NSClient4j.split(result, ":");
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy h:mm:ss a");
        try {
            return dateFormat.parse(results[1].trim());
        }
        catch (ParseException ex) {
            throw new NSClient4JException("Bad Date Format:" + results[1], ex);
        }
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public String getHostName() {
        return this.hostName;
    }

    protected synchronized String submittRequest(String request) throws NSClient4JException {
        byte[] buffer = new byte[1024];
        this.baos.reset();
        String result = null;
        if (!this.inited) {
            this.initSocket();
        }
        try {
            this.socket.setSoTimeout(this.socketTimeout);
            this.os.write(request.getBytes());
            this.os.flush();
            int read = this.bis.read(buffer);
            if (read > 0) {
                this.baos.write(buffer, 0, read);
            }
            result = this.baos.toString();
            this.testResult(result);
            return result;
        }
        catch (Exception ex) {
            this.inited = false;
            throw new NSClient4JException(ex.getMessage(), ex);
        }
    }

    public static String getCounter(String hostName, int port, String password, String counterName) {
        try {
            NSClient4j client = new NSClient4j(hostName, port, password);
            return client.getPerfMonCounter(counterName);
        }
        catch (NSClient4JException ex) {
            return "Exception:" + ex;
        }
    }

    public static String[] split(String s, String delim) {
        StringTokenizer tokenizer = new StringTokenizer(s, delim);
        String[] result = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            result[i] = tokenizer.nextToken();
            ++i;
        }
        return result;
    }

    public void testResult(String result) throws NSClient4JServerException {
        if (result == null || result.length() < 1 || result.indexOf(" - ERROR: ") != -1) {
            throw new NSClient4JServerException(result);
        }
    }
}

