/*
 * Decompiled with CFR 0.152.
 */
package org.nsclient4j.jmx;

import java.util.Date;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.nsclient4j.NSClient4JException;
import org.nsclient4j.NSClient4j;
import org.nsclient4j.jmx.NSClient4jServiceMBean;

public class NSClient4jService
implements NSClient4jServiceMBean,
MBeanRegistration,
NotificationListener {
    protected Logger log = Logger.getLogger(this.getClass());
    protected NSClient4j client = null;
    protected ObjectName objectName = null;
    protected MBeanServer server = null;
    protected Integer timerId = null;
    protected String hostName = null;
    protected int hostPort = 1248;
    protected String nsPassword = "None";
    protected long frequency = 60000L;
    protected boolean up = false;
    protected float hostCPU = 0.0f;
    protected String timerObjectName = null;
    protected int hostThreadCount = 0;
    protected final String THREAD_COUNTER = "\\System\\Threads";
    protected final String MEMORY_COUNTER = "\\Memory\\% Committed Bytes In Use";
    protected final long INITIAL_DELAY = 1000L;
    protected float hostMemory = 0.0f;

    public NSClient4jService() {
        this.log.info((Object)("Instantiated " + this.getClass().getName()));
    }

    public NSClient4jService(String hostName, long frequency, String timerObjectName) {
        this();
        this.hostName = hostName;
        this.frequency = frequency;
        this.timerObjectName = timerObjectName;
    }

    public void start() throws Exception {
        this.log.info((Object)"\n\t============================================\n\tStarting NSClient4jService\n\t============================================");
        try {
            this.client = new NSClient4j(this.hostName, this.hostPort, this.nsPassword);
            this.schedulePolling(this.frequency, this.timerObjectName);
            this.up = true;
            this.log.info((Object)("Connected to Host:" + this.client.getHostName() + "\t Up Since " + this.client.getUpTimeDate()));
        }
        catch (NSClient4JException ex) {
            this.log.error((Object)"Failed to Create NSClient4j Adaptor", (Throwable)ex);
            throw new Exception("Failed to Create NSClient4j Adaptor", ex);
        }
        this.log.info((Object)"\n\t============================================\n\tStarted NSClient4jService\n\t============================================");
    }

    public void stop() {
        this.log.info((Object)"\n\t============================================\n\tStopping NSClient4jService\n\t============================================");
        this.log.info((Object)"Closing Client.....");
        try {
            this.up = false;
            this.unSchedulePolling(this.timerObjectName);
            this.client.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.log.info((Object)"Client Closed.");
        this.log.info((Object)"\n\t============================================\n\tStopped NSClient4jService\n\t============================================");
    }

    public void run() {
        try {
            this.hostCPU = Float.parseFloat(this.client.getCPUUsage());
            this.log.debug((Object)("CPU:" + this.hostCPU));
        }
        catch (Exception ex) {
            this.log.warn((Object)"Failed to Read CPU", (Throwable)ex);
        }
        try {
            this.hostThreadCount = Integer.parseInt(this.client.getPerfMonCounter("\\System\\Threads").split("\\.")[0]);
            this.log.debug((Object)("Thread Count:" + this.hostThreadCount));
        }
        catch (Exception ex) {
            this.log.warn((Object)"Failed to Read Thread Count", (Throwable)ex);
        }
        try {
            this.hostMemory = Float.parseFloat(this.client.getPerfMonCounter("\\Memory\\% Committed Bytes In Use"));
            this.log.debug((Object)("Memory:" + this.hostMemory));
        }
        catch (Exception ex) {
            this.log.warn((Object)"Failed to Read Memory", (Throwable)ex);
        }
    }

    public int getHostThreadCount() {
        return this.hostThreadCount;
    }

    public float getHostMemory() {
        return this.hostMemory;
    }

    public float getHostCPU() {
        return this.hostCPU;
    }

    public String getCounter(String counterName) throws NSClient4JException {
        return this.client.getPerfMonCounter(counterName);
    }

    public int getHostPort() {
        return this.hostPort;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setNsPassword(String nsPassword) {
        this.nsPassword = nsPassword;
    }

    public void setHostPort(int hostPort) {
        this.hostPort = hostPort;
    }

    public void setFrequency(long frequency) {
        this.frequency = frequency;
        if (this.up) {
            this.unSchedulePolling(this.timerObjectName);
            try {
                this.schedulePolling(frequency, this.timerObjectName);
            }
            catch (Exception ex) {
                this.log.error((Object)"Exception Schedulling Polling After Frequency Change", (Throwable)ex);
            }
        }
    }

    public void setTimerObjectName(String timerObjectName) {
        this.timerObjectName = timerObjectName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public long getFrequency() {
        return this.frequency;
    }

    public Integer getTimerId() {
        return this.timerId;
    }

    public String getTimerObjectName() {
        return this.timerObjectName;
    }

    protected void schedulePolling(long frequency, String timerName) throws Exception {
        ObjectName timerMBean = new ObjectName(timerName);
        if (!((Boolean)this.server.getAttribute(timerMBean, "Active")).booleanValue()) {
            this.server.invoke(timerMBean, "start", new Object[0], new String[0]);
        }
        this.timerId = (Integer)this.server.invoke(timerMBean, "addNotification", new Object[]{"nsclient4j.poll.schedule." + this.objectName.toString(), "run", null, new Date(), new Long(frequency)}, new String[]{"java.lang.String", "java.lang.String", "java.lang.Object", "java.util.Date", "long"});
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType("nsclient4j.poll.schedule." + this.objectName.toString());
        this.server.addNotificationListener(timerMBean, this, (NotificationFilter)filter, null);
    }

    protected void unSchedulePolling(String timerName) {
        try {
            ObjectName timerMBean = new ObjectName(timerName);
            this.server.invoke(timerMBean, "removeNotification", new Object[]{this.timerId}, new String[]{"java.lang.Integer"});
        }
        catch (Exception ex) {
            this.log.error((Object)"Exception UnSchedulling Polling", (Throwable)ex);
        }
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this.objectName = name;
        return this.objectName;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public void handleNotification(Notification notification, Object handback) {
        this.run();
    }
}

