/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute.models;

/**
* Contains properties that specify the endpoint settings which the Azure load
* balancer uses to monitor the availability of this virtual machine before
* forwarding traffic to the endpoint.
*/
public class LoadBalancerProbe {
    private Integer intervalInSeconds;
    
    /**
    * Optional. Specifies the interval for the load balancer probe in seconds.
    * The minimum value is 5 seconds. If not specified, the default is 15
    * seconds.
    * @return The IntervalInSeconds value.
    */
    public Integer getIntervalInSeconds() {
        return this.intervalInSeconds;
    }
    
    /**
    * Optional. Specifies the interval for the load balancer probe in seconds.
    * The minimum value is 5 seconds. If not specified, the default is 15
    * seconds.
    * @param intervalInSecondsValue The IntervalInSeconds value.
    */
    public void setIntervalInSeconds(final Integer intervalInSecondsValue) {
        this.intervalInSeconds = intervalInSecondsValue;
    }
    
    private String path;
    
    /**
    * Optional. Specifies the relative path name to inspect to determine the
    * virtual machine availability status. If Protocol is set to TCP, this
    * value must be NULL.
    * @return The Path value.
    */
    public String getPath() {
        return this.path;
    }
    
    /**
    * Optional. Specifies the relative path name to inspect to determine the
    * virtual machine availability status. If Protocol is set to TCP, this
    * value must be NULL.
    * @param pathValue The Path value.
    */
    public void setPath(final String pathValue) {
        this.path = pathValue;
    }
    
    private int port;
    
    /**
    * Optional. Specifies the port to use to inspect the virtual machine
    * availability status.
    * @return The Port value.
    */
    public int getPort() {
        return this.port;
    }
    
    /**
    * Optional. Specifies the port to use to inspect the virtual machine
    * availability status.
    * @param portValue The Port value.
    */
    public void setPort(final int portValue) {
        this.port = portValue;
    }
    
    private LoadBalancerProbeTransportProtocol protocol;
    
    /**
    * Optional. Specifies the protocol to use to inspect the virtual machine
    * availability status.
    * @return The Protocol value.
    */
    public LoadBalancerProbeTransportProtocol getProtocol() {
        return this.protocol;
    }
    
    /**
    * Optional. Specifies the protocol to use to inspect the virtual machine
    * availability status.
    * @param protocolValue The Protocol value.
    */
    public void setProtocol(final LoadBalancerProbeTransportProtocol protocolValue) {
        this.protocol = protocolValue;
    }
    
    private Integer timeoutInSeconds;
    
    /**
    * Optional. Specifies the timeout for the load balancer probe in seconds.
    * The minimum value is 11 seconds. If not specified, the default is 31
    * seconds.
    * @return The TimeoutInSeconds value.
    */
    public Integer getTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }
    
    /**
    * Optional. Specifies the timeout for the load balancer probe in seconds.
    * The minimum value is 11 seconds. If not specified, the default is 31
    * seconds.
    * @param timeoutInSecondsValue The TimeoutInSeconds value.
    */
    public void setTimeoutInSeconds(final Integer timeoutInSecondsValue) {
        this.timeoutInSeconds = timeoutInSecondsValue;
    }
}
