/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute.models;

/**
* Parameters supplied to the Capture Virtual Machine operation.
*/
public class VirtualMachineCaptureOSImageParameters {
    private PostCaptureAction postCaptureAction;
    
    /**
    * Required. Specifies the action that is performed after the capture
    * operation finishes. Possible values are: Delete - this value causes the
    * virtual machine to be deleted after the image has been captured; or
    * Reprovision - this value causes the virtual machine to be redeployed
    * after the image is captured by using the specified information in
    * ProvisioningConfiguration.
    * @return The PostCaptureAction value.
    */
    public PostCaptureAction getPostCaptureAction() {
        return this.postCaptureAction;
    }
    
    /**
    * Required. Specifies the action that is performed after the capture
    * operation finishes. Possible values are: Delete - this value causes the
    * virtual machine to be deleted after the image has been captured; or
    * Reprovision - this value causes the virtual machine to be redeployed
    * after the image is captured by using the specified information in
    * ProvisioningConfiguration.
    * @param postCaptureActionValue The PostCaptureAction value.
    */
    public void setPostCaptureAction(final PostCaptureAction postCaptureActionValue) {
        this.postCaptureAction = postCaptureActionValue;
    }
    
    private ConfigurationSet provisioningConfiguration;
    
    /**
    * Optional. Provides information to be used to redeploy the virtual machine
    * after the image has been captured. This element is only used when the
    * PostCaptureAction is set to Reprovision.
    * @return The ProvisioningConfiguration value.
    */
    public ConfigurationSet getProvisioningConfiguration() {
        return this.provisioningConfiguration;
    }
    
    /**
    * Optional. Provides information to be used to redeploy the virtual machine
    * after the image has been captured. This element is only used when the
    * PostCaptureAction is set to Reprovision.
    * @param provisioningConfigurationValue The ProvisioningConfiguration value.
    */
    public void setProvisioningConfiguration(final ConfigurationSet provisioningConfigurationValue) {
        this.provisioningConfiguration = provisioningConfigurationValue;
    }
    
    private String targetImageLabel;
    
    /**
    * Required. Specifies the friendly name of the captured image. This is the
    * value that appears in the Name column for the image in the Azure
    * Management Portal.
    * @return The TargetImageLabel value.
    */
    public String getTargetImageLabel() {
        return this.targetImageLabel;
    }
    
    /**
    * Required. Specifies the friendly name of the captured image. This is the
    * value that appears in the Name column for the image in the Azure
    * Management Portal.
    * @param targetImageLabelValue The TargetImageLabel value.
    */
    public void setTargetImageLabel(final String targetImageLabelValue) {
        this.targetImageLabel = targetImageLabelValue;
    }
    
    private String targetImageName;
    
    /**
    * Required. Specifies the image name of the captured image.
    * @return The TargetImageName value.
    */
    public String getTargetImageName() {
        return this.targetImageName;
    }
    
    /**
    * Required. Specifies the image name of the captured image.
    * @param targetImageNameValue The TargetImageName value.
    */
    public void setTargetImageName(final String targetImageNameValue) {
        this.targetImageName = targetImageNameValue;
    }
    
    /**
    * Initializes a new instance of the VirtualMachineCaptureOSImageParameters
    * class.
    *
    */
    public VirtualMachineCaptureOSImageParameters() {
    }
    
    /**
    * Initializes a new instance of the VirtualMachineCaptureOSImageParameters
    * class with required arguments.
    *
    */
    public VirtualMachineCaptureOSImageParameters(PostCaptureAction postCaptureAction, String targetImageLabel, String targetImageName) {
        if (targetImageLabel == null) {
            throw new NullPointerException("targetImageLabel");
        }
        if (targetImageName == null) {
            throw new NullPointerException("targetImageName");
        }
        this.setPostCaptureAction(postCaptureAction);
        this.setTargetImageLabel(targetImageLabel);
        this.setTargetImageName(targetImageName);
    }
}
