/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute.models;

import java.net.URI;

/**
* Parameters supplied to the Update Virtual Machine Data Disk operation.
*/
public class VirtualMachineDataDiskUpdateParameters {
    private String hostCaching;
    
    /**
    * Required. Specifies the platform caching behavior of data disk blob for
    * read/write efficiency. The default vault is ReadOnly. Possible values
    * are: None, ReadOnly, or ReadWrite. Warning: Setting this property
    * impacts the consistency of the disk.
    * @return The HostCaching value.
    */
    public String getHostCaching() {
        return this.hostCaching;
    }
    
    /**
    * Required. Specifies the platform caching behavior of data disk blob for
    * read/write efficiency. The default vault is ReadOnly. Possible values
    * are: None, ReadOnly, or ReadWrite. Warning: Setting this property
    * impacts the consistency of the disk.
    * @param hostCachingValue The HostCaching value.
    */
    public void setHostCaching(final String hostCachingValue) {
        this.hostCaching = hostCachingValue;
    }
    
    private String label;
    
    /**
    * Optional. Specifies the description of the data disk. When you attach a
    * disk, either by directly referencing a media using the MediaLink element
    * or specifying the target disk size, you can use the DiskLabel element to
    * customize the name property of the target data disk.
    * @return The Label value.
    */
    public String getLabel() {
        return this.label;
    }
    
    /**
    * Optional. Specifies the description of the data disk. When you attach a
    * disk, either by directly referencing a media using the MediaLink element
    * or specifying the target disk size, you can use the DiskLabel element to
    * customize the name property of the target data disk.
    * @param labelValue The Label value.
    */
    public void setLabel(final String labelValue) {
        this.label = labelValue;
    }
    
    private int logicalDiskSizeInGB;
    
    /**
    * Optional. Specifies the size, in GB, of an empty disk to be attached to
    * the role. The disk can be created as part of disk attach or create VM
    * role call by specifying the value for this property. Azure creates the
    * empty disk based on size preference and attaches the newly created disk
    * to the Role.
    * @return The LogicalDiskSizeInGB value.
    */
    public int getLogicalDiskSizeInGB() {
        return this.logicalDiskSizeInGB;
    }
    
    /**
    * Optional. Specifies the size, in GB, of an empty disk to be attached to
    * the role. The disk can be created as part of disk attach or create VM
    * role call by specifying the value for this property. Azure creates the
    * empty disk based on size preference and attaches the newly created disk
    * to the Role.
    * @param logicalDiskSizeInGBValue The LogicalDiskSizeInGB value.
    */
    public void setLogicalDiskSizeInGB(final int logicalDiskSizeInGBValue) {
        this.logicalDiskSizeInGB = logicalDiskSizeInGBValue;
    }
    
    private Integer logicalUnitNumber;
    
    /**
    * Optional. Specifies the Logical Unit Number (LUN) for the disk. The LUN
    * specifies the slot in which the data drive appears when mounted for
    * usage by the virtual machine. Valid LUN values are 0 through 15.
    * @return The LogicalUnitNumber value.
    */
    public Integer getLogicalUnitNumber() {
        return this.logicalUnitNumber;
    }
    
    /**
    * Optional. Specifies the Logical Unit Number (LUN) for the disk. The LUN
    * specifies the slot in which the data drive appears when mounted for
    * usage by the virtual machine. Valid LUN values are 0 through 15.
    * @param logicalUnitNumberValue The LogicalUnitNumber value.
    */
    public void setLogicalUnitNumber(final Integer logicalUnitNumberValue) {
        this.logicalUnitNumber = logicalUnitNumberValue;
    }
    
    private URI mediaLinkUri;
    
    /**
    * Required. Specifies the location of the blob in Azure blob store where
    * the media for the disk is located. The blob location must belong to the
    * storage account in the subscription specified by the SubscriptionId
    * value in the operation call. Example:
    * http://example.blob.core.windows.net/disks/mydisk.vhd.
    * @return The MediaLinkUri value.
    */
    public URI getMediaLinkUri() {
        return this.mediaLinkUri;
    }
    
    /**
    * Required. Specifies the location of the blob in Azure blob store where
    * the media for the disk is located. The blob location must belong to the
    * storage account in the subscription specified by the SubscriptionId
    * value in the operation call. Example:
    * http://example.blob.core.windows.net/disks/mydisk.vhd.
    * @param mediaLinkUriValue The MediaLinkUri value.
    */
    public void setMediaLinkUri(final URI mediaLinkUriValue) {
        this.mediaLinkUri = mediaLinkUriValue;
    }
    
    private String name;
    
    /**
    * Optional. Specifies the name of the disk. Azure uses the specified disk
    * to create the data disk for the machine and populates this field with
    * the disk name.
    * @return The Name value.
    */
    public String getName() {
        return this.name;
    }
    
    /**
    * Optional. Specifies the name of the disk. Azure uses the specified disk
    * to create the data disk for the machine and populates this field with
    * the disk name.
    * @param nameValue The Name value.
    */
    public void setName(final String nameValue) {
        this.name = nameValue;
    }
    
    /**
    * Initializes a new instance of the VirtualMachineDataDiskUpdateParameters
    * class.
    *
    */
    public VirtualMachineDataDiskUpdateParameters() {
    }
    
    /**
    * Initializes a new instance of the VirtualMachineDataDiskUpdateParameters
    * class with required arguments.
    *
    */
    public VirtualMachineDataDiskUpdateParameters(String hostCaching, URI mediaLinkUri) {
        if (hostCaching == null) {
            throw new NullPointerException("hostCaching");
        }
        if (mediaLinkUri == null) {
            throw new NullPointerException("mediaLinkUri");
        }
        this.setHostCaching(hostCaching);
        this.setMediaLinkUri(mediaLinkUri);
    }
}
