/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management.compute;

import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.compute.ComputeManagementClient;
import com.microsoft.windowsazure.management.compute.ComputeManagementClientImpl;
import com.microsoft.windowsazure.management.compute.VirtualMachineDiskOperations;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDataDiskCreateParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDataDiskGetResponse;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDataDiskUpdateParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDiskCreateParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDiskCreateResponse;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDiskGetResponse;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDiskListResponse;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDiskUpdateParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDiskUpdateResponse;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class VirtualMachineDiskOperationsImpl
implements ServiceOperations<ComputeManagementClientImpl>,
VirtualMachineDiskOperations {
    private ComputeManagementClientImpl client;

    VirtualMachineDiskOperationsImpl(ComputeManagementClientImpl client) {
        this.client = client;
    }

    public ComputeManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<OperationResponse> beginCreatingDataDiskAsync(final String serviceName, final String deploymentName, final String roleName, final VirtualMachineDataDiskCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return VirtualMachineDiskOperationsImpl.this.beginCreatingDataDisk(serviceName, deploymentName, roleName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginCreatingDataDisk(String serviceName, String deploymentName, String roleName, VirtualMachineDataDiskCreateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (roleName == null) {
            throw new NullPointerException("roleName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getHostCaching() == null) {
            throw new NullPointerException("parameters.HostCaching");
        }
        if (parameters.getMediaLinkUri() == null) {
            throw new NullPointerException("parameters.MediaLinkUri");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("roleName", roleName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginCreatingDataDiskAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deployments/" + deploymentName.trim() + "/roles/" + roleName.trim() + "/DataDisks";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element dataVirtualHardDiskElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DataVirtualHardDisk");
        requestDoc.appendChild(dataVirtualHardDiskElement);
        Element hostCachingElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "HostCaching");
        hostCachingElement.appendChild(requestDoc.createTextNode(parameters.getHostCaching()));
        dataVirtualHardDiskElement.appendChild(hostCachingElement);
        if (parameters.getLabel() != null) {
            Element diskLabelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DiskLabel");
            diskLabelElement.appendChild(requestDoc.createTextNode(parameters.getLabel()));
            dataVirtualHardDiskElement.appendChild(diskLabelElement);
        }
        if (parameters.getName() != null) {
            Element diskNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DiskName");
            diskNameElement.appendChild(requestDoc.createTextNode(parameters.getName()));
            dataVirtualHardDiskElement.appendChild(diskNameElement);
        }
        if (parameters.getLogicalUnitNumber() != null) {
            Element lunElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Lun");
            lunElement.appendChild(requestDoc.createTextNode(Integer.toString(parameters.getLogicalUnitNumber())));
            dataVirtualHardDiskElement.appendChild(lunElement);
        }
        Element logicalDiskSizeInGBElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LogicalDiskSizeInGB");
        logicalDiskSizeInGBElement.appendChild(requestDoc.createTextNode(Integer.toString(parameters.getLogicalDiskSizeInGB())));
        dataVirtualHardDiskElement.appendChild(logicalDiskSizeInGBElement);
        Element mediaLinkElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "MediaLink");
        mediaLinkElement.appendChild(requestDoc.createTextNode(parameters.getMediaLinkUri().toString()));
        dataVirtualHardDiskElement.appendChild(mediaLinkElement);
        if (parameters.getSourceMediaLinkUri() != null) {
            Element sourceMediaLinkElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SourceMediaLink");
            sourceMediaLinkElement.appendChild(requestDoc.createTextNode(parameters.getSourceMediaLinkUri().toString()));
            dataVirtualHardDiskElement.appendChild(sourceMediaLinkElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginDeletingDataDiskAsync(final String serviceName, final String deploymentName, final String roleName, final int logicalUnitNumber, final boolean deleteFromStorage) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return VirtualMachineDiskOperationsImpl.this.beginDeletingDataDisk(serviceName, deploymentName, roleName, logicalUnitNumber, deleteFromStorage);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginDeletingDataDisk(String serviceName, String deploymentName, String roleName, int logicalUnitNumber, boolean deleteFromStorage) throws IOException, ServiceException {
        String baseUrl;
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (roleName == null) {
            throw new NullPointerException("roleName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("roleName", roleName);
            tracingParameters.put("logicalUnitNumber", logicalUnitNumber);
            tracingParameters.put("deleteFromStorage", deleteFromStorage);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginDeletingDataDiskAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deployments/" + deploymentName.trim() + "/roles/" + roleName.trim() + "/DataDisks/" + logicalUnitNumber + "?";
        if (deleteFromStorage) {
            url = url + "comp=" + "media";
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> createDataDiskAsync(final String serviceName, final String deploymentName, final String roleName, final VirtualMachineDataDiskCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return VirtualMachineDiskOperationsImpl.this.createDataDisk(serviceName, deploymentName, roleName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse createDataDisk(String serviceName, String deploymentName, String roleName, VirtualMachineDataDiskCreateParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("roleName", roleName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createDataDiskAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getVirtualMachineDisksOperations().beginCreatingDataDiskAsync(serviceName, deploymentName, roleName, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<VirtualMachineDiskCreateResponse> createDiskAsync(final VirtualMachineDiskCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineDiskCreateResponse>(){

            @Override
            public VirtualMachineDiskCreateResponse call() throws Exception {
                return VirtualMachineDiskOperationsImpl.this.createDisk(parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineDiskCreateResponse createDisk(VirtualMachineDiskCreateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException, URISyntaxException {
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLabel() == null) {
            throw new NullPointerException("parameters.Label");
        }
        if (parameters.getMediaLinkUri() == null) {
            throw new NullPointerException("parameters.MediaLinkUri");
        }
        if (parameters.getName() == null) {
            throw new NullPointerException("parameters.Name");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, VirtualMachineDiskCreateParameters> tracingParameters = new HashMap<String, VirtualMachineDiskCreateParameters>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createDiskAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/disks";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element diskElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Disk");
        requestDoc.appendChild(diskElement);
        if (parameters.getOperatingSystemType() != null) {
            Element osElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "OS");
            osElement.appendChild(requestDoc.createTextNode(parameters.getOperatingSystemType()));
            diskElement.appendChild(osElement);
        }
        Element labelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Label");
        labelElement.appendChild(requestDoc.createTextNode(parameters.getLabel()));
        diskElement.appendChild(labelElement);
        Element mediaLinkElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "MediaLink");
        mediaLinkElement.appendChild(requestDoc.createTextNode(parameters.getMediaLinkUri().toString()));
        diskElement.appendChild(mediaLinkElement);
        Element nameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
        nameElement.appendChild(requestDoc.createTextNode(parameters.getName()));
        diskElement.appendChild(nameElement);
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineDiskCreateResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new VirtualMachineDiskCreateResponse();
            DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
            documentBuilderFactory2.setNamespaceAware(true);
            DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
            Document responseDoc = documentBuilder2.parse((InputStream)new BOMInputStream(responseContent));
            Element diskElement2 = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"Disk");
            if (diskElement2 != null) {
                Element iOTypeElement;
                Element isPremiumElement;
                Element attachedToElement;
                Element sourceImageNameElement;
                Element nameElement2;
                Element mediaLinkElement2;
                Element logicalDiskSizeInGBElement;
                Element locationElement;
                Element affinityGroupElement;
                Element labelElement2;
                Element osElement2 = XmlUtility.getElementByTagNameNS((Node)diskElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"OS");
                if (osElement2 != null) {
                    String osInstance = osElement2.getTextContent();
                    result.setOperatingSystem(osInstance);
                }
                if ((labelElement2 = XmlUtility.getElementByTagNameNS((Node)diskElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                    String labelInstance = labelElement2.getTextContent();
                    result.setLabel(labelInstance);
                }
                if ((affinityGroupElement = XmlUtility.getElementByTagNameNS((Node)diskElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"AffinityGroup")) != null) {
                    String affinityGroupInstance = affinityGroupElement.getTextContent();
                    result.setAffinityGroup(affinityGroupInstance);
                }
                if ((locationElement = XmlUtility.getElementByTagNameNS((Node)diskElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Location")) != null) {
                    String locationInstance = locationElement.getTextContent();
                    result.setLocation(locationInstance);
                }
                if ((logicalDiskSizeInGBElement = XmlUtility.getElementByTagNameNS((Node)diskElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"LogicalDiskSizeInGB")) != null) {
                    int logicalDiskSizeInGBInstance = DatatypeConverter.parseInt((String)logicalDiskSizeInGBElement.getTextContent());
                    result.setLogicalSizeInGB(logicalDiskSizeInGBInstance);
                }
                if ((mediaLinkElement2 = XmlUtility.getElementByTagNameNS((Node)diskElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"MediaLink")) != null) {
                    URI mediaLinkInstance = new URI(mediaLinkElement2.getTextContent());
                    result.setMediaLinkUri(mediaLinkInstance);
                }
                if ((nameElement2 = XmlUtility.getElementByTagNameNS((Node)diskElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                    String nameInstance = nameElement2.getTextContent();
                    result.setName(nameInstance);
                }
                if ((sourceImageNameElement = XmlUtility.getElementByTagNameNS((Node)diskElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"SourceImageName")) != null) {
                    String sourceImageNameInstance = sourceImageNameElement.getTextContent();
                    result.setSourceImageName(sourceImageNameInstance);
                }
                if ((attachedToElement = XmlUtility.getElementByTagNameNS((Node)diskElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"AttachedTo")) != null) {
                    Element roleNameElement;
                    Element deploymentNameElement;
                    VirtualMachineDiskCreateResponse.VirtualMachineDiskUsageDetails attachedToInstance = new VirtualMachineDiskCreateResponse.VirtualMachineDiskUsageDetails();
                    result.setUsageDetails(attachedToInstance);
                    Element hostedServiceNameElement = XmlUtility.getElementByTagNameNS((Node)attachedToElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostedServiceName");
                    if (hostedServiceNameElement != null) {
                        String hostedServiceNameInstance = hostedServiceNameElement.getTextContent();
                        attachedToInstance.setHostedServiceName(hostedServiceNameInstance);
                    }
                    if ((deploymentNameElement = XmlUtility.getElementByTagNameNS((Node)attachedToElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DeploymentName")) != null) {
                        String deploymentNameInstance = deploymentNameElement.getTextContent();
                        attachedToInstance.setDeploymentName(deploymentNameInstance);
                    }
                    if ((roleNameElement = XmlUtility.getElementByTagNameNS((Node)attachedToElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleName")) != null) {
                        String roleNameInstance = roleNameElement.getTextContent();
                        attachedToInstance.setRoleName(roleNameInstance);
                    }
                }
                if ((isPremiumElement = XmlUtility.getElementByTagNameNS((Node)diskElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsPremium")) != null && !(isPremiumElement.getTextContent() == null || isPremiumElement.getTextContent().isEmpty())) {
                    boolean isPremiumInstance = DatatypeConverter.parseBoolean((String)isPremiumElement.getTextContent().toLowerCase());
                    result.setIsPremium(isPremiumInstance);
                }
                if ((iOTypeElement = XmlUtility.getElementByTagNameNS((Node)diskElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"IOType")) != null) {
                    String iOTypeInstance = iOTypeElement.getTextContent();
                    result.setIOType(iOTypeInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualMachineDiskCreateResponse virtualMachineDiskCreateResponse = result;
            return virtualMachineDiskCreateResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> deleteDataDiskAsync(final String serviceName, final String deploymentName, final String roleName, final int logicalUnitNumber, final boolean deleteFromStorage) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return VirtualMachineDiskOperationsImpl.this.deleteDataDisk(serviceName, deploymentName, roleName, logicalUnitNumber, deleteFromStorage);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse deleteDataDisk(String serviceName, String deploymentName, String roleName, int logicalUnitNumber, boolean deleteFromStorage) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("roleName", roleName);
            tracingParameters.put("logicalUnitNumber", logicalUnitNumber);
            tracingParameters.put("deleteFromStorage", deleteFromStorage);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteDataDiskAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getVirtualMachineDisksOperations().beginDeletingDataDiskAsync(serviceName, deploymentName, roleName, logicalUnitNumber, deleteFromStorage).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationResponse> deleteDiskAsync(final String name, final boolean deleteFromStorage) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return VirtualMachineDiskOperationsImpl.this.deleteDisk(name, deleteFromStorage);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse deleteDisk(String name, boolean deleteFromStorage) throws IOException, ServiceException {
        String baseUrl;
        if (name == null) {
            throw new NullPointerException("name");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("name", name);
            tracingParameters.put("deleteFromStorage", deleteFromStorage);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteDiskAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/disks/" + name.trim() + "?";
        if (deleteFromStorage) {
            url = url + "comp=" + "media";
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<VirtualMachineDataDiskGetResponse> getDataDiskAsync(final String serviceName, final String deploymentName, final String roleName, final int logicalUnitNumber) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineDataDiskGetResponse>(){

            @Override
            public VirtualMachineDataDiskGetResponse call() throws Exception {
                return VirtualMachineDiskOperationsImpl.this.getDataDisk(serviceName, deploymentName, roleName, logicalUnitNumber);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineDataDiskGetResponse getDataDisk(String serviceName, String deploymentName, String roleName, int logicalUnitNumber) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (roleName == null) {
            throw new NullPointerException("roleName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("roleName", roleName);
            tracingParameters.put("logicalUnitNumber", logicalUnitNumber);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getDataDiskAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deployments/" + deploymentName.trim() + "/roles/" + roleName.trim() + "/DataDisks/" + logicalUnitNumber;
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineDataDiskGetResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new VirtualMachineDataDiskGetResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element dataVirtualHardDiskElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"DataVirtualHardDisk");
            if (dataVirtualHardDiskElement != null) {
                Element iOTypeElement;
                Element mediaLinkElement;
                Element logicalDiskSizeInGBElement;
                Element lunElement;
                Element diskNameElement;
                Element diskLabelElement;
                Element hostCachingElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostCaching");
                if (hostCachingElement != null) {
                    String hostCachingInstance = hostCachingElement.getTextContent();
                    result.setHostCaching(hostCachingInstance);
                }
                if ((diskLabelElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DiskLabel")) != null) {
                    String diskLabelInstance = diskLabelElement.getTextContent();
                    result.setLabel(diskLabelInstance);
                }
                if ((diskNameElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DiskName")) != null) {
                    String diskNameInstance = diskNameElement.getTextContent();
                    result.setName(diskNameInstance);
                }
                if ((lunElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Lun")) != null && !(lunElement.getTextContent() == null || lunElement.getTextContent().isEmpty())) {
                    int lunInstance = DatatypeConverter.parseInt((String)lunElement.getTextContent());
                    result.setLogicalUnitNumber(lunInstance);
                }
                if ((logicalDiskSizeInGBElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LogicalDiskSizeInGB")) != null) {
                    int logicalDiskSizeInGBInstance = DatatypeConverter.parseInt((String)logicalDiskSizeInGBElement.getTextContent());
                    result.setLogicalDiskSizeInGB(logicalDiskSizeInGBInstance);
                }
                if ((mediaLinkElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MediaLink")) != null) {
                    URI mediaLinkInstance = new URI(mediaLinkElement.getTextContent());
                    result.setMediaLinkUri(mediaLinkInstance);
                }
                if ((iOTypeElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IOType")) != null) {
                    String iOTypeInstance = iOTypeElement.getTextContent();
                    result.setIOType(iOTypeInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualMachineDataDiskGetResponse virtualMachineDataDiskGetResponse = result;
            return virtualMachineDataDiskGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<VirtualMachineDiskGetResponse> getDiskAsync(final String name) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineDiskGetResponse>(){

            @Override
            public VirtualMachineDiskGetResponse call() throws Exception {
                return VirtualMachineDiskOperationsImpl.this.getDisk(name);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineDiskGetResponse getDisk(String name) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("name", name);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getDiskAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/disks/" + name.trim();
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineDiskGetResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new VirtualMachineDiskGetResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element diskElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"Disk");
            if (diskElement != null) {
                Element iOTypeElement;
                Element isPremiumElement;
                Element isCorruptedElement;
                Element attachedToElement;
                Element sourceImageNameElement;
                Element osElement;
                Element nameElement;
                Element mediaLinkElement;
                Element logicalDiskSizeInGBElement;
                Element labelElement;
                Element locationElement;
                Element affinityGroupElement = XmlUtility.getElementByTagNameNS((Node)diskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AffinityGroup");
                if (affinityGroupElement != null) {
                    String affinityGroupInstance = affinityGroupElement.getTextContent();
                    result.setAffinityGroup(affinityGroupInstance);
                }
                if ((locationElement = XmlUtility.getElementByTagNameNS((Node)diskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Location")) != null) {
                    String locationInstance = locationElement.getTextContent();
                    result.setLocation(locationInstance);
                }
                if ((labelElement = XmlUtility.getElementByTagNameNS((Node)diskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                    String labelInstance = labelElement.getTextContent();
                    result.setLabel(labelInstance);
                }
                if ((logicalDiskSizeInGBElement = XmlUtility.getElementByTagNameNS((Node)diskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LogicalDiskSizeInGB")) != null) {
                    int logicalDiskSizeInGBInstance = DatatypeConverter.parseInt((String)logicalDiskSizeInGBElement.getTextContent());
                    result.setLogicalSizeInGB(logicalDiskSizeInGBInstance);
                }
                if ((mediaLinkElement = XmlUtility.getElementByTagNameNS((Node)diskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MediaLink")) != null) {
                    URI mediaLinkInstance = new URI(mediaLinkElement.getTextContent());
                    result.setMediaLinkUri(mediaLinkInstance);
                }
                if ((nameElement = XmlUtility.getElementByTagNameNS((Node)diskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                    String nameInstance = nameElement.getTextContent();
                    result.setName(nameInstance);
                }
                if ((osElement = XmlUtility.getElementByTagNameNS((Node)diskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OS")) != null) {
                    String osInstance = osElement.getTextContent();
                    result.setOperatingSystemType(osInstance);
                }
                if ((sourceImageNameElement = XmlUtility.getElementByTagNameNS((Node)diskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SourceImageName")) != null) {
                    String sourceImageNameInstance = sourceImageNameElement.getTextContent();
                    result.setSourceImageName(sourceImageNameInstance);
                }
                if ((attachedToElement = XmlUtility.getElementByTagNameNS((Node)diskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AttachedTo")) != null) {
                    Element roleNameElement;
                    Element deploymentNameElement;
                    VirtualMachineDiskGetResponse.VirtualMachineDiskUsageDetails attachedToInstance = new VirtualMachineDiskGetResponse.VirtualMachineDiskUsageDetails();
                    result.setUsageDetails(attachedToInstance);
                    Element hostedServiceNameElement = XmlUtility.getElementByTagNameNS((Node)attachedToElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostedServiceName");
                    if (hostedServiceNameElement != null) {
                        String hostedServiceNameInstance = hostedServiceNameElement.getTextContent();
                        attachedToInstance.setHostedServiceName(hostedServiceNameInstance);
                    }
                    if ((deploymentNameElement = XmlUtility.getElementByTagNameNS((Node)attachedToElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DeploymentName")) != null) {
                        String deploymentNameInstance = deploymentNameElement.getTextContent();
                        attachedToInstance.setDeploymentName(deploymentNameInstance);
                    }
                    if ((roleNameElement = XmlUtility.getElementByTagNameNS((Node)attachedToElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleName")) != null) {
                        String roleNameInstance = roleNameElement.getTextContent();
                        attachedToInstance.setRoleName(roleNameInstance);
                    }
                }
                if ((isCorruptedElement = XmlUtility.getElementByTagNameNS((Node)diskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsCorrupted")) != null && !(isCorruptedElement.getTextContent() == null || isCorruptedElement.getTextContent().isEmpty())) {
                    boolean isCorruptedInstance = DatatypeConverter.parseBoolean((String)isCorruptedElement.getTextContent().toLowerCase());
                    result.setIsCorrupted(isCorruptedInstance);
                }
                if ((isPremiumElement = XmlUtility.getElementByTagNameNS((Node)diskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsPremium")) != null && !(isPremiumElement.getTextContent() == null || isPremiumElement.getTextContent().isEmpty())) {
                    boolean isPremiumInstance = DatatypeConverter.parseBoolean((String)isPremiumElement.getTextContent().toLowerCase());
                    result.setIsPremium(isPremiumInstance);
                }
                if ((iOTypeElement = XmlUtility.getElementByTagNameNS((Node)diskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IOType")) != null) {
                    String iOTypeInstance = iOTypeElement.getTextContent();
                    result.setIOType(iOTypeInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualMachineDiskGetResponse virtualMachineDiskGetResponse = result;
            return virtualMachineDiskGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<VirtualMachineDiskListResponse> listDisksAsync() {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineDiskListResponse>(){

            @Override
            public VirtualMachineDiskListResponse call() throws Exception {
                return VirtualMachineDiskOperationsImpl.this.listDisks();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineDiskListResponse listDisks() throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap tracingParameters = new HashMap();
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listDisksAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/disks";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineDiskListResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new VirtualMachineDiskListResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element disksSequenceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"Disks");
            if (disksSequenceElement != null) {
                for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)disksSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Disk").size(); ++i1) {
                    Element iOTypeElement;
                    Element isPremiumElement;
                    Element isCorruptedElement;
                    Element attachedToElement;
                    Element sourceImageNameElement;
                    Element osElement;
                    Element nameElement;
                    Element mediaLinkElement;
                    Element logicalDiskSizeInGBElement;
                    Element labelElement;
                    Element locationElement;
                    Element disksElement = (Element)XmlUtility.getElementsByTagNameNS((Node)disksSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Disk").get(i1);
                    VirtualMachineDiskListResponse.VirtualMachineDisk diskInstance = new VirtualMachineDiskListResponse.VirtualMachineDisk();
                    result.getDisks().add(diskInstance);
                    Element affinityGroupElement = XmlUtility.getElementByTagNameNS((Node)disksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AffinityGroup");
                    if (affinityGroupElement != null) {
                        String affinityGroupInstance = affinityGroupElement.getTextContent();
                        diskInstance.setAffinityGroup(affinityGroupInstance);
                    }
                    if ((locationElement = XmlUtility.getElementByTagNameNS((Node)disksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Location")) != null) {
                        String locationInstance = locationElement.getTextContent();
                        diskInstance.setLocation(locationInstance);
                    }
                    if ((labelElement = XmlUtility.getElementByTagNameNS((Node)disksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                        String labelInstance = labelElement.getTextContent();
                        diskInstance.setLabel(labelInstance);
                    }
                    if ((logicalDiskSizeInGBElement = XmlUtility.getElementByTagNameNS((Node)disksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LogicalDiskSizeInGB")) != null) {
                        int logicalDiskSizeInGBInstance = DatatypeConverter.parseInt((String)logicalDiskSizeInGBElement.getTextContent());
                        diskInstance.setLogicalSizeInGB(logicalDiskSizeInGBInstance);
                    }
                    if ((mediaLinkElement = XmlUtility.getElementByTagNameNS((Node)disksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MediaLink")) != null) {
                        URI mediaLinkInstance = new URI(mediaLinkElement.getTextContent());
                        diskInstance.setMediaLinkUri(mediaLinkInstance);
                    }
                    if ((nameElement = XmlUtility.getElementByTagNameNS((Node)disksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                        String nameInstance = nameElement.getTextContent();
                        diskInstance.setName(nameInstance);
                    }
                    if ((osElement = XmlUtility.getElementByTagNameNS((Node)disksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OS")) != null) {
                        String osInstance = osElement.getTextContent();
                        diskInstance.setOperatingSystemType(osInstance);
                    }
                    if ((sourceImageNameElement = XmlUtility.getElementByTagNameNS((Node)disksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SourceImageName")) != null) {
                        String sourceImageNameInstance = sourceImageNameElement.getTextContent();
                        diskInstance.setSourceImageName(sourceImageNameInstance);
                    }
                    if ((attachedToElement = XmlUtility.getElementByTagNameNS((Node)disksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AttachedTo")) != null) {
                        Element roleNameElement;
                        Element deploymentNameElement;
                        VirtualMachineDiskListResponse.VirtualMachineDiskUsageDetails attachedToInstance = new VirtualMachineDiskListResponse.VirtualMachineDiskUsageDetails();
                        diskInstance.setUsageDetails(attachedToInstance);
                        Element hostedServiceNameElement = XmlUtility.getElementByTagNameNS((Node)attachedToElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostedServiceName");
                        if (hostedServiceNameElement != null) {
                            String hostedServiceNameInstance = hostedServiceNameElement.getTextContent();
                            attachedToInstance.setHostedServiceName(hostedServiceNameInstance);
                        }
                        if ((deploymentNameElement = XmlUtility.getElementByTagNameNS((Node)attachedToElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DeploymentName")) != null) {
                            String deploymentNameInstance = deploymentNameElement.getTextContent();
                            attachedToInstance.setDeploymentName(deploymentNameInstance);
                        }
                        if ((roleNameElement = XmlUtility.getElementByTagNameNS((Node)attachedToElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleName")) != null) {
                            String roleNameInstance = roleNameElement.getTextContent();
                            attachedToInstance.setRoleName(roleNameInstance);
                        }
                    }
                    if ((isCorruptedElement = XmlUtility.getElementByTagNameNS((Node)disksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsCorrupted")) != null && !(isCorruptedElement.getTextContent() == null || isCorruptedElement.getTextContent().isEmpty())) {
                        boolean isCorruptedInstance = DatatypeConverter.parseBoolean((String)isCorruptedElement.getTextContent().toLowerCase());
                        diskInstance.setIsCorrupted(isCorruptedInstance);
                    }
                    if ((isPremiumElement = XmlUtility.getElementByTagNameNS((Node)disksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsPremium")) != null && !(isPremiumElement.getTextContent() == null || isPremiumElement.getTextContent().isEmpty())) {
                        boolean isPremiumInstance = DatatypeConverter.parseBoolean((String)isPremiumElement.getTextContent().toLowerCase());
                        diskInstance.setIsPremium(isPremiumInstance);
                    }
                    if ((iOTypeElement = XmlUtility.getElementByTagNameNS((Node)disksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IOType")) == null) continue;
                    String iOTypeInstance = iOTypeElement.getTextContent();
                    diskInstance.setIOType(iOTypeInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            VirtualMachineDiskListResponse virtualMachineDiskListResponse = result;
            return virtualMachineDiskListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> updateDataDiskAsync(final String serviceName, final String deploymentName, final String roleName, final int logicalUnitNumber, final VirtualMachineDataDiskUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return VirtualMachineDiskOperationsImpl.this.updateDataDisk(serviceName, deploymentName, roleName, logicalUnitNumber, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse updateDataDisk(String serviceName, String deploymentName, String roleName, int logicalUnitNumber, VirtualMachineDataDiskUpdateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (roleName == null) {
            throw new NullPointerException("roleName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getHostCaching() == null) {
            throw new NullPointerException("parameters.HostCaching");
        }
        if (parameters.getMediaLinkUri() == null) {
            throw new NullPointerException("parameters.MediaLinkUri");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("roleName", roleName);
            tracingParameters.put("logicalUnitNumber", logicalUnitNumber);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"updateDataDiskAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deployments/" + deploymentName.trim() + "/roles/" + roleName.trim() + "/DataDisks/" + logicalUnitNumber;
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element dataVirtualHardDiskElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DataVirtualHardDisk");
        requestDoc.appendChild(dataVirtualHardDiskElement);
        Element hostCachingElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "HostCaching");
        hostCachingElement.appendChild(requestDoc.createTextNode(parameters.getHostCaching()));
        dataVirtualHardDiskElement.appendChild(hostCachingElement);
        if (parameters.getLabel() != null) {
            Element diskLabelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DiskLabel");
            diskLabelElement.appendChild(requestDoc.createTextNode(parameters.getLabel()));
            dataVirtualHardDiskElement.appendChild(diskLabelElement);
        }
        if (parameters.getName() != null) {
            Element diskNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DiskName");
            diskNameElement.appendChild(requestDoc.createTextNode(parameters.getName()));
            dataVirtualHardDiskElement.appendChild(diskNameElement);
        }
        if (parameters.getLogicalUnitNumber() != null) {
            Element lunElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Lun");
            lunElement.appendChild(requestDoc.createTextNode(Integer.toString(parameters.getLogicalUnitNumber())));
            dataVirtualHardDiskElement.appendChild(lunElement);
        }
        Element logicalDiskSizeInGBElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LogicalDiskSizeInGB");
        logicalDiskSizeInGBElement.appendChild(requestDoc.createTextNode(Integer.toString(parameters.getLogicalDiskSizeInGB())));
        dataVirtualHardDiskElement.appendChild(logicalDiskSizeInGBElement);
        Element mediaLinkElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "MediaLink");
        mediaLinkElement.appendChild(requestDoc.createTextNode(parameters.getMediaLinkUri().toString()));
        dataVirtualHardDiskElement.appendChild(mediaLinkElement);
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<VirtualMachineDiskUpdateResponse> updateDiskAsync(final String name, final VirtualMachineDiskUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineDiskUpdateResponse>(){

            @Override
            public VirtualMachineDiskUpdateResponse call() throws Exception {
                return VirtualMachineDiskOperationsImpl.this.updateDisk(name, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineDiskUpdateResponse updateDisk(String name, VirtualMachineDiskUpdateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException, URISyntaxException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLabel() == null) {
            throw new NullPointerException("parameters.Label");
        }
        if (parameters.getName() == null) {
            throw new NullPointerException("parameters.Name");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("name", name);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"updateDiskAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/disks/" + name.trim();
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element diskElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Disk");
        requestDoc.appendChild(diskElement);
        if (parameters.isHasOperatingSystem() != null) {
            Element hasOperatingSystemElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "HasOperatingSystem");
            hasOperatingSystemElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isHasOperatingSystem()).toLowerCase()));
            diskElement.appendChild(hasOperatingSystemElement);
        }
        if (parameters.getOperatingSystemType() != null) {
            Element osElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "OS");
            osElement.appendChild(requestDoc.createTextNode(parameters.getOperatingSystemType()));
            diskElement.appendChild(osElement);
        }
        Element labelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Label");
        labelElement.appendChild(requestDoc.createTextNode(parameters.getLabel()));
        diskElement.appendChild(labelElement);
        if (parameters.getMediaLinkUri() != null) {
            Element mediaLinkElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "MediaLink");
            mediaLinkElement.appendChild(requestDoc.createTextNode(parameters.getMediaLinkUri().toString()));
            diskElement.appendChild(mediaLinkElement);
        }
        Element nameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
        nameElement.appendChild(requestDoc.createTextNode(parameters.getName()));
        diskElement.appendChild(nameElement);
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineDiskUpdateResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new VirtualMachineDiskUpdateResponse();
            DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
            documentBuilderFactory2.setNamespaceAware(true);
            DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
            Document responseDoc = documentBuilder2.parse((InputStream)new BOMInputStream(responseContent));
            Element diskElement2 = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"Disk");
            if (diskElement2 != null) {
                Element iOTypeElement;
                Element isPremiumElement;
                Element nameElement2;
                Element mediaLinkElement2;
                Element logicalDiskSizeInGBElement;
                Element locationElement;
                Element affinityGroupElement;
                Element labelElement2;
                Element osElement2 = XmlUtility.getElementByTagNameNS((Node)diskElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"OS");
                if (osElement2 != null) {
                    String osInstance = osElement2.getTextContent();
                    result.setOperatingSystem(osInstance);
                }
                if ((labelElement2 = XmlUtility.getElementByTagNameNS((Node)diskElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                    String labelInstance = labelElement2.getTextContent();
                    result.setLabel(labelInstance);
                }
                if ((affinityGroupElement = XmlUtility.getElementByTagNameNS((Node)diskElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"AffinityGroup")) != null) {
                    String affinityGroupInstance = affinityGroupElement.getTextContent();
                    result.setAffinityGroup(affinityGroupInstance);
                }
                if ((locationElement = XmlUtility.getElementByTagNameNS((Node)diskElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Location")) != null) {
                    String locationInstance = locationElement.getTextContent();
                    result.setLocation(locationInstance);
                }
                if ((logicalDiskSizeInGBElement = XmlUtility.getElementByTagNameNS((Node)diskElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"LogicalDiskSizeInGB")) != null) {
                    int logicalDiskSizeInGBInstance = DatatypeConverter.parseInt((String)logicalDiskSizeInGBElement.getTextContent());
                    result.setLogicalSizeInGB(logicalDiskSizeInGBInstance);
                }
                if ((mediaLinkElement2 = XmlUtility.getElementByTagNameNS((Node)diskElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"MediaLink")) != null) {
                    URI mediaLinkInstance = new URI(mediaLinkElement2.getTextContent());
                    result.setMediaLinkUri(mediaLinkInstance);
                }
                if ((nameElement2 = XmlUtility.getElementByTagNameNS((Node)diskElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                    String nameInstance = nameElement2.getTextContent();
                    result.setName(nameInstance);
                }
                if ((isPremiumElement = XmlUtility.getElementByTagNameNS((Node)diskElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsPremium")) != null && !(isPremiumElement.getTextContent() == null || isPremiumElement.getTextContent().isEmpty())) {
                    boolean isPremiumInstance = DatatypeConverter.parseBoolean((String)isPremiumElement.getTextContent().toLowerCase());
                    result.setIsPremium(isPremiumInstance);
                }
                if ((iOTypeElement = XmlUtility.getElementByTagNameNS((Node)diskElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"IOType")) != null) {
                    String iOTypeInstance = iOTypeElement.getTextContent();
                    result.setIOType(iOTypeInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualMachineDiskUpdateResponse virtualMachineDiskUpdateResponse = result;
            return virtualMachineDiskUpdateResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

