/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management;

import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.ManagementClientImpl;
import com.microsoft.windowsazure.management.RoleSizeOperations;
import com.microsoft.windowsazure.management.models.RoleSizeListResponse;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RoleSizeOperationsImpl
implements ServiceOperations<ManagementClientImpl>,
RoleSizeOperations {
    private ManagementClientImpl client;

    RoleSizeOperationsImpl(ManagementClientImpl client) {
        this.client = client;
    }

    public ManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<RoleSizeListResponse> listAsync() {
        return this.getClient().getExecutorService().submit(new Callable<RoleSizeListResponse>(){

            @Override
            public RoleSizeListResponse call() throws Exception {
                return RoleSizeOperationsImpl.this.list();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RoleSizeListResponse list() throws IOException, ServiceException, ParserConfigurationException, SAXException {
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap tracingParameters = new HashMap();
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/rolesizes";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            RoleSizeListResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new RoleSizeListResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
                Element roleSizesSequenceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleSizes");
                if (roleSizesSequenceElement != null) {
                    for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)roleSizesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleSize").size(); ++i1) {
                        Element virtualMachineResourceDiskSizeInMbElement;
                        Element webWorkerResourceDiskSizeInMbElement;
                        Element maxDataDiskCountElement;
                        Element supportedByVirtualMachinesElement;
                        Element supportedByWebWorkerRolesElement;
                        Element memoryInMbElement;
                        Element coresElement;
                        Element labelElement;
                        Element roleSizesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)roleSizesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleSize").get(i1);
                        RoleSizeListResponse.RoleSize roleSizeInstance = new RoleSizeListResponse.RoleSize();
                        result.getRoleSizes().add(roleSizeInstance);
                        Element nameElement = XmlUtility.getElementByTagNameNS((Node)roleSizesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                        if (nameElement != null) {
                            String nameInstance = nameElement.getTextContent();
                            roleSizeInstance.setName(nameInstance);
                        }
                        if ((labelElement = XmlUtility.getElementByTagNameNS((Node)roleSizesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                            String labelInstance = labelElement.getTextContent();
                            roleSizeInstance.setLabel(labelInstance);
                        }
                        if ((coresElement = XmlUtility.getElementByTagNameNS((Node)roleSizesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Cores")) != null) {
                            int coresInstance = DatatypeConverter.parseInt((String)coresElement.getTextContent());
                            roleSizeInstance.setCores(coresInstance);
                        }
                        if ((memoryInMbElement = XmlUtility.getElementByTagNameNS((Node)roleSizesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MemoryInMb")) != null) {
                            int memoryInMbInstance = DatatypeConverter.parseInt((String)memoryInMbElement.getTextContent());
                            roleSizeInstance.setMemoryInMb(memoryInMbInstance);
                        }
                        if ((supportedByWebWorkerRolesElement = XmlUtility.getElementByTagNameNS((Node)roleSizesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SupportedByWebWorkerRoles")) != null) {
                            boolean supportedByWebWorkerRolesInstance = DatatypeConverter.parseBoolean((String)supportedByWebWorkerRolesElement.getTextContent().toLowerCase());
                            roleSizeInstance.setSupportedByWebWorkerRoles(supportedByWebWorkerRolesInstance);
                        }
                        if ((supportedByVirtualMachinesElement = XmlUtility.getElementByTagNameNS((Node)roleSizesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SupportedByVirtualMachines")) != null) {
                            boolean supportedByVirtualMachinesInstance = DatatypeConverter.parseBoolean((String)supportedByVirtualMachinesElement.getTextContent().toLowerCase());
                            roleSizeInstance.setSupportedByVirtualMachines(supportedByVirtualMachinesInstance);
                        }
                        if ((maxDataDiskCountElement = XmlUtility.getElementByTagNameNS((Node)roleSizesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MaxDataDiskCount")) != null) {
                            int maxDataDiskCountInstance = DatatypeConverter.parseInt((String)maxDataDiskCountElement.getTextContent());
                            roleSizeInstance.setMaxDataDiskCount(maxDataDiskCountInstance);
                        }
                        if ((webWorkerResourceDiskSizeInMbElement = XmlUtility.getElementByTagNameNS((Node)roleSizesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"WebWorkerResourceDiskSizeInMb")) != null) {
                            int webWorkerResourceDiskSizeInMbInstance = DatatypeConverter.parseInt((String)webWorkerResourceDiskSizeInMbElement.getTextContent());
                            roleSizeInstance.setWebWorkerResourceDiskSizeInMb(webWorkerResourceDiskSizeInMbInstance);
                        }
                        if ((virtualMachineResourceDiskSizeInMbElement = XmlUtility.getElementByTagNameNS((Node)roleSizesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"VirtualMachineResourceDiskSizeInMb")) == null) continue;
                        int virtualMachineResourceDiskSizeInMbInstance = DatatypeConverter.parseInt((String)virtualMachineResourceDiskSizeInMbElement.getTextContent());
                        roleSizeInstance.setVirtualMachineResourceDiskSizeInMb(virtualMachineResourceDiskSizeInMbInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            RoleSizeListResponse roleSizeListResponse = result;
            return roleSizeListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

