/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLAbstractEntity;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLDevice;
import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLInfoGetter;
import com.nativelibs4java.opencl.CLMem;
import com.nativelibs4java.opencl.InfoName;
import com.nativelibs4java.opencl.JavaCL;
import com.nativelibs4java.opencl.ReusablePointers;
import com.nativelibs4java.opencl.library.OpenCLLibrary;
import java.util.EnumSet;
import org.bridj.Pointer;
import org.bridj.SizeT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLQueue
extends CLAbstractEntity {
    protected static CLInfoGetter infos = new CLInfoGetter(){

        @Override
        protected int getInfo(long entity, int infoTypeEnum, long size, Pointer out, Pointer<SizeT> sizeOut) {
            return JavaCL.CL.clGetCommandQueueInfo(entity, infoTypeEnum, size, Pointer.getPeer((Pointer)out), Pointer.getPeer(sizeOut));
        }
    };
    final CLContext context;
    final CLDevice device;
    volatile Boolean outOfOrder;

    CLQueue(CLContext context, long entity, CLDevice device) {
        super(entity);
        this.context = context;
        this.device = device;
    }

    public CLContext getContext() {
        return this.context;
    }

    public CLDevice getDevice() {
        return this.device;
    }

    public synchronized boolean isOutOfOrder() {
        if (this.outOfOrder == null) {
            this.outOfOrder = this.getProperties().contains((Object)CLDevice.QueueProperties.OutOfOrderExecModeEnable);
        }
        return this.outOfOrder;
    }

    @InfoName(value="CL_QUEUE_PROPERTIES")
    public EnumSet<CLDevice.QueueProperties> getProperties() {
        return CLDevice.QueueProperties.getEnumSet(infos.getIntOrLong(this.getEntity(), 4243));
    }

    public void setProperty(CLDevice.QueueProperties property, boolean enabled) {
        CLException.error(JavaCL.CL.clSetCommandQueueProperty(this.getEntity(), property.value(), enabled ? 1 : 0, 0L));
    }

    @Override
    protected void clear() {
        CLException.error(JavaCL.CL.clReleaseCommandQueue(this.getEntity()));
    }

    public void finish() {
        CLException.error(JavaCL.CL.clFinish(this.getEntity()));
    }

    public void flush() {
        CLException.error(JavaCL.CL.clFlush(this.getEntity()));
    }

    public void enqueueWaitForEvents(CLEvent ... eventsToWaitFor) {
        ReusablePointers ptrs = ReusablePointers.get();
        int[] eventsInCount = new int[1];
        Pointer eventsIn = CLAbstractEntity.copyNonNullEntities(eventsToWaitFor, eventsInCount, ptrs.events_in);
        if (eventsIn == null) {
            return;
        }
        CLException.error(JavaCL.CL.clEnqueueWaitForEvents(this.getEntity(), eventsInCount[0], Pointer.getPeer(eventsIn)));
    }

    public void enqueueBarrier() {
        CLException.error(JavaCL.CL.clEnqueueBarrier(this.getEntity()));
    }

    public CLEvent enqueueMarker() {
        ReusablePointers ptrs = ReusablePointers.get();
        Pointer<OpenCLLibrary.cl_event> eventOut = ptrs.event_out;
        CLException.error(JavaCL.CL.clEnqueueMarker(this.getEntity(), Pointer.getPeer(eventOut)));
        return CLEvent.createEventFromPointer(this, eventOut);
    }

    public CLEvent enqueueAcquireGLObjects(CLMem[] objects, CLEvent ... eventsToWaitFor) {
        ReusablePointers ptrs = ReusablePointers.get();
        int[] eventsInCount = new int[1];
        Pointer eventsIn = CLAbstractEntity.copyNonNullEntities(eventsToWaitFor, eventsInCount, ptrs.events_in);
        Pointer<OpenCLLibrary.cl_event> eventOut = eventsToWaitFor == null || CLEvent.containsFireAndForget(eventsToWaitFor) ? null : ptrs.event_out;
        Pointer mems = Pointer.allocateSizeTs((long)objects.length);
        for (int i = 0; i < objects.length; ++i) {
            mems.setSizeTAtIndex((long)i, objects[i].getEntity());
        }
        CLException.error(JavaCL.CL.clEnqueueAcquireGLObjects(this.getEntity(), objects.length, Pointer.getPeer((Pointer)mems), eventsInCount[0], Pointer.getPeer(eventsIn), Pointer.getPeer(eventOut)));
        return CLEvent.createEventFromPointer(this, eventOut);
    }

    public CLEvent enqueueReleaseGLObjects(CLMem[] objects, CLEvent ... eventsToWaitFor) {
        ReusablePointers ptrs = ReusablePointers.get();
        int[] eventsInCount = new int[1];
        Pointer eventsIn = CLAbstractEntity.copyNonNullEntities(eventsToWaitFor, eventsInCount, ptrs.events_in);
        Pointer<OpenCLLibrary.cl_event> eventOut = eventsToWaitFor == null || CLEvent.containsFireAndForget(eventsToWaitFor) ? null : ptrs.event_out;
        Pointer mems = CLQueue.getEntities((CLAbstractEntity[])objects, (Pointer)Pointer.allocateSizeTs((long)objects.length));
        CLException.error(JavaCL.CL.clEnqueueReleaseGLObjects(this.getEntity(), objects.length, Pointer.getPeer((Pointer)mems), eventsInCount[0], Pointer.getPeer(eventsIn), Pointer.getPeer(eventOut)));
        return CLEvent.createEventFromPointer(this, eventOut);
    }
}

