/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.common.nacos.configuration;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import com.nepxion.discovery.common.nacos.operation.NacosOperation;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class NacosAutoConfiguration {
    @Autowired
    private Environment environment;

    @Bean
    @ConditionalOnMissingBean
    public ConfigService nacosConfigService() throws NacosException {
        Properties properties = NacosAutoConfiguration.createNacosProperties(this.environment, true);
        return NacosFactory.createConfigService((Properties)properties);
    }

    @Bean
    public NacosOperation nacosOperation() {
        return new NacosOperation();
    }

    public static Properties createNacosProperties(Environment environment, boolean enableRemoteSyncConfig) {
        String ramRoleName;
        String namingPollingThreadCount;
        String namingClientBeatThreadCount;
        String namingLoadCacheAtStart;
        String encode;
        String isUseCloudNamespaceParsing;
        String isUseEndpointParsingRule;
        String endpointPort;
        String endpoint;
        String maxRetry;
        String configRetryTime;
        String configLongPollTimeout;
        String contextPath;
        String clusterName;
        String namespace;
        String password;
        String username;
        String secretKey;
        Properties properties = new Properties();
        String serverAddr = environment.getProperty("nacos.server-addr");
        if (!StringUtils.isNotEmpty((CharSequence)serverAddr)) {
            throw new IllegalArgumentException("nacos.server-addr can't be null or empty");
        }
        properties.put("serverAddr", serverAddr);
        String accessKey = environment.getProperty("nacos.access-key");
        if (StringUtils.isNotEmpty((CharSequence)accessKey)) {
            properties.put("accessKey", accessKey);
        }
        if (StringUtils.isNotEmpty((CharSequence)(secretKey = environment.getProperty("nacos.secret-key")))) {
            properties.put("secretKey", secretKey);
        }
        if (StringUtils.isNotEmpty((CharSequence)(username = environment.getProperty("nacos.username")))) {
            properties.put("username", username);
        }
        if (StringUtils.isNotEmpty((CharSequence)(password = environment.getProperty("nacos.password")))) {
            properties.put("password", password);
        }
        if (StringUtils.isNotEmpty((CharSequence)(namespace = environment.getProperty("nacos.plugin.namespace")))) {
            properties.put("namespace", namespace);
        }
        if (StringUtils.isNotEmpty((CharSequence)(clusterName = environment.getProperty("nacos.plugin.cluster-name")))) {
            properties.put("clusterName", clusterName);
        }
        if (StringUtils.isNotEmpty((CharSequence)(contextPath = environment.getProperty("nacos.plugin.context-path")))) {
            properties.put("contextPath", contextPath);
        }
        if (StringUtils.isNotEmpty((CharSequence)(configLongPollTimeout = environment.getProperty("nacos.plugin.config-long-poll-timeout")))) {
            properties.put("configLongPollTimeout", configLongPollTimeout);
        }
        if (StringUtils.isNotEmpty((CharSequence)(configRetryTime = environment.getProperty("nacos.plugin.config-retry-time")))) {
            properties.put("configRetryTime", configRetryTime);
        }
        if (StringUtils.isNotEmpty((CharSequence)(maxRetry = environment.getProperty("nacos.plugin.max-retry")))) {
            properties.put("maxRetry", maxRetry);
        }
        if (StringUtils.isNotEmpty((CharSequence)(endpoint = environment.getProperty("nacos.plugin.endpoint")))) {
            properties.put("endpoint", endpoint);
        }
        if (StringUtils.isNotEmpty((CharSequence)(endpointPort = environment.getProperty("nacos.plugin.endpoint-port")))) {
            properties.put("endpointPort", endpointPort);
        }
        if (StringUtils.isNotEmpty((CharSequence)(isUseEndpointParsingRule = environment.getProperty("nacos.plugin.is-use-endpoint-parsing-rule")))) {
            properties.put("isUseEndpointParsingRule", isUseEndpointParsingRule);
        }
        if (StringUtils.isNotEmpty((CharSequence)(isUseCloudNamespaceParsing = environment.getProperty("nacos.plugin.is-use-cloud-namespace-parsing")))) {
            properties.put("isUseCloudNamespaceParsing", isUseCloudNamespaceParsing);
        }
        if (StringUtils.isNotEmpty((CharSequence)(encode = environment.getProperty("nacos.plugin.encode")))) {
            properties.put("encode", encode);
        }
        if (StringUtils.isNotEmpty((CharSequence)(namingLoadCacheAtStart = environment.getProperty("nacos.plugin.naming-load-cache-at-start")))) {
            properties.put("namingLoadCacheAtStart", namingLoadCacheAtStart);
        }
        if (StringUtils.isNotEmpty((CharSequence)(namingClientBeatThreadCount = environment.getProperty("nacos.plugin.naming-client-beat-thread-count")))) {
            properties.put("namingClientBeatThreadCount", namingClientBeatThreadCount);
        }
        if (StringUtils.isNotEmpty((CharSequence)(namingPollingThreadCount = environment.getProperty("nacos.plugin.naming-polling-thread-count")))) {
            properties.put("namingPollingThreadCount", namingPollingThreadCount);
        }
        if (StringUtils.isNotEmpty((CharSequence)(ramRoleName = environment.getProperty("nacos.plugin.ram-role-name")))) {
            properties.put("ramRoleName", ramRoleName);
        }
        properties.put("enableRemoteSyncConfig", Boolean.toString(enableRemoteSyncConfig));
        return properties;
    }
}

