/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.common.nacos.operation;

import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.nepxion.discovery.common.nacos.operation.NacosSubscribeCallback;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public class NacosOperation {
    @Autowired
    private ConfigService nacosConfigService;
    @Autowired
    private Environment environment;

    public String getConfig(String group, String serviceId) throws NacosException {
        long timeout = (Long)this.environment.getProperty("nacos.plugin.timout", Long.class, (Object)30000L);
        return this.nacosConfigService.getConfig(serviceId, group, timeout);
    }

    public boolean removeConfig(String group, String serviceId) throws NacosException {
        return this.nacosConfigService.removeConfig(serviceId, group);
    }

    public boolean publishConfig(String group, String serviceId, String config) throws NacosException {
        return this.nacosConfigService.publishConfig(serviceId, group, config);
    }

    public Listener subscribeConfig(String group, String serviceId, final Executor executor, final NacosSubscribeCallback subscribeCallback) throws NacosException {
        Listener configListener = new Listener(){

            public void receiveConfigInfo(String config) {
                subscribeCallback.callback(config);
            }

            public Executor getExecutor() {
                return executor;
            }
        };
        this.nacosConfigService.addListener(serviceId, group, configListener);
        return configListener;
    }

    public void unsubscribeConfig(String group, String serviceId, Listener configListener) {
        this.nacosConfigService.removeListener(serviceId, group, configListener);
    }
}

