/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.matrix.selector;

import com.nepxion.banner.Description;
import com.nepxion.banner.LogoBanner;
import com.nepxion.banner.NepxionBanner;
import com.taobao.text.Color;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.DeferredImportSelector;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;

public abstract class AbstractImportSelector<T>
implements DeferredImportSelector,
BeanClassLoaderAware,
EnvironmentAware {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractImportSelector.class);
    private ClassLoader beanClassLoader;
    private Class<T> annotationClass = GenericTypeResolver.resolveTypeArgument(this.getClass(), AbstractImportSelector.class);
    private Environment environment;

    protected AbstractImportSelector() {
    }

    public String[] selectImports(AnnotationMetadata metadata) {
        if (!this.isEnabled()) {
            return new String[0];
        }
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(this.annotationClass.getName(), true));
        Assert.notNull((Object)attributes, (String)("No " + this.getSimpleName() + " attributes found. Is " + metadata.getClassName() + " annotated with @" + this.getSimpleName() + "?"));
        ArrayList factories = new ArrayList(new LinkedHashSet(SpringFactoriesLoader.loadFactoryNames(this.annotationClass, (ClassLoader)this.beanClassLoader)));
        if (factories.isEmpty() && !this.hasDefaultFactory()) {
            throw new IllegalStateException("Annotation @" + this.getSimpleName() + " found, but there are no implementations. Did you forget to include a starter?");
        }
        if (factories.size() > 1) {
            LOG.warn("More than one implementation of @" + this.getSimpleName() + " (now relying on @Conditionals to pick one): " + factories);
        }
        return factories.toArray(new String[factories.size()]);
    }

    protected boolean hasDefaultFactory() {
        return false;
    }

    protected String getSimpleName() {
        return this.annotationClass.getSimpleName();
    }

    protected Class<T> getAnnotationClass() {
        return this.annotationClass;
    }

    protected Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    protected abstract boolean isEnabled();

    static {
        LogoBanner logoBanner = new LogoBanner(AbstractImportSelector.class, "/com/nepxion/matrix/resource/logo.txt", "Welcome to Nepxion", 6, 5, new Color[]{Color.red, Color.green, Color.cyan, Color.blue, Color.yellow, Color.magenta}, true);
        NepxionBanner.show((LogoBanner)logoBanner, (Description[])new Description[]{new Description("Version:", "2.0.8", 0, 1), new Description("Plugin:", "Import Selector", 0, 1), new Description("Github:", "https://github.com/Nepxion/Matrix", 0, 1)});
    }
}

