/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.geometry;

import java.sql.SQLException;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.NUMBER;

class SdoPickler {
    static final short KOPI20_LN_ELNL = 255;
    static final short KOPI20_LN_5BLN = 254;
    static final short KOPI20_LN_ATMN = 253;
    static final short KOPI20_LN_IEMN = 252;
    static final short KOPI20_LN_MAXV = 245;
    static final short KOPI20_IF_IS81 = 128;
    static final short KOPI20_IF_CMSB = 64;
    static final short KOPI20_IF_CLSB = 32;
    static final short KOPI20_IF_DEGN = 16;
    static final short KOPI20_IF_COLL = 8;
    static final short KOPI20_IF_NOPS = 4;
    static final short KOPI20_IF_ANY = 2;
    static final short KOPI20_IF_NONL = 1;
    static final short KOPI20_CF_CMSB = 64;
    static final short KOPI20_CF_CLSB = 32;
    static final short KOPI20_CF_INDX = 16;
    static final short KOPI20_CF_NOLN = 8;
    static final short KOPI20_VERSION = 1;
    static final int LNXDIGS = 20;
    static final int LNXSGNBT = 128;
    static final int LNXEXPBS = 64;
    static final int LNXEXPMX = 127;
    static final int LNXBASE = 100;
    static final int BIG_LEN_MAX = 22;
    static final int IMAGE_LEN_5 = 5;
    static final int COLLECTION_PREFIX_LEN = 20;
    static final int LNXEXPMN = 0;
    static final double ORANUM_FBASE = 100.0;
    private static final double[][] powerTable = new double[][]{{128.0, 1.0E256, 1.0E-256}, {64.0, 1.0E128, 1.0E-128}, {32.0, 1.0E64, 1.0E-64}, {16.0, 1.0E32, 1.0E-32}, {8.0, 1.0E16, 1.0E-16}, {4.0, 1.0E8, 1.0E-8}, {2.0, 10000.0, 1.0E-4}, {1.0, 100.0, 0.01}};

    SdoPickler() {
    }

    static final JGeometry unpickle(byte[] byArray) throws SQLException {
        if (byArray == null || byArray.length < 7) {
            throw new SQLException("Invalid geometry image");
        }
        UnpickleHelper unpickleHelper = new UnpickleHelper(byArray);
        unpickleHelper.checkImageHeader();
        unpickleHelper.skipLength();
        int n = SdoPickler.getInt(unpickleHelper);
        int n2 = SdoPickler.getInt0(unpickleHelper);
        boolean bl = false;
        double d = Double.NaN;
        double d2 = Double.NaN;
        double d3 = Double.NaN;
        if ((byArray[unpickleHelper.offset] & 0xFF) == 253) {
            bl = false;
            ++unpickleHelper.offset;
        } else {
            bl = true;
            d = SdoPickler.getDouble0(unpickleHelper);
            d2 = SdoPickler.getDouble0(unpickleHelper);
            d3 = SdoPickler.getDouble0(unpickleHelper);
            if (Double.isNaN(d) || Double.isNaN(d2)) {
                d = Double.NaN;
                d2 = Double.NaN;
            }
        }
        int[] nArray = SdoPickler.getElemInfoArray(unpickleHelper);
        double[] dArray = SdoPickler.getOrdinates(unpickleHelper, n);
        if (dArray != null && nArray != null) {
            return new JGeometry(n, n2, d, d2, d3, nArray, dArray);
        }
        if (!Double.isNaN(d) && !Double.isNaN(d2)) {
            if (!Double.isNaN(d3)) {
                return new JGeometry(d, d2, d3, n2);
            }
            return new JGeometry(d, d2, n2);
        }
        return new JGeometry(n, n2, nArray, dArray);
    }

    private static final int getInt0(UnpickleHelper unpickleHelper) throws SQLException {
        int n;
        byte by;
        byte[] byArray = unpickleHelper.image;
        if ((by = byArray[n = unpickleHelper.offset++]) <= 0) {
            return 0;
        }
        unpickleHelper.offset += 1 + by;
        if (by == 1 && byArray[n + 1] == -128) {
            return 0;
        }
        byte[] byArray2 = new byte[by];
        System.arraycopy(byArray, n + 1, byArray2, 0, by);
        return NUMBER.toInt((byte[])byArray2);
    }

    private static final int getInt(UnpickleHelper unpickleHelper) throws SQLException {
        byte[] byArray = unpickleHelper.image;
        int n = unpickleHelper.offset;
        byte by = byArray[n];
        if (by <= 0) {
            throw new SQLException("Invalid NULL value is found in sdo_gtype or sdo_elem_info");
        }
        unpickleHelper.offset += 1 + by;
        if (by == 1 && byArray[n + 1] == -128) {
            return 0;
        }
        byte[] byArray2 = new byte[by];
        System.arraycopy(byArray, n + 1, byArray2, 0, by);
        return NUMBER.toInt((byte[])byArray2);
    }

    private static final double getDouble0(UnpickleHelper unpickleHelper) {
        int n;
        byte by;
        byte[] byArray = unpickleHelper.image;
        if ((by = byArray[n = unpickleHelper.offset++]) <= 0) {
            return Double.NaN;
        }
        unpickleHelper.offset += 1 + by;
        if (by == 1 && byArray[n + 1] == -128) {
            return 0.0;
        }
        byte[] byArray2 = new byte[by];
        System.arraycopy(byArray, n + 1, byArray2, 0, by);
        return NUMBER.toDouble((byte[])byArray2);
    }

    private static final double getDouble(UnpickleHelper unpickleHelper) throws SQLException {
        double d = SdoPickler.getDouble0(unpickleHelper);
        if (Double.isNaN(d)) {
            throw new SQLException("An invalid NULL value is found in sdo_ordinates");
        }
        return d;
    }

    private static final int[] getElemInfoArray(UnpickleHelper unpickleHelper) throws SQLException {
        byte by = unpickleHelper.readByte();
        if ((by & 0xFF) == 255) {
            return null;
        }
        unpickleHelper.skipRestOfLength(by);
        unpickleHelper.checkArrayHeader();
        unpickleHelper.readByte();
        int n = unpickleHelper.readLength();
        if (n < 0) {
            return null;
        }
        if (n % 3 != 0) {
            throw new SQLException("Corrupted element info array");
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = SdoPickler.getInt(unpickleHelper);
        }
        return nArray;
    }

    private static final double[] getOrdinates(UnpickleHelper unpickleHelper, int n) throws SQLException {
        byte by = unpickleHelper.readByte();
        if ((by & 0xFF) == 255) {
            return null;
        }
        unpickleHelper.skipRestOfLength(by);
        unpickleHelper.checkArrayHeader();
        unpickleHelper.readByte();
        int n2 = unpickleHelper.readLength();
        if (n2 < 0) {
            return null;
        }
        double[] dArray = new double[n2];
        if (n % 1000 / 100 == 0) {
            for (int i = 0; i < n2; ++i) {
                dArray[i] = SdoPickler.getDouble(unpickleHelper);
            }
        } else {
            int n3;
            int n4 = n % 1000 / 100;
            int n5 = n3 = n / 1000 > 0 ? n / 1000 : 2;
            if (n3 != 2 && (n3 == 3 && n3 == n4 || n3 == 4 && (n4 == 3 || n4 == 4))) {
                for (int i = 0; i < n2; ++i) {
                    dArray[i] = SdoPickler.getDouble0(unpickleHelper);
                    if (dArray[i] != Double.NaN || i % n3 == n4 - 1) continue;
                    throw new SQLException("An invalid null value is found in LRS sdo_ordinates");
                }
            } else {
                throw new SQLException("An invalid sdo_gtype is found");
            }
        }
        return dArray;
    }

    static final byte[] pickle(JGeometry jGeometry) throws SQLException {
        int n;
        if (jGeometry == null) {
            throw new SQLException("Found null geometry");
        }
        int n2 = jGeometry.gtype + jGeometry.linfo * 100 + jGeometry.dim * 1000;
        byte[] byArray = NUMBER.toBytes((int)n2);
        int n3 = 1 + byArray.length;
        byte[] byArray2 = new byte[]{-1};
        int n4 = 1;
        if (jGeometry.srid != 0) {
            byArray2 = NUMBER.toBytes((int)jGeometry.srid);
            n4 += byArray2.length;
        }
        if (jGeometry.gtype == 1 && jGeometry.dim == 3 && Double.isNaN(jGeometry.z)) {
            throw new SQLException("Invalid z value in the JGeometry instance.");
        }
        byte[] byArray3 = new byte[]{-3};
        int n5 = 1;
        int n6 = 1;
        byte[] byArray4 = null;
        byte[] byArray5 = new byte[]{-1};
        if (jGeometry.gtype == 1 && !Double.isNaN(jGeometry.x) && !Double.isNaN(jGeometry.y)) {
            n5 = 2;
            byArray3 = SdoPickler.toBytes(jGeometry.x);
            n6 = 1 + byArray3.length;
            byArray4 = SdoPickler.toBytes(jGeometry.y);
            n6 += 2 + byArray4.length;
            if (jGeometry.dim == 3) {
                byArray5 = SdoPickler.toBytes(jGeometry.z);
                n5 = 3;
                n6 += byArray5.length;
            }
        }
        byte[] byArray6 = new byte[]{-1};
        int n7 = 1;
        if (jGeometry.elemInfo != null && jGeometry.elemInfo.length > 0) {
            byArray6 = new byte[20 + jGeometry.elemInfo.length * 22];
            n7 = 20;
            for (n = 0; n < jGeometry.elemInfo.length; ++n) {
                byte[] byArray7 = NUMBER.toBytes((int)jGeometry.elemInfo[n]);
                byArray6[n7] = (byte)byArray7.length;
                System.arraycopy(byArray7, 0, byArray6, n7 + 1, byArray7.length);
                n7 += byArray7.length + 1;
            }
            byArray6[5] = -120;
            byArray6[6] = 1;
            SdoPickler.writeLength5(n7 - 5, byArray6, 7);
            byArray6[12] = 1;
            byArray6[13] = 1;
            byArray6[14] = 0;
            SdoPickler.writeLength5(jGeometry.elemInfo.length, byArray6, 15);
            SdoPickler.writeLength5(n7 - 5, byArray6, 0);
        }
        int n8 = 7 + n3 + n4 + n6 + n7;
        n = jGeometry.ordinates != null && jGeometry.ordinates.length > 0 ? 20 + jGeometry.ordinates.length * 22 : 1;
        byte[] byArray8 = new byte[n8 + n];
        byArray8[0] = -124;
        byArray8[1] = 1;
        SdoPickler.writeLength5(n8 + n, byArray8, 2);
        int n9 = 7;
        byArray8[n9] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray8, n9 + 1, byArray.length);
        n9 += byArray.length + 1;
        if (jGeometry.srid != 0) {
            byArray8[n9++] = (byte)byArray2.length;
        }
        System.arraycopy(byArray2, 0, byArray8, n9, byArray2.length);
        n9 += byArray2.length;
        if (n5 == 1) {
            System.arraycopy(byArray3, 0, byArray8, n9++, 1);
        } else {
            byArray8[n9++] = (byte)byArray3.length;
            System.arraycopy(byArray3, 0, byArray8, n9, byArray3.length);
            n9 += byArray3.length;
            byArray8[n9++] = (byte)byArray4.length;
            System.arraycopy(byArray4, 0, byArray8, n9, byArray4.length);
            n9 += byArray4.length;
            if (n5 == 3) {
                byArray8[n9++] = (byte)byArray5.length;
                System.arraycopy(byArray5, 0, byArray8, n9, byArray5.length);
                n9 += byArray5.length;
            } else {
                System.arraycopy(byArray5, 0, byArray8, n9++, 1);
            }
        }
        System.arraycopy(byArray6, 0, byArray8, n9, n7);
        n9 += n7;
        int n10 = 1;
        if (jGeometry.ordinates != null && jGeometry.ordinates.length > 0) {
            n10 = 20;
            int n11 = 0;
            if (jGeometry.linfo == 0) {
                for (int i = 0; i < jGeometry.ordinates.length; ++i) {
                    byte[] byArray9 = SdoPickler.toBytes(jGeometry.ordinates[i]);
                    n11 = n9 + n10;
                    byArray8[n11] = (byte)byArray9.length;
                    System.arraycopy(byArray9, 0, byArray8, n11 + 1, byArray9.length);
                    n10 += byArray9.length + 1;
                }
            } else {
                if (jGeometry.dim == 2 || jGeometry.dim == 3 && jGeometry.linfo != 3 || jGeometry.dim == 4 && jGeometry.linfo != 3 && jGeometry.linfo != 4) {
                    throw new SQLException("An invalid gtype value for LRS is found.");
                }
                for (int i = 0; i < jGeometry.ordinates.length; ++i) {
                    if (Double.isNaN(jGeometry.ordinates[i]) && i % jGeometry.dim != jGeometry.linfo - 1) {
                        throw new SQLException("An invalid Double.NaN value is found in LRS ordinates");
                    }
                    if (Double.isNaN(jGeometry.ordinates[i])) {
                        byArray8[n9 + n10] = -1;
                        ++n10;
                        continue;
                    }
                    byte[] byArray10 = SdoPickler.toBytes(jGeometry.ordinates[i]);
                    n11 = n9 + n10;
                    byArray8[n11] = (byte)byArray10.length;
                    System.arraycopy(byArray10, 0, byArray8, n11 + 1, byArray10.length);
                    n10 += byArray10.length + 1;
                }
            }
            byArray8[n9 + 5] = -120;
            byArray8[n9 + 6] = 1;
            SdoPickler.writeLength5(n10 - 5, byArray8, n9 + 7);
            byArray8[n9 + 12] = 1;
            byArray8[n9 + 13] = 1;
            byArray8[n9 + 14] = 0;
            SdoPickler.writeLength5(jGeometry.ordinates.length, byArray8, n9 + 15);
            SdoPickler.writeLength5(n10 - 5, byArray8, n9);
        } else {
            byArray8[n9] = -1;
        }
        SdoPickler.writeLength5(n8 += n10, byArray8, 2);
        return byArray8;
    }

    private static void writeLength5(int n, byte[] byArray, int n2) {
        byArray[n2] = -2;
        byArray[n2 + 1] = (byte)(n >> 24);
        byArray[n2 + 2] = (byte)((n &= 0xFFFFFF) >> 16);
        byArray[n2 + 3] = (byte)((n &= 0xFFFF) >> 8);
        byArray[n2 + 4] = (byte)(n &= 0xFF);
    }

    private static byte[] toBytes(double d) throws SQLException {
        int n;
        int n2;
        int n3;
        int n4;
        byte[] byArray = new byte[20];
        int n5 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n6 = 0;
        int n7 = 0;
        boolean bl5 = !(d < 0.0);
        d = Math.abs(d);
        String string = Double.toString(d);
        n6 = string.length();
        n7 = string.indexOf(69);
        if (n7 != -1) {
            if (n7 == n7 / 2 * 2) {
                bl = true;
            }
            if ((n4 = (n5 = Integer.valueOf(string.substring(n7 + 1, n6)).intValue()) != n5 / 2 * 2 ? n5 / 2 + 1 : n5 / 2) > 62) {
                throw new SQLException("Overflow");
            }
            if (n4 < -65) {
                throw new SQLException("Underflow");
            }
            if (n5 != n5 / 2 * 2) {
                ++n5;
                bl4 = true;
                bl = !bl;
            }
            n3 = bl ? (byte)(n7 / 2) : (byte)((n7 + 1) / 2);
            if (bl4) {
                byArray[0] = (byte)Integer.parseInt(string.substring(0, 1) + string.substring(2, 3));
                n4 = 3;
            } else {
                byArray[0] = (byte)Integer.parseInt(string.substring(0, 1));
                n4 = 2;
            }
            if (n7 <= 3) {
                if (n3 == 2) {
                    byArray[1] = (byte)(Integer.parseInt(string.substring(2, 3)) * 10);
                }
            } else {
                for (n2 = 1; n2 < n3 - 1; ++n2) {
                    byArray[n2] = (byte)Integer.parseInt(string.substring(n4, n4 + 2));
                    n4 += 2;
                }
                byArray[n3 - 1] = bl ? (byte)Integer.parseInt(string.substring(n7 - 2, n7)) : (byte)(Integer.parseInt(string.substring(n7 - 1, n7)) * 10);
            }
            n5 /= 2;
            for (n2 = n3 - 1; n2 != 0 && byArray[n2] == 0; --n2) {
                n3 = (byte)(n3 - 1);
            }
        } else if (n6 >= 17) {
            if (d < 1.0) {
                for (n4 = 0; n4 < 8; ++n4) {
                    if (!(powerTable[n4][2] >= d)) continue;
                    n5 -= (int)powerTable[n4][0];
                    d *= powerTable[n4][1];
                }
                if (d < 1.0) {
                    --n5;
                    d *= 100.0;
                }
            } else {
                for (n4 = 0; n4 < 8; ++n4) {
                    if (!(powerTable[n4][1] <= d)) continue;
                    n5 += (int)powerTable[n4][0];
                    d *= powerTable[n4][2];
                }
            }
            if (n5 > 62) {
                throw new SQLException("Overflow");
            }
            if (n5 < -65) {
                throw new SQLException("Underflow");
            }
            boolean bl6 = d >= 10.0;
            n = string.indexOf(46);
            if (n == -1) {
                throw new SQLException("Invalid double value found: " + string);
            }
            n4 = n6 - n - 1;
            bl = n4 == n4 / 2 * 2;
            StringBuffer stringBuffer = new StringBuffer(20);
            for (n4 = 0; n4 < n6 && (n4 == n || string.charAt(n4) == '0'); ++n4) {
            }
            while (n4 < n6) {
                if (n4 != n) {
                    stringBuffer.append(string.charAt(n4));
                }
                ++n4;
            }
            String string2 = stringBuffer.toString();
            n7 = string2.length();
            n3 = (byte)((n7 + 1) / 2);
            if (n7 == 1) {
                byArray[0] = bl6 ? (byte)(Integer.parseInt(string2.substring(0, 1)) * 10) : (byte)Integer.parseInt(string2.substring(0, 1));
            } else if (n7 == 2) {
                if (bl6) {
                    byArray[0] = (byte)Integer.parseInt(string2.substring(0, 2));
                } else if (string2.charAt(1) == '0') {
                    byArray[0] = (byte)Integer.parseInt(string2.substring(0, 1));
                } else {
                    n3 = (byte)(n3 + 1);
                    byArray[0] = (byte)Integer.parseInt(string2.substring(0, 1));
                    byArray[1] = (byte)(Integer.parseInt(string2.substring(1, 2)) * 10);
                }
            } else {
                if (!bl6 && n7 == n7 / 2 * 2) {
                    n3 = (byte)(n3 + 1);
                }
                if (bl6) {
                    byArray[0] = (byte)Integer.parseInt(string2.substring(0, 2));
                    n4 = 2;
                } else {
                    byArray[0] = (byte)Integer.parseInt(string.substring(0, 1));
                    n4 = 1;
                }
                for (n2 = 1; n2 < n3 - 1; ++n2) {
                    byArray[n2] = (byte)Integer.parseInt(string2.substring(n4, n4 + 2));
                    n4 += 2;
                }
                byArray[n3 - 1] = bl ? (byte)Integer.parseInt(string.substring(n6 - 2, n6)) : (byte)(Integer.parseInt(string.substring(n6 - 1, n6)) * 10);
                for (n2 = n3 - 1; n2 != 0 && byArray[n2] == 0; --n2) {
                    n3 = (byte)(n3 - 1);
                }
            }
        } else {
            if (d < 1.0) {
                for (n4 = 0; n4 < 8; ++n4) {
                    if (!(powerTable[n4][2] >= d)) continue;
                    n5 -= (int)powerTable[n4][0];
                    d *= powerTable[n4][1];
                }
                if (d < 1.0) {
                    --n5;
                    d *= 100.0;
                }
            } else {
                for (n4 = 0; n4 < 8; ++n4) {
                    if (!(powerTable[n4][1] <= d)) continue;
                    n5 += (int)powerTable[n4][0];
                    d *= powerTable[n4][2];
                }
            }
            if (n5 != 256 && n5 > 62) {
                System.out.println(" exponent = " + n5 + " lnxexpmx - lNXEXPBS -1 = " + 62);
                throw new SQLException("Overflow");
            }
            if (n5 != -256 && n5 < -65) {
                System.out.println(" value = " + d + " exponent = " + n5 + " LNXEXPMN - LNXEXPBS -1 = " + -65);
                throw new SQLException("Underflow");
            }
            bl = !(d >= 10.0);
            n3 = 8;
            byte by = (byte)d;
            for (n2 = 0; n2 < n3; ++n2) {
                byArray[n2] = by;
                d = (d - (double)by) * 100.0;
                by = (byte)d;
            }
            n2 = 7;
            if (bl) {
                if (by >= 50) {
                    int n8 = n2;
                    byArray[n8] = (byte)(byArray[n8] + 1);
                }
            } else {
                byArray[n2] = n5 == 62 && (byArray[n2] + 5) / 10 * 10 == 100 ? (byte)((byArray[n2] - 5) / 10 * 10) : (byte)((byArray[n2] + 5) / 10 * 10);
            }
            while (byArray[n2] == 100) {
                if (n2 == 0) {
                    ++n5;
                    byArray[n2] = 1;
                    break;
                }
                byArray[n2] = 0;
                int n9 = --n2;
                byArray[n9] = (byte)(byArray[n9] + 1);
            }
            for (n2 = 7; n2 != 0 && byArray[n2] == 0; --n2) {
                n3 = (byte)(n3 - 1);
            }
        }
        if (bl5) {
            n = n3 + 1;
            byte[] byArray2 = new byte[n];
            byArray2[0] = (byte)(n5 + 128 + 64 + 1);
            if (bl4) {
                byArray2[0] = (byte)(byArray2[0] - 1);
            }
            for (n4 = 1; n4 < n; ++n4) {
                byArray2[n4] = (byte)(byArray[n4 - 1] + 1);
            }
            return byArray2;
        }
        n = n3 < 20 ? n3 + 2 : n3 + 1;
        byte[] byArray3 = new byte[n];
        byArray3[0] = (byte)(~(n5 + 128 + 64 + 1));
        if (bl4) {
            byArray3[0] = (byte)(byArray3[0] + 1);
        }
        for (n4 = 1; n4 < n; ++n4) {
            byArray3[n4] = (byte)(101 - byArray[n4 - 1]);
        }
        if (n3 < 20) {
            byArray3[n - 1] = 102;
        }
        return byArray3;
    }

    private static final class UnpickleHelper {
        byte[] image = null;
        int offset = 0;

        protected UnpickleHelper(byte[] byArray) {
            this.image = byArray;
            this.offset = 0;
        }

        protected UnpickleHelper(byte[] byArray, int n) {
            this.image = byArray;
            this.offset = n;
        }

        protected int getOffset() {
            return this.offset;
        }

        protected byte[] getImage() {
            return this.image;
        }

        protected byte readByte() {
            byte by = this.image[this.offset];
            ++this.offset;
            return by;
        }

        protected byte[] readBytes(int n) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.image, this.offset, byArray, 0, n);
            this.offset += n;
            return byArray;
        }

        protected final void checkImageHeader() throws SQLException {
            byte by = this.image[0];
            if ((by & 0xFF & 0x80) == 0) {
                throw new SQLException("Image is not in 8.1 format");
            }
            if ((by & 0xFF & 8) != 0) {
                throw new SQLException("Image is a collection image, expecting ADT");
            }
            byte by2 = this.image[1];
            if ((by2 & 0xFF) > 1) {
                throw new SQLException("Image version is not recognized");
            }
            this.offset += 2;
        }

        protected final byte[] readDataValue() {
            int n = this.image[this.offset] & 0xFF;
            if (n == 255) {
                ++this.offset;
                return null;
            }
            if (n > 245) {
                n = (((this.image[this.offset + 1] & 0xFF) * 256 + (this.image[this.offset + 2] & 0xFF)) * 256 + (this.image[this.offset + 3] & 0xFF)) * 256 + (this.image[this.offset + 4] & 0xFF);
                this.offset += 5;
            } else {
                ++this.offset;
            }
            byte[] byArray = new byte[n];
            System.arraycopy(this.image, this.offset, byArray, 0, byArray.length);
            this.offset += byArray.length;
            return byArray;
        }

        protected byte[] readDataValue(int n) {
            if (n == 0) {
                return null;
            }
            byte[] byArray = new byte[n];
            System.arraycopy(this.image, this.offset, byArray, 0, n);
            this.offset += n;
            return byArray;
        }

        protected boolean isElementNull(byte by) {
            return (by & 0xFF) == 255;
        }

        protected final void skipLength() {
            int n = this.image[this.offset] & 0xFF;
            this.offset = n > 245 ? (this.offset += 5) : ++this.offset;
        }

        protected final void skipTo(int n) {
            if (n > this.offset) {
                this.offset = n;
            }
        }

        protected final int readLength() {
            int n = this.image[this.offset] & 0xFF;
            if (n > 245) {
                if (n == 255) {
                    return -1;
                }
                n = (((this.image[this.offset + 1] & 0xFF) * 256 + (this.image[this.offset + 2] & 0xFF)) * 256 + (this.image[this.offset + 3] & 0xFF)) * 256 + (this.image[this.offset + 4] & 0xFF);
                this.offset += 5;
            } else {
                ++this.offset;
            }
            return n;
        }

        protected final void skipRestOfLength(byte by) throws SQLException {
            if ((by & 0xFF) > 245) {
                if ((by & 0xFF) == 254) {
                    this.offset += 4;
                } else {
                    throw new SQLException("Invalid first length byte");
                }
            }
        }

        protected final void checkArrayHeader() throws SQLException {
            byte by = this.readByte();
            if ((by & 0xFF & 4) != 0) {
                throw new SQLException("Array image has no prefix segment");
            }
            boolean bl = true;
            if ((by & 0xFF & 8) != 0) {
                bl = true;
            } else if ((by & 0xFF & 0x10) != 0) {
                bl = false;
            } else {
                throw new SQLException("Image is not a collection image");
            }
            this.readByte();
            long l = this.readLength();
            int n = this.readLength();
            byte by2 = this.readByte();
            this.readDataValue(n - 1);
        }
    }
}

