/*
 * Decompiled with CFR 0.152.
 */
package com.pastdev.jsch.nio.file;

import com.pastdev.jsch.nio.file.UnixSshPath;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;

public class UnixSshBasicFileAttributeView
implements BasicFileAttributeView {
    private LinkOption[] options;
    private UnixSshPath path;

    UnixSshBasicFileAttributeView(UnixSshPath path, LinkOption ... options) {
        this.path = path;
    }

    LinkOption[] getOptions() {
        return this.options;
    }

    UnixSshPath getPath() {
        return this.path;
    }

    @Override
    public String name() {
        return "basic";
    }

    @Override
    public BasicFileAttributes readAttributes() throws IOException {
        return this.path.getFileSystem().provider().readAttributes((Path)this.path, BasicFileAttributes.class, this.options);
    }

    void setAttribute(String attributeName, Object value) throws IOException {
        if (attributeName.equals("lastModifiedTime")) {
            this.setTimes((FileTime)value, null, null);
        } else if (attributeName.equals("lastAccessTime")) {
            this.setTimes(null, (FileTime)value, null);
        } else if (attributeName.equals("createTime")) {
            this.setTimes(null, null, (FileTime)value);
        } else {
            throw new IllegalArgumentException("unsupported attribute name " + attributeName);
        }
    }

    @Override
    public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
        this.path.getFileSystem().provider().setTimes(this.path, lastModifiedTime, lastAccessTime);
    }
}

