/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.victims;

import com.redhat.victims.BaseArtifactCollector;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.shared.artifact.filter.ScopeArtifactFilter;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.apache.maven.shared.dependency.tree.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

class DependencyTreeCollector
extends BaseArtifactCollector {
    DependencyTreeCollector() {
    }

    protected void gatherArtifacts() {
        try {
            ArtifactRepository localRepository = (ArtifactRepository)this.helper.evaluate("${localRepository}");
            DependencyTreeBuilder treeBuilder = (DependencyTreeBuilder)this.helper.getComponent(DependencyTreeBuilder.class);
            ScopeArtifactFilter filter = new ScopeArtifactFilter();
            filter.setIncludeRuntimeScopeWithImplications(true);
            DependencyNode treeRoot = treeBuilder.buildDependencyTree(this.project, localRepository, (ArtifactFilter)filter);
            this.helper.getLog().debug((CharSequence)("[victims-enforcer] artifact id of root = " + treeRoot.getArtifact().toString()));
            CollectingDependencyNodeVisitor visitor = new CollectingDependencyNodeVisitor();
            treeRoot.accept((DependencyNodeVisitor)visitor);
            for (DependencyNode node : visitor.getNodes()) {
                Artifact artifact;
                if (node.getState() != 0 || treeRoot.equals((Object)node) || (artifact = node.getArtifact()) == null) continue;
                this.artifacts.add(artifact);
                this.helper.getLog().debug((CharSequence)("[victims-enforcer] adding dependency " + artifact.toString()));
            }
        }
        catch (NoSuchMethodError ex) {
            this.helper.getLog().error((Throwable)ex);
        }
        catch (ComponentLookupException ex) {
            this.helper.getLog().error((Throwable)ex);
        }
        catch (ExpressionEvaluationException ex) {
            this.helper.getLog().error((Throwable)ex);
        }
        catch (DependencyTreeBuilderException ex) {
            this.helper.getLog().error((Throwable)ex);
        }
    }
}

