/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.victims;

import com.redhat.victims.ArtifactCollector;
import com.redhat.victims.ArtifactStub;
import com.redhat.victims.BaseArtifactCollector;
import com.redhat.victims.DependencyTreeCollector;
import com.redhat.victims.ExecutionContext;
import com.redhat.victims.ReactorCollector;
import com.redhat.victims.Settings;
import com.redhat.victims.TextUI;
import com.redhat.victims.VictimsCommand;
import com.redhat.victims.VictimsConfig;
import com.redhat.victims.VictimsException;
import com.redhat.victims.VictimsResultCache;
import com.redhat.victims.VulnerableArtifactException;
import com.redhat.victims.database.VictimsDB;
import com.redhat.victims.database.VictimsDBInterface;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugin.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VictimsRule
implements EnforcerRule {
    private String metadata = Settings.defaults.get("metadata");
    private String fingerprint = Settings.defaults.get("fingerprint");
    private String updates = Settings.defaults.get("updates");
    private String baseUrl = null;
    private String entryPoint = null;
    private String jdbcDriver = null;
    private String jdbcUrl = null;
    private String jdbcUser = null;
    private String jdbcPass = null;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        ArtifactCollector[] collectors;
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        for (ArtifactCollector collector : collectors = new ArtifactCollector[]{new DependencyTreeCollector(), new ReactorCollector(), new BaseArtifactCollector()}) {
            try {
                artifacts.addAll(collector.with(helper).getArtifacts());
            }
            catch (Throwable e) {
                helper.getLog().debug((CharSequence)("[victims-enforcer] Artifact Collector failed: " + collector.getClass().getName()));
                helper.getLog().debug((CharSequence)e.toString());
            }
        }
        this.execute(this.setupContext(helper.getLog()), artifacts);
    }

    public ExecutionContext setupContext(Log log) throws EnforcerRuleException {
        ExecutionContext ctx = new ExecutionContext();
        ctx.setLog(log);
        ctx.setSettings(new Settings());
        ctx.getSettings().set("metadata", this.metadata);
        ctx.getSettings().set("fingerprint", this.fingerprint);
        ctx.getSettings().set("updates", this.updates);
        System.setProperty("victims.algorithms", "SHA512");
        if (this.baseUrl != null) {
            System.setProperty("victims.service.uri", this.baseUrl);
            ctx.getSettings().set("victims.service.uri", this.baseUrl);
        }
        if (this.entryPoint != null) {
            System.setProperty("victims.service.entry", this.entryPoint);
            ctx.getSettings().set("victims.service.uri", this.baseUrl);
        }
        if (this.jdbcDriver != null) {
            System.setProperty("victims.db.driver", this.jdbcDriver);
            ctx.getSettings().set("victims.db.driver", this.jdbcDriver);
        }
        if (this.jdbcUrl != null) {
            System.setProperty("victims.db.url", this.jdbcUrl);
            ctx.getSettings().set("victims.db.url", this.jdbcUrl);
        }
        if (this.jdbcUser != null) {
            System.setProperty("victims.db.user", this.jdbcUser);
            ctx.getSettings().set("victims.db.user", this.jdbcUser);
        }
        if (this.jdbcPass != null) {
            System.setProperty("victims.db.pass", this.jdbcPass);
            ctx.getSettings().set("victims.db.pass", "(not shown)");
        }
        try {
            ctx.setDatabase(VictimsDB.db());
        }
        catch (VictimsException e) {
            log.debug((Throwable)e);
            throw new EnforcerRuleException(e.getMessage());
        }
        try {
            ctx.setCache(new VictimsResultCache());
        }
        catch (VictimsException e) {
            log.debug((Throwable)e);
            throw new EnforcerRuleException(e.getMessage());
        }
        try {
            ctx.getSettings().validate();
            ctx.getSettings().show(ctx.getLog());
        }
        catch (VictimsException e) {
            log.debug((Throwable)e);
            throw new EnforcerRuleException(e.getMessage());
        }
        return ctx;
    }

    public void updateDatabase(ExecutionContext ctx) throws VictimsException {
        Log log = ctx.getLog();
        String override = System.getProperty("victims.skip.update");
        if (override != null && override.equalsIgnoreCase("true")) {
            log.warn((CharSequence)"[victims-enforcer] Updates disabled via system property.");
            return;
        }
        VictimsDBInterface db = ctx.getDatabase();
        Date updated = db.lastUpdated();
        if (ctx.updateAlways()) {
            log.info((CharSequence)TextUI.fmt("INFO_UPDATES", updated.toString(), VictimsConfig.uri()));
            db.synchronize();
        } else if (ctx.updateDaily()) {
            SimpleDateFormat cmp = new SimpleDateFormat("yyyyMMdd");
            Date today = new Date();
            boolean updatedToday = cmp.format(today).equals(cmp.format(updated));
            if (!updatedToday) {
                log.info((CharSequence)TextUI.fmt("INFO_UPDATES", updated.toString(), VictimsConfig.uri()));
                db.synchronize();
            } else {
                log.debug((CharSequence)("[victims-enforcer] database last synchronized: " + updated.toString()));
            }
        } else if (ctx.updateWeekly()) {
            SimpleDateFormat cmp = new SimpleDateFormat("yyyyw");
            Date today = new Date();
            if (!cmp.format(today).equals(cmp.format(updated))) {
                log.info((CharSequence)TextUI.fmt("INFO_UPDATES", updated.toString(), VictimsConfig.uri()));
                db.synchronize();
            } else {
                log.debug((CharSequence)("[victims-enforcer] database last synchronized: " + updated.toString()));
            }
        } else {
            log.debug((CharSequence)"[victims-enforcer] database synchronization disabled.");
        }
    }

    private void processResult(ExecutionContext ctx, Future<ArtifactStub> result) throws VictimsException, VulnerableArtifactException, EnforcerRuleException {
        VictimsResultCache cache = ctx.getCache();
        Log log = ctx.getLog();
        try {
            ArtifactStub checked = result.get();
            if (checked != null) {
                log.debug((CharSequence)("[victims-enforcer] done: " + checked.getId()));
                cache.add(checked.getId(), null);
            }
        }
        catch (InterruptedException e) {
            log.info((CharSequence)e.getMessage());
        }
        catch (ExecutionException e) {
            log.debug((Throwable)e);
            Throwable cause = e.getCause();
            if (cause instanceof VulnerableArtifactException) {
                VulnerableArtifactException ve = (VulnerableArtifactException)((Object)cause);
                cache.add(ve.getId(), ve.getVulnerabilites());
                log.warn((CharSequence)ve.getLogMessage());
                throw ve;
            }
            throw new EnforcerRuleException(e.getCause().getMessage());
        }
    }

    public void execute(ExecutionContext ctx, Set<Artifact> artifacts) throws EnforcerRuleException {
        VictimsResultCache cache = ctx.getCache();
        Log log = ctx.getLog();
        int cores = Runtime.getRuntime().availableProcessors();
        ExecutorService executor = null;
        ExecutorCompletionService<ArtifactStub> completionService = null;
        ArrayList<Future<ArtifactStub>> results = null;
        try {
            try {
                this.updateDatabase(ctx);
            }
            catch (VictimsException e) {
                log.warn((CharSequence)"Unable to update victims database! Your CVE records might be out of date.");
                log.debug((CharSequence)e.toString());
            }
            executor = Executors.newFixedThreadPool(cores);
            completionService = new ExecutorCompletionService<ArtifactStub>(executor);
            results = new ArrayList<Future<ArtifactStub>>();
            for (Artifact artifact : artifacts) {
                if (cache.exists(artifact.getId())) {
                    HashSet cves = cache.get(artifact.getId());
                    log.debug((CharSequence)("[victims-enforcer] cached: " + artifact.getId()));
                    if (cves.isEmpty()) continue;
                    VulnerableArtifactException err = new VulnerableArtifactException(artifact, "fingerprint", cves);
                    log.warn((CharSequence)err.getLogMessage());
                    if (!err.isFatal(ctx)) continue;
                    throw new EnforcerRuleException(err.getErrorMessage());
                }
                results.add(completionService.submit(new VictimsCommand(ctx, artifact)));
                Future<ArtifactStub> result = completionService.poll();
                if (result == null) continue;
                try {
                    results.remove(result);
                    this.processResult(ctx, result);
                }
                catch (VulnerableArtifactException e) {
                    if (!e.isFatal(ctx)) continue;
                    for (Future future : results) {
                        future.cancel(true);
                    }
                    throw new EnforcerRuleException(e.getErrorMessage(), (Exception)((Object)e));
                }
            }
            executor.shutdown();
            for (Future future : results) {
                this.processResult(ctx, future);
            }
        }
        catch (VulnerableArtifactException e) {
            if (e.isFatal(ctx)) {
                throw new EnforcerRuleException(e.getErrorMessage());
            }
        }
        catch (VictimsException e) {
            log.debug((Throwable)e);
            throw new EnforcerRuleException(e.getMessage());
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
            }
        }
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule er) {
        return false;
    }

    public String getCacheId() {
        return " " + new Date().getTime();
    }
}

