/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring.reporter;

import com.codahale.metrics.Clock;
import com.codahale.metrics.MetricRegistry;
import com.ryantenney.metrics.spring.reporter.AbstractScheduledReporterFactoryBean;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.coursera.metrics.datadog.DatadogReporter;
import org.coursera.metrics.datadog.DynamicTagsCallback;
import org.coursera.metrics.datadog.MetricNameFormatter;
import org.coursera.metrics.datadog.transport.HttpTransport;
import org.coursera.metrics.datadog.transport.Transport;
import org.coursera.metrics.datadog.transport.UdpTransport;
import org.springframework.util.StringUtils;

public class DatadogReporterFactoryBean
extends AbstractScheduledReporterFactoryBean<DatadogReporter> {
    public static final String TRANSPORT = "transport";
    public static final String PERIOD = "period";
    public static final String API_KEY = "api-key";
    public static final String CONNECT_TIMEOUT = "connect-timeout";
    public static final String SOCKET_TIMEOUT = "socket-timeout";
    public static final String STATSD_HOST = "statsd-host";
    public static final String STATSD_PORT = "statsd-port";
    public static final String STATSD_PREFIX = "statsd-prefix";
    public static final String HOST = "host";
    public static final String EC2_HOST = "use-ec2-host";
    public static final String EXPANSION = "expansions";
    public static final String TAGS = "tags";
    public static final String DYNAMIC_TAG_CALLBACK_REF = "dynamic-tag-callback-ref";
    public static final String METRIC_NAME_FORMATTER_REF = "metric-name-formatter-ref";
    public static final String PREFIX = "prefix";
    public static final String CLOCK_REF = "clock-ref";
    public static final String DURATION_UNIT = "duration-unit";
    public static final String RATE_UNIT = "rate-unit";

    @Override
    public Class<DatadogReporter> getObjectType() {
        return DatadogReporter.class;
    }

    @Override
    protected DatadogReporter createInstance() {
        HttpTransport transport;
        HttpTransport.Builder builder;
        DatadogReporter.Builder reporter = DatadogReporter.forRegistry((MetricRegistry)this.getMetricRegistry());
        String transportName = this.getProperty(TRANSPORT);
        if ("http".equalsIgnoreCase(transportName)) {
            builder = new HttpTransport.Builder();
            builder.withApiKey(this.getProperty(API_KEY));
            if (this.hasProperty(CONNECT_TIMEOUT)) {
                builder.withConnectTimeout(this.getProperty(CONNECT_TIMEOUT, Integer.class).intValue());
            }
            if (this.hasProperty(SOCKET_TIMEOUT)) {
                builder.withSocketTimeout(this.getProperty(SOCKET_TIMEOUT, Integer.class).intValue());
            }
            transport = builder.build();
        } else if ("udp".equalsIgnoreCase(transportName) || "statsd".equalsIgnoreCase(transportName)) {
            builder = new UdpTransport.Builder();
            if (this.hasProperty(STATSD_HOST)) {
                builder.withStatsdHost(this.getProperty(STATSD_HOST));
            }
            if (this.hasProperty(STATSD_PORT)) {
                builder.withPort(this.getProperty(STATSD_PORT, Integer.class).intValue());
            }
            if (this.hasProperty(STATSD_PREFIX)) {
                builder.withPrefix(this.getProperty(STATSD_PREFIX));
            }
            transport = builder.build();
        } else {
            throw new IllegalArgumentException("Invalid Datadog Transport: " + transportName);
        }
        reporter.withTransport((Transport)transport);
        if (this.hasProperty(TAGS)) {
            reporter.withTags(Arrays.asList(StringUtils.tokenizeToStringArray((String)this.getProperty(TAGS), (String)",", (boolean)true, (boolean)true)));
        }
        if (StringUtils.hasText((String)this.getProperty(HOST))) {
            reporter.withHost(this.getProperty(HOST));
        } else if ("true".equalsIgnoreCase(this.getProperty(EC2_HOST))) {
            try {
                reporter.withEC2Host();
            }
            catch (IOException e) {
                throw new IllegalStateException("DatadogReporter.Builder.withEC2Host threw an exception", e);
            }
        }
        if (this.hasProperty(EXPANSION)) {
            EnumSet<DatadogReporter.Expansion> expansions;
            String configString = this.getProperty(EXPANSION).trim().toUpperCase(Locale.ENGLISH);
            if ("ALL".equals(configString)) {
                expansions = DatadogReporter.Expansion.ALL;
            } else {
                expansions = EnumSet.noneOf(DatadogReporter.Expansion.class);
                for (String expandedMetricStr : StringUtils.tokenizeToStringArray((String)configString, (String)",", (boolean)true, (boolean)true)) {
                    expansions.add(DatadogReporter.Expansion.valueOf((String)expandedMetricStr.replace(' ', '_')));
                }
            }
            reporter.withExpansions(expansions);
        }
        if (this.hasProperty(DYNAMIC_TAG_CALLBACK_REF)) {
            reporter.withDynamicTagCallback(this.getPropertyRef(DYNAMIC_TAG_CALLBACK_REF, DynamicTagsCallback.class));
        }
        if (this.hasProperty(METRIC_NAME_FORMATTER_REF)) {
            reporter.withMetricNameFormatter(this.getPropertyRef(METRIC_NAME_FORMATTER_REF, MetricNameFormatter.class));
        }
        if (this.hasProperty(PREFIX)) {
            reporter.withPrefix(this.getProperty(PREFIX));
        }
        if (this.hasProperty(DURATION_UNIT)) {
            reporter.convertDurationsTo(this.getProperty(DURATION_UNIT, TimeUnit.class));
        }
        if (this.hasProperty(RATE_UNIT)) {
            reporter.convertRatesTo(this.getProperty(RATE_UNIT, TimeUnit.class));
        }
        if (this.hasProperty(CLOCK_REF)) {
            reporter.withClock(this.getPropertyRef(CLOCK_REF, Clock.class));
        }
        reporter.filter(this.getMetricFilter());
        return reporter.build();
    }

    @Override
    protected long getPeriod() {
        return this.convertDurationString(this.getProperty(PERIOD));
    }
}

