/*
 * Decompiled with CFR 0.152.
 */
package javax.faces;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.FactoryFinderInstance;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

final class CurrentThreadToServletContext {
    ConcurrentMap<FactoryManagerCacheKey, FactoryFinderInstance> applicationMap = new ConcurrentHashMap<FactoryManagerCacheKey, FactoryFinderInstance>();
    private AtomicBoolean logNullFacesContext = new AtomicBoolean(false);
    private AtomicBoolean logNonNullFacesContext = new AtomicBoolean(false);
    private static final Logger LOGGER = Logger.getLogger("javax.faces", "javax.faces.LogStrings");

    CurrentThreadToServletContext() {
    }

    Object getFallbackFactory(FactoryFinderInstance factoryFinderInstance, String string) {
        Object object = null;
        ClassLoader classLoader = this.getClassLoader();
        for (Map.Entry entry : this.applicationMap.entrySet()) {
            if (((FactoryManagerCacheKey)entry.getKey()).getClassLoader().equals(classLoader) && !((FactoryFinderInstance)entry.getValue()).equals(factoryFinderInstance) && null != (object = ((FactoryFinderInstance)entry.getValue()).getFactory(string))) break;
        }
        return object;
    }

    FactoryFinderInstance getApplicationFactoryManager() {
        ClassLoader classLoader = this.getClassLoader();
        FactoryFinderInstance factoryFinderInstance = this.getApplicationFactoryManager(classLoader, true);
        return factoryFinderInstance;
    }

    private FactoryFinderInstance getApplicationFactoryManager(ClassLoader classLoader, boolean bl) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        boolean bl2 = this.detectSpecialInitializationCase(facesContext);
        FactoryManagerCacheKey factoryManagerCacheKey = new FactoryManagerCacheKey(facesContext, classLoader, this.applicationMap);
        Object object = (FactoryFinderInstance)this.applicationMap.get(factoryManagerCacheKey);
        FactoryFinderInstance factoryFinderInstance = null;
        if (object == null && bl) {
            Object object2;
            boolean bl3 = false;
            if (bl2) {
                boolean bl4 = false;
                boolean bl5 = true;
                for (Map.Entry entry : this.applicationMap.entrySet()) {
                    object2 = (FactoryManagerCacheKey)entry.getKey();
                    if (!((FactoryManagerCacheKey)object2).getClassLoader().equals(classLoader)) continue;
                    bl5 = false;
                    if (null != factoryManagerCacheKey.getContext() && null != ((FactoryManagerCacheKey)object2).getContext() && !factoryManagerCacheKey.getContext().equals(((FactoryManagerCacheKey)object2).getContext())) {
                        bl4 = true;
                        factoryFinderInstance = (FactoryFinderInstance)entry.getValue();
                        break;
                    }
                    object = (FactoryFinderInstance)entry.getValue();
                    break;
                }
                bl3 = bl5 || null == object && bl4;
            } else {
                bl3 = true;
            }
            if (bl3) {
                object2 = null != factoryFinderInstance ? new FactoryFinderInstance(factoryFinderInstance) : new FactoryFinderInstance();
                object = this.applicationMap.putIfAbsent(factoryManagerCacheKey, (FactoryFinderInstance)object2);
                object = null != object ? object : object2;
            }
        }
        return object;
    }

    private boolean detectSpecialInitializationCase(FacesContext facesContext) {
        boolean bl = false;
        if (null == facesContext) {
            this.logNullFacesContext.compareAndSet(false, true);
        } else {
            this.logNonNullFacesContext.compareAndSet(false, true);
        }
        bl = this.logNullFacesContext.get() && this.logNonNullFacesContext.get();
        return bl;
    }

    void removeApplicationFactoryManager() {
        ClassLoader classLoader = this.getClassLoader();
        FactoryFinderInstance factoryFinderInstance = this.getApplicationFactoryManager(classLoader, false);
        if (null != factoryFinderInstance) {
            factoryFinderInstance.clearInjectionProvider();
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        boolean bl = this.detectSpecialInitializationCase(facesContext);
        FactoryManagerCacheKey factoryManagerCacheKey = new FactoryManagerCacheKey(facesContext, classLoader, this.applicationMap);
        this.applicationMap.remove(factoryManagerCacheKey);
        if (bl) {
            this.logNullFacesContext.set(false);
            this.logNonNullFacesContext.set(false);
        }
    }

    void resetSpecialInitializationCaseFlags() {
        this.logNullFacesContext.set(false);
        this.logNonNullFacesContext.set(false);
    }

    private ClassLoader getClassLoader() throws FacesException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            throw new FacesException("getContextClassLoader");
        }
        return classLoader;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FactoryManagerCacheKey {
        private ClassLoader cl;
        private Long marker;
        private Object context;
        private static final String MARKER_KEY = FactoryFinder.class.getName() + "." + FactoryManagerCacheKey.class.getSimpleName();
        private static final String INIT_TIME_CL_KEY = MARKER_KEY + ".InitTimeCLKey";

        FactoryManagerCacheKey(FacesContext facesContext, ClassLoader classLoader, Map<FactoryManagerCacheKey, FactoryFinderInstance> map) {
            Object object;
            ExternalContext externalContext = null != facesContext ? facesContext.getExternalContext() : null;
            Object object2 = object = null != externalContext ? externalContext.getContext() : null;
            if (null == facesContext || null == externalContext || null == object) {
                this.initFromFactoryMap(classLoader, map);
            } else {
                this.initFromAppMap(externalContext, classLoader);
            }
        }

        private void initFromFactoryMap(ClassLoader classLoader, Map<FactoryManagerCacheKey, FactoryFinderInstance> map) {
            Set<FactoryManagerCacheKey> set = map.keySet();
            FactoryManagerCacheKey factoryManagerCacheKey = null;
            if (set.isEmpty()) {
                this.cl = classLoader;
                this.marker = new Long(System.currentTimeMillis());
            } else {
                for (FactoryManagerCacheKey factoryManagerCacheKey2 : set) {
                    assert (null != factoryManagerCacheKey2.cl);
                    ClassLoader classLoader2 = this.findMatchConsideringParentClassLoader(classLoader, factoryManagerCacheKey2.cl);
                    if (null == classLoader2) continue;
                    if (null != factoryManagerCacheKey) {
                        LOGGER.log(Level.WARNING, "Multiple JSF Applications found on same ClassLoader.  Unable to safely determine which FactoryManager instance to use. Defaulting to first match.");
                        break;
                    }
                    factoryManagerCacheKey = factoryManagerCacheKey2;
                    this.cl = classLoader2;
                }
                if (null != factoryManagerCacheKey) {
                    this.marker = factoryManagerCacheKey.marker;
                    this.context = factoryManagerCacheKey.context;
                }
            }
        }

        private ClassLoader findMatchConsideringParentClassLoader(ClassLoader classLoader, ClassLoader classLoader2) {
            for (ClassLoader classLoader3 = classLoader; null != classLoader3; classLoader3 = classLoader3.getParent()) {
                if (!classLoader3.equals(classLoader2)) continue;
                return classLoader3;
            }
            return null;
        }

        private void initFromAppMap(ExternalContext externalContext, ClassLoader classLoader) {
            Map<String, Object> map = externalContext.getApplicationMap();
            Long l = (Long)map.get(MARKER_KEY);
            if (null == l) {
                this.marker = new Long(System.currentTimeMillis());
                map.put(MARKER_KEY, this.marker);
                map.put(INIT_TIME_CL_KEY, new Integer(System.identityHashCode(classLoader)));
            } else {
                this.marker = l;
            }
            this.cl = this.resolveToFirstTimeUsedClassLoader(classLoader, externalContext);
            this.context = externalContext.getContext();
        }

        private ClassLoader resolveToFirstTimeUsedClassLoader(ClassLoader classLoader, ExternalContext externalContext) {
            ClassLoader classLoader2 = classLoader;
            ClassLoader classLoader3 = null;
            Map<String, Object> map = externalContext.getApplicationMap();
            Integer n = (Integer)map.get(INIT_TIME_CL_KEY);
            boolean bl = false;
            if (null != n) {
                int n2 = System.identityHashCode(classLoader2);
                while (!bl && null != classLoader2) {
                    bl = n2 == n;
                    if (bl) continue;
                    classLoader2 = classLoader2.getParent();
                    n2 = System.identityHashCode(classLoader2);
                }
            }
            classLoader3 = bl ? classLoader2 : classLoader;
            return classLoader3;
        }

        ClassLoader getClassLoader() {
            return this.cl;
        }

        Object getContext() {
            return this.context;
        }

        private FactoryManagerCacheKey() {
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            FactoryManagerCacheKey factoryManagerCacheKey = (FactoryManagerCacheKey)object;
            if (!(this.cl == factoryManagerCacheKey.cl || this.cl != null && this.cl.equals(factoryManagerCacheKey.cl))) {
                return false;
            }
            return this.marker == factoryManagerCacheKey.marker || this.marker != null && this.marker.equals(factoryManagerCacheKey.marker);
        }

        public int hashCode() {
            int n = 7;
            n = 97 * n + (this.cl != null ? this.cl.hashCode() : 0);
            n = 97 * n + (this.marker != null ? this.marker.hashCode() : 0);
            return n;
        }
    }
}

