/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.faces.FacesException;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;
import javax.faces.model.NoRowAvailableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetDataModel
extends DataModel<Map<String, Object>> {
    private int index = -1;
    private ResultSetMetaData metadata = null;
    private ResultSet resultSet = null;
    private boolean updated = false;

    public ResultSetDataModel() {
        this(null);
    }

    public ResultSetDataModel(ResultSet resultSet) {
        this.setWrappedData(resultSet);
    }

    @Override
    public boolean isRowAvailable() {
        if (this.resultSet == null) {
            return false;
        }
        if (this.index < 0) {
            return false;
        }
        try {
            return this.resultSet.absolute(this.index + 1);
        }
        catch (SQLException sQLException) {
            throw new FacesException(sQLException);
        }
    }

    @Override
    public int getRowCount() {
        return -1;
    }

    @Override
    public Map<String, Object> getRowData() {
        if (this.resultSet == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new NoRowAvailableException();
        }
        try {
            this.getMetaData();
            return new ResultSetMap(this, String.CASE_INSENSITIVE_ORDER);
        }
        catch (SQLException sQLException) {
            throw new FacesException(sQLException);
        }
    }

    @Override
    public int getRowIndex() {
        return this.index;
    }

    @Override
    public void setRowIndex(int n) {
        if (n < -1) {
            throw new IllegalArgumentException();
        }
        if (this.updated && this.resultSet != null) {
            try {
                if (!this.resultSet.rowDeleted()) {
                    this.resultSet.updateRow();
                }
                this.updated = false;
            }
            catch (SQLException sQLException) {
                throw new FacesException(sQLException);
            }
        }
        int n2 = this.index;
        this.index = n;
        if (this.resultSet == null) {
            return;
        }
        DataModelListener[] dataModelListenerArray = this.getDataModelListeners();
        if (n2 != this.index && dataModelListenerArray != null) {
            Object object = null;
            if (this.isRowAvailable()) {
                object = this.getRowData();
            }
            DataModelEvent dataModelEvent = new DataModelEvent(this, this.index, object);
            int n3 = dataModelListenerArray.length;
            for (int i = 0; i < n3; ++i) {
                if (null == dataModelListenerArray[i]) continue;
                dataModelListenerArray[i].rowSelected(dataModelEvent);
            }
        }
    }

    @Override
    public Object getWrappedData() {
        return this.resultSet;
    }

    @Override
    public void setWrappedData(Object object) {
        if (object == null) {
            this.metadata = null;
            this.resultSet = null;
            this.setRowIndex(-1);
        } else {
            this.metadata = null;
            this.resultSet = (ResultSet)object;
            this.index = -1;
            this.setRowIndex(0);
        }
    }

    private ResultSetMetaData getMetaData() {
        if (this.metadata == null) {
            try {
                this.metadata = this.resultSet.getMetaData();
            }
            catch (SQLException sQLException) {
                throw new FacesException(sQLException);
            }
        }
        return this.metadata;
    }

    private void updated() {
        this.updated = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResultSetValuesIterator
    implements Iterator<Object> {
        private ResultSetMap map;
        private Iterator<String> keys;

        public ResultSetValuesIterator(ResultSetMap resultSetMap) {
            this.map = resultSetMap;
            this.keys = resultSetMap.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.keys.hasNext();
        }

        @Override
        public Object next() {
            return this.map.get(this.keys.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResultSetValues
    extends AbstractCollection<Object> {
        private ResultSetMap map;

        public ResultSetValues(ResultSetMap resultSetMap) {
            this.map = resultSetMap;
        }

        @Override
        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object object) {
            return this.map.containsValue(object);
        }

        @Override
        public Iterator<Object> iterator() {
            return new ResultSetValuesIterator(this.map);
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResultSetKeysIterator
    implements Iterator<String> {
        private Iterator<String> keys = null;

        public ResultSetKeysIterator(ResultSetMap resultSetMap) {
            this.keys = resultSetMap.realKeys();
        }

        @Override
        public boolean hasNext() {
            return this.keys.hasNext();
        }

        @Override
        public String next() {
            return this.keys.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResultSetKeys
    extends AbstractSet<String> {
        private ResultSetMap map;

        public ResultSetKeys(ResultSetMap resultSetMap) {
            this.map = resultSetMap;
        }

        @Override
        public boolean add(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object object) {
            return this.map.containsKey(object);
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Iterator<String> iterator() {
            return new ResultSetKeysIterator(this.map);
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResultSetEntry
    implements Map.Entry<String, Object> {
        private ResultSetMap map;
        private String key;

        public ResultSetEntry(ResultSetMap resultSetMap, String string) {
            this.map = resultSetMap;
            this.key = string;
        }

        @Override
        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            if (this.key == null ? entry.getKey() != null : !this.key.equals(entry.getKey())) {
                return false;
            }
            Object object2 = this.map.get(this.key);
            return !(object2 == null ? entry.getValue() != null : !object2.equals(entry.getValue()));
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.map.get(this.key);
        }

        @Override
        public int hashCode() {
            Object object = this.map.get(this.key);
            return (this.key == null ? 0 : this.key.hashCode()) ^ (object == null ? 0 : object.hashCode());
        }

        @Override
        public Object setValue(Object object) {
            Object object2 = this.map.get(this.key);
            this.map.put(this.key, object);
            return object2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResultSetEntriesIterator
    implements Iterator<Map.Entry<String, Object>> {
        private ResultSetMap map = null;
        private Iterator<String> keys = null;

        public ResultSetEntriesIterator(ResultSetMap resultSetMap) {
            this.map = resultSetMap;
            this.keys = resultSetMap.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.keys.hasNext();
        }

        @Override
        public Map.Entry<String, Object> next() {
            String string = this.keys.next();
            return new ResultSetEntry(this.map, string);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResultSetEntries
    extends AbstractSet<Map.Entry<String, Object>> {
        private ResultSetMap map;

        public ResultSetEntries(ResultSetMap resultSetMap) {
            this.map = resultSetMap;
        }

        @Override
        public boolean add(Map.Entry<String, Object> entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (!this.map.containsKey(k)) {
                return false;
            }
            if (v == null) {
                return this.map.get(k) == null;
            }
            return v.equals(this.map.get(k));
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return new ResultSetEntriesIterator(this.map);
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResultSetMap
    extends TreeMap<String, Object> {
        private ResultSetDataModel model;
        private int index;

        public ResultSetMap(ResultSetDataModel resultSetDataModel, Comparator<String> comparator) throws SQLException {
            super(comparator);
            this.model = resultSetDataModel;
            this.index = resultSetDataModel.index;
            resultSetDataModel.resultSet.absolute(this.index + 1);
            int n = resultSetDataModel.metadata.getColumnCount();
            for (int i = 1; i <= n; ++i) {
                super.put(resultSetDataModel.metadata.getColumnName(i), resultSetDataModel.metadata.getColumnName(i));
            }
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsValue(Object object) {
            for (Map.Entry<String, Object> entry : this.entrySet()) {
                Object object2 = entry.getValue();
                if (!(object == null ? object2 == null : object.equals(object2))) continue;
                return true;
            }
            return false;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return new ResultSetEntries(this);
        }

        @Override
        public Object get(Object object) {
            if (!this.containsKey(object)) {
                return null;
            }
            try {
                this.model.resultSet.absolute(this.index + 1);
                return this.model.resultSet.getObject((String)this.realKey(object));
            }
            catch (SQLException sQLException) {
                throw new FacesException(sQLException);
            }
        }

        @Override
        public Set<String> keySet() {
            return new ResultSetKeys(this);
        }

        @Override
        public Object put(String string, Object object) {
            if (!this.containsKey(string)) {
                throw new IllegalArgumentException();
            }
            try {
                this.model.resultSet.absolute(this.index + 1);
                Object object2 = this.model.resultSet.getObject((String)this.realKey(string));
                if (object2 == null && object == null) {
                    return object2;
                }
                if (object2 != null && object != null && object2.equals(object)) {
                    return object2;
                }
                this.model.resultSet.updateObject((String)this.realKey(string), object);
                this.model.updated();
                return object2;
            }
            catch (SQLException sQLException) {
                throw new FacesException(sQLException);
            }
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> map) {
            for (Map.Entry<? extends String, ? extends Object> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Object remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<Object> values() {
            return new ResultSetValues(this);
        }

        Object realKey(Object object) {
            return super.get(object);
        }

        Iterator<String> realKeys() {
            return super.keySet().iterator();
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            throw new NotSerializableException();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException {
            throw new NotSerializableException();
        }
    }
}

