/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.flow.FlowDiscoveryCDIExtension;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Producer;
import javax.faces.context.FacesContext;
import javax.faces.flow.Flow;
import javax.faces.flow.FlowHandler;
import javax.faces.flow.builder.FlowDefinition;

class JavaFlowLoaderHelper {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();

    JavaFlowLoaderHelper() {
    }

    synchronized void loadFlows(FacesContext facesContext, FlowHandler flowHandler) throws IOException {
        BeanManager beanManager = (BeanManager)Util.getCDIBeanManager(facesContext.getExternalContext().getApplicationMap());
        Bean bean = beanManager.resolve(beanManager.getBeans(FlowDiscoveryCDIExtension.class, new Annotation[0]));
        if (null == bean) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Unable to obtain {0} from CDI implementation.  Flows described with {1} are unavailable.", new String[]{FlowDiscoveryCDIExtension.class.getName(), FlowDefinition.class.getName()});
            }
            return;
        }
        CreationalContext creationalContext = beanManager.createCreationalContext((Contextual)bean);
        FlowDiscoveryCDIExtension flowDiscoveryCDIExtension = (FlowDiscoveryCDIExtension)beanManager.getReference(bean, FlowDiscoveryCDIExtension.class, creationalContext);
        List<Producer<Flow>> list = flowDiscoveryCDIExtension.getFlowProducers();
        WebConfiguration webConfiguration = WebConfiguration.getInstance();
        if (!list.isEmpty()) {
            this.enableClientWindowModeIfNecessary(facesContext);
        }
        for (Producer<Flow> producer : list) {
            Flow flow = (Flow)producer.produce(beanManager.createCreationalContext(null));
            if (null == flow) {
                LOGGER.log(Level.SEVERE, "Flow producer method {0}() returned null.  Ignoring.", producer.toString());
                continue;
            }
            flowHandler.addFlow(facesContext, flow);
            webConfiguration.setHasFlows(true);
        }
    }

    private void enableClientWindowModeIfNecessary(FacesContext facesContext) {
        WebConfiguration webConfiguration = WebConfiguration.getInstance(facesContext.getExternalContext());
        String string = webConfiguration.getOptionValue(WebConfiguration.WebContextInitParameter.ClientWindowMode);
        boolean bl = false;
        if ("none".equals(string)) {
            bl = true;
            String string2 = WebConfiguration.WebContextInitParameter.ClientWindowMode.getQualifiedName();
            LOGGER.log(Level.WARNING, "{0} was set to none, but Faces Flows requires {0} is enabled.  Setting to ''url''.", new Object[]{string2});
        } else if (null == string) {
            bl = true;
        }
        if (bl) {
            webConfiguration.setOptionValue(WebConfiguration.WebContextInitParameter.ClientWindowMode, "url");
        }
    }
}

