/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.component.visit;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartialVisitContext
extends VisitContext {
    private Collection<String> clientIds;
    private Collection<String> ids;
    private Collection<String> unvisitedClientIds;
    private Map<String, Collection<String>> subtreeClientIds;
    private FacesContext facesContext;
    private Set<VisitHint> hints;

    public PartialVisitContext(FacesContext facesContext, Collection<String> collection) {
        this(facesContext, collection, null);
    }

    public PartialVisitContext(FacesContext facesContext, Collection<String> collection, Set<VisitHint> set) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        this.facesContext = facesContext;
        this.initializeCollections(collection);
        EnumSet<VisitHint> enumSet = set == null || set.isEmpty() ? EnumSet.noneOf(VisitHint.class) : EnumSet.copyOf(set);
        this.hints = Collections.unmodifiableSet(enumSet);
    }

    public FacesContext getFacesContext() {
        return this.facesContext;
    }

    public Set<VisitHint> getHints() {
        return this.hints;
    }

    public Collection<String> getIdsToVisit() {
        return this.clientIds;
    }

    public Collection<String> getUnvisitedClientIds() {
        return this.unvisitedClientIds;
    }

    public Collection<String> getSubtreeIdsToVisit(UIComponent uIComponent) {
        if (!(uIComponent instanceof NamingContainer)) {
            throw new IllegalArgumentException("Component is not a NamingContainer: " + uIComponent);
        }
        String string = uIComponent.getClientId();
        Collection<String> collection = this.subtreeClientIds.get(string);
        if (collection == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(collection);
    }

    public VisitResult invokeVisitCallback(UIComponent uIComponent, VisitCallback visitCallback) {
        String string = this.getVisitId(uIComponent);
        if (string == null) {
            return VisitResult.ACCEPT;
        }
        VisitResult visitResult = visitCallback.visit((VisitContext)this, uIComponent);
        this.unvisitedClientIds.remove(string);
        if (this.unvisitedClientIds.isEmpty()) {
            return VisitResult.COMPLETE;
        }
        return visitResult;
    }

    private void idAdded(String string) {
        this.ids.add(this.getIdFromClientId(string));
        this.unvisitedClientIds.add(string);
        this.addSubtreeClientId(string);
    }

    private void idRemoved(String string) {
        this.unvisitedClientIds.remove(string);
        this.removeSubtreeClientId(string);
    }

    private void initializeCollections(Collection<String> collection) {
        this.unvisitedClientIds = new HashSet<String>();
        this.ids = new HashSet<String>();
        this.subtreeClientIds = new HashMap<String, Collection<String>>();
        this.clientIds = new CollectionProxy<String>(new HashSet());
        this.clientIds.addAll(collection);
    }

    private String getVisitId(UIComponent uIComponent) {
        String string = uIComponent.getId();
        if (string != null && !this.ids.contains(string)) {
            return null;
        }
        String string2 = uIComponent.getClientId();
        assert (string2 != null);
        return this.clientIds.contains(string2) ? string2 : null;
    }

    private String getIdFromClientId(String string) {
        FacesContext facesContext = this.getFacesContext();
        char c = UINamingContainer.getSeparatorChar((FacesContext)facesContext);
        int n = string.lastIndexOf(c);
        String string2 = null;
        if (n < 0) {
            string2 = string;
        } else if (n < string.length() - 1) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    private void addSubtreeClientId(String string) {
        FacesContext facesContext = this.getFacesContext();
        char c = UINamingContainer.getSeparatorChar((FacesContext)facesContext);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) != c) continue;
            String string2 = string.substring(0, i);
            Collection<String> collection = this.subtreeClientIds.get(string2);
            if (collection == null) {
                collection = new ArrayList<String>();
                this.subtreeClientIds.put(string2, collection);
            }
            collection.add(string);
        }
    }

    private void removeSubtreeClientId(String string) {
        for (String string2 : this.subtreeClientIds.keySet()) {
            if (!string.startsWith(string2)) continue;
            Collection<String> collection = this.subtreeClientIds.get(string2);
            collection.remove(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IteratorProxy<E extends String>
    implements Iterator<E> {
        private Iterator<E> wrapped;
        private E current = null;

        private IteratorProxy(Iterator<E> iterator) {
            this.wrapped = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.wrapped.hasNext();
        }

        @Override
        public E next() {
            this.current = (String)this.wrapped.next();
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current != null) {
                PartialVisitContext.this.idRemoved(this.current);
            }
            this.wrapped.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CollectionProxy<E extends String>
    extends AbstractCollection<E> {
        private Collection<E> wrapped;

        private CollectionProxy(Collection<E> collection) {
            this.wrapped = collection;
        }

        @Override
        public int size() {
            return this.wrapped.size();
        }

        @Override
        public Iterator<E> iterator() {
            return new IteratorProxy(this.wrapped.iterator());
        }

        @Override
        public boolean add(E e) {
            boolean bl = this.wrapped.add(e);
            if (bl) {
                PartialVisitContext.this.idAdded(e);
            }
            return bl;
        }
    }
}

