/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.WebappLifecycleListener;
import com.sun.faces.config.ConfigManager;
import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.InitFacesContext;
import com.sun.faces.config.Verifier;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.el.ChainTypeCompositeELResolver;
import com.sun.faces.el.ELContextImpl;
import com.sun.faces.el.ELContextListenerImpl;
import com.sun.faces.el.ELUtils;
import com.sun.faces.el.FacesCompositeELResolver;
import com.sun.faces.mgbean.BeanBuilder;
import com.sun.faces.mgbean.BeanManager;
import com.sun.faces.scripting.groovy.GroovyHelper;
import com.sun.faces.scripting.groovy.GroovyHelperFactory;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.MojarraThreadFactory;
import com.sun.faces.util.ReflectionUtils;
import com.sun.faces.util.Timer;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContextListener;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.ProjectStage;
import javax.faces.context.FacesContext;
import javax.faces.event.PreDestroyApplicationEvent;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigureListener
implements ServletRequestListener,
HttpSessionListener,
ServletRequestAttributeListener,
HttpSessionAttributeListener,
ServletContextAttributeListener,
ServletContextListener {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private ScheduledThreadPoolExecutor webResourcePool;
    protected WebappLifecycleListener webAppListener;
    protected WebConfiguration webConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ConfigManager configManager;
        ServletContext servletContext = servletContextEvent.getServletContext();
        Timer timer = Timer.getInstance();
        if (timer != null) {
            timer.startTiming();
        }
        if (null == (configManager = ConfigManager.getInstance(servletContext))) {
            configManager = ConfigManager.createInstance(servletContext);
        }
        if (configManager.hasBeenInitialized(servletContext)) {
            return;
        }
        InitFacesContext initFacesContext = new InitFacesContext(servletContext);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, MessageFormat.format("ConfigureListener.contextInitialized({0})", ConfigureListener.getServletContextIdentifier(servletContext)));
        }
        this.webConfig = WebConfiguration.getInstance(servletContext);
        Object object = servletContext.getAttribute("com.sun.faces.facesInitializerMappingsAdded");
        if (object != null) {
            servletContext.removeAttribute("com.sun.faces.facesInitializerMappingsAdded");
        }
        WebXmlProcessor webXmlProcessor = new WebXmlProcessor(servletContext);
        if (object == null) {
            if (!webXmlProcessor.isFacesServletPresent()) {
                if (!this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.ForceLoadFacesConfigFiles)) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "No FacesServlet found in deployment descriptor - bypassing configuration");
                    }
                    WebConfiguration.clear(servletContext);
                    InitFacesContext.cleanupInitMaps(servletContext);
                    return;
                }
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "FacesServlet found in deployment descriptor - processing configuration.");
            }
        }
        if (webXmlProcessor.isDistributablePresent()) {
            this.webConfig.setOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableDistributable, true);
            servletContext.setAttribute(WebConfiguration.BooleanWebContextInitParameter.EnableDistributable.getQualifiedName(), (Object)Boolean.TRUE);
        }
        this.webAppListener = new WebappLifecycleListener(servletContext);
        this.webAppListener.contextInitialized(servletContextEvent);
        ReflectionUtils.initCache(Thread.currentThread().getContextClassLoader());
        Throwable throwable = null;
        try {
            Object object3;
            Verifier verifier;
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "jsf.config.listener.version", ConfigureListener.getServletContextIdentifier(servletContext));
            }
            if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.VerifyFacesConfigObjects)) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("jsf.config.verifyobjects.development_only");
                }
                this.webConfig.overrideContextInitParameter(WebConfiguration.BooleanWebContextInitParameter.EnableLazyBeanValidation, false);
                Verifier.setCurrentInstance(new Verifier());
            }
            this.initScripting();
            configManager.initialize(servletContext);
            if (this.shouldInitConfigMonitoring()) {
                this.initConfigMonitoring(servletContext);
            }
            if ((verifier = Verifier.getCurrentInstance()) != null && !verifier.isApplicationValid() && LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.severe("jsf.config.verifyobjects.failures_detected");
                object3 = new StringBuilder(128);
                for (String object22 : verifier.getMessages()) {
                    ((StringBuilder)object3).append(object22).append('\n');
                }
                LOGGER.severe(((StringBuilder)object3).toString());
            }
            this.registerELResolverAndListenerWithJsp(servletContext, false);
            object3 = ApplicationAssociate.getInstance(servletContext);
            ELContextImpl eLContextImpl = new ELContextImpl(initFacesContext.getApplication().getELResolver());
            eLContextImpl.putContext(FacesContext.class, (Object)initFacesContext);
            ExpressionFactory expressionFactory = ELUtils.getDefaultExpressionFactory((ApplicationAssociate)object3, initFacesContext);
            if (null != expressionFactory) {
                eLContextImpl.putContext(ExpressionFactory.class, expressionFactory);
            }
            initFacesContext.setELContext(eLContextImpl);
            if (object3 != null) {
                ((ApplicationAssociate)object3).setContextName(ConfigureListener.getServletContextIdentifier(servletContext));
                BeanManager beanManager = ((ApplicationAssociate)object3).getBeanManager();
                List<String> list = beanManager.getEagerBeanNames();
                if (!list.isEmpty()) {
                    for (String string : list) {
                        beanManager.create(string, initFacesContext);
                    }
                }
                boolean bl = webXmlProcessor.isErrorPagePresent();
                ((ApplicationAssociate)object3).setErrorPagePresent(bl);
                servletContext.setAttribute("com.sun.faces.errorPagePresent", (Object)bl);
            }
            this.webConfig.doPostBringupActions();
            configManager.publishPostConfigEvent();
        }
        catch (Throwable throwable2) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Critical error during deployment: ", throwable2);
            }
            throwable = throwable2;
        }
        finally {
            Verifier.setCurrentInstance(null);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "jsf.config.listener.version.complete");
            }
            if (timer != null) {
                timer.stopTiming();
                timer.logResult("Initialization of context " + ConfigureListener.getServletContextIdentifier(servletContext));
            }
            if (null != throwable) {
                throw new RuntimeException(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        if (!ConfigManager.getInstance(servletContext).hasBeenInitialized(servletContext)) {
            return;
        }
        InitFacesContext initFacesContext = null;
        try {
            GroovyHelper groovyHelper;
            initFacesContext = this.getInitFacesContext(servletContext);
            if (null == initFacesContext) {
                initFacesContext = new InitFacesContext(servletContext);
            } else {
                InitFacesContext.getThreadInitContextMap().put(Thread.currentThread(), initFacesContext);
            }
            if (this.webAppListener != null) {
                this.webAppListener.contextDestroyed(servletContextEvent);
                this.webAppListener = null;
            }
            if (this.webResourcePool != null) {
                this.webResourcePool.shutdownNow();
            }
            if ((groovyHelper = GroovyHelper.getCurrentInstance(servletContext)) != null) {
                groovyHelper.setClassLoader();
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "ConfigureListener.contextDestroyed({0})", servletContext.getServletContextName());
            }
            ELContextImpl eLContextImpl = new ELContextImpl(initFacesContext.getApplication().getELResolver());
            eLContextImpl.putContext(FacesContext.class, (Object)initFacesContext);
            ExpressionFactory expressionFactory = ELUtils.getDefaultExpressionFactory(initFacesContext);
            if (null != expressionFactory) {
                eLContextImpl.putContext(ExpressionFactory.class, expressionFactory);
            }
            initFacesContext.setELContext(eLContextImpl);
            Application application = initFacesContext.getApplication();
            application.publishEvent((FacesContext)initFacesContext, PreDestroyApplicationEvent.class, Application.class, (Object)application);
        }
        catch (Exception exception) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Unexpected exception when attempting to tear down the Mojarra runtime", exception);
            }
        }
        finally {
            ApplicationAssociate.clearInstance(servletContext);
            ApplicationAssociate.setCurrentInstance(null);
            ConfigManager.getInstance(servletContext).destroy(servletContext);
            FactoryFinder.releaseFactories();
            ReflectionUtils.clearCache(Thread.currentThread().getContextClassLoader());
            WebConfiguration.clear(servletContext);
            InitFacesContext.cleanupInitMaps(servletContext);
        }
    }

    public void requestDestroyed(ServletRequestEvent servletRequestEvent) {
        if (this.webAppListener != null) {
            this.webAppListener.requestDestroyed(servletRequestEvent);
        }
    }

    public void requestInitialized(ServletRequestEvent servletRequestEvent) {
        if (this.webAppListener != null) {
            this.webAppListener.requestInitialized(servletRequestEvent);
        }
    }

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        if (this.webAppListener != null) {
            this.webAppListener.sessionCreated(httpSessionEvent);
        }
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        if (this.webAppListener != null) {
            this.webAppListener.sessionDestroyed(httpSessionEvent);
        }
    }

    public void attributeAdded(ServletRequestAttributeEvent servletRequestAttributeEvent) {
    }

    public void attributeRemoved(ServletRequestAttributeEvent servletRequestAttributeEvent) {
        if (this.webAppListener != null) {
            this.webAppListener.attributeRemoved(servletRequestAttributeEvent);
        }
    }

    public void attributeReplaced(ServletRequestAttributeEvent servletRequestAttributeEvent) {
        if (this.webAppListener != null) {
            this.webAppListener.attributeReplaced(servletRequestAttributeEvent);
        }
    }

    public void attributeAdded(HttpSessionBindingEvent httpSessionBindingEvent) {
    }

    public void attributeRemoved(HttpSessionBindingEvent httpSessionBindingEvent) {
        if (this.webAppListener != null) {
            this.webAppListener.attributeRemoved(httpSessionBindingEvent);
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent httpSessionBindingEvent) {
        if (this.webAppListener != null) {
            this.webAppListener.attributeReplaced(httpSessionBindingEvent);
        }
    }

    public void attributeAdded(ServletContextAttributeEvent servletContextAttributeEvent) {
    }

    public void attributeRemoved(ServletContextAttributeEvent servletContextAttributeEvent) {
        if (this.webAppListener != null) {
            this.webAppListener.attributeRemoved(servletContextAttributeEvent);
        }
    }

    public void attributeReplaced(ServletContextAttributeEvent servletContextAttributeEvent) {
        if (this.webAppListener != null) {
            this.webAppListener.attributeReplaced(servletContextAttributeEvent);
        }
    }

    private boolean shouldInitConfigMonitoring() {
        boolean bl = this.isDevModeEnabled();
        boolean bl2 = this.webConfig.isSet(WebConfiguration.BooleanWebContextInitParameter.EnableThreading);
        if (bl && !bl2) {
            return true;
        }
        boolean bl3 = this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableThreading);
        return bl && bl2 && bl3;
    }

    private void initConfigMonitoring(ServletContext servletContext) {
        Collection collection = (Collection)servletContext.getAttribute("com.sun.faces.webresources");
        if (this.isDevModeEnabled() && collection != null && !collection.isEmpty()) {
            this.webResourcePool = new ScheduledThreadPoolExecutor(1, new MojarraThreadFactory("WebResourceMonitor"));
            this.webResourcePool.scheduleAtFixedRate(new WebConfigResourceMonitor(servletContext, collection), 2000L, 2000L, TimeUnit.MILLISECONDS);
        }
        servletContext.removeAttribute("com.sun.faces.webresources");
    }

    private void initScripting() {
        GroovyHelper groovyHelper;
        if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableGroovyScripting) && (groovyHelper = GroovyHelperFactory.createHelper()) != null) {
            groovyHelper.setClassLoader();
        }
    }

    private boolean isDevModeEnabled() {
        return "Development".equals(this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.JavaxFacesProjectStage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload(ServletContext servletContext) {
        Object object;
        Object object2;
        Object object3;
        GroovyHelper groovyHelper;
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "Reloading JSF configuration for context {0}", ConfigureListener.getServletContextIdentifier(servletContext));
        }
        if ((groovyHelper = GroovyHelper.getCurrentInstance()) != null) {
            groovyHelper.setClassLoader();
        }
        try {
            if (null != this.webAppListener && (object3 = this.webAppListener.getActiveSessions()) != null) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (HttpSession)object2.next();
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.log(Level.INFO, "Invalidating Session {0}", object.getId());
                    }
                    object.invalidate();
                }
            }
            if ((object3 = ApplicationAssociate.getInstance(servletContext)) != null) {
                object2 = ((ApplicationAssociate)object3).getBeanManager();
                for (Map.Entry object4 : ((BeanManager)object2).getRegisteredBeans().entrySet()) {
                    String string = (String)object4.getKey();
                    BeanBuilder beanBuilder = (BeanBuilder)object4.getValue();
                    if (!ELUtils.Scope.APPLICATION.toString().equals(beanBuilder.getScope())) continue;
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.log(Level.INFO, "Removing application scoped managed bean: {0}", string);
                    }
                    servletContext.removeAttribute(string);
                }
            }
            FactoryFinder.releaseFactories();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            object3 = new InitFacesContext(servletContext);
            ApplicationAssociate.clearInstance(object3.getExternalContext());
            ApplicationAssociate.setCurrentInstance(null);
            ConfigManager.getInstance(servletContext).destroy(servletContext);
            ConfigManager.removeInstance(servletContext);
            object3.release();
            ReflectionUtils.clearCache(Thread.currentThread().getContextClassLoader());
            WebConfiguration.clear(servletContext);
        }
        this.webAppListener = new WebappLifecycleListener(servletContext);
        object3 = new InitFacesContext(servletContext);
        ReflectionUtils.initCache(Thread.currentThread().getContextClassLoader());
        try {
            Boolean bl;
            object2 = ConfigManager.getInstance(servletContext);
            ((ConfigManager)object2).initialize(servletContext);
            this.registerELResolverAndListenerWithJsp(servletContext, true);
            object = ApplicationAssociate.getInstance(servletContext);
            if (object != null && null != (bl = (Boolean)servletContext.getAttribute("com.sun.faces.errorPagePresent"))) {
                ((ApplicationAssociate)object).setErrorPagePresent(bl);
                ((ApplicationAssociate)object).setContextName(ConfigureListener.getServletContextIdentifier(servletContext));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            object3.release();
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "Reload complete.", ConfigureListener.getServletContextIdentifier(servletContext));
        }
    }

    private static String getServletContextIdentifier(ServletContext servletContext) {
        if (servletContext.getMajorVersion() == 2 && servletContext.getMinorVersion() < 5) {
            return servletContext.getServletContextName();
        }
        return servletContext.getContextPath();
    }

    private static boolean isJspTwoOne(ServletContext servletContext) {
        block7: {
            try {
                Class.forName("org.apache.jasper.compiler.JspRuntimeContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!LOGGER.isLoggable(Level.FINEST)) break block7;
                LOGGER.log(Level.FINEST, "Dected JSP 2.1", classNotFoundException);
            }
        }
        if (JspFactory.getDefaultFactory() == null) {
            return false;
        }
        try {
            JspFactory.class.getMethod("getJspApplicationContext", ServletContext.class);
        }
        catch (Exception exception) {
            return false;
        }
        try {
            JspFactory.getDefaultFactory().getJspApplicationContext(servletContext);
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    public void registerELResolverAndListenerWithJsp(ServletContext servletContext, boolean bl) {
        if (this.webConfig.isSet(WebConfiguration.WebContextInitParameter.ExpressionFactory) || !ConfigureListener.isJspTwoOne(servletContext)) {
            if (!this.installExpressionFactory(servletContext, this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.ExpressionFactory))) {
                throw new ConfigurationException(MessageUtils.getExceptionMessageString("com.sun.faces.INCORRECT_JSP_VERSION", WebConfiguration.WebContextInitParameter.ExpressionFactory.getDefaultValue(), WebConfiguration.WebContextInitParameter.ExpressionFactory.getQualifiedName()));
            }
        } else {
            JspApplicationContext jspApplicationContext;
            block8: {
                if (JspFactory.getDefaultFactory().getJspApplicationContext(servletContext) == null) {
                    return;
                }
                ChainTypeCompositeELResolver chainTypeCompositeELResolver = new ChainTypeCompositeELResolver(FacesCompositeELResolver.ELResolverChainType.JSP);
                ApplicationAssociate applicationAssociate = ApplicationAssociate.getInstance(servletContext);
                if (applicationAssociate != null) {
                    applicationAssociate.setFacesELResolverForJsp(chainTypeCompositeELResolver);
                }
                jspApplicationContext = JspFactory.getDefaultFactory().getJspApplicationContext(servletContext);
                if (applicationAssociate != null) {
                    applicationAssociate.setExpressionFactory(jspApplicationContext.getExpressionFactory());
                }
                try {
                    jspApplicationContext.addELResolver((ELResolver)chainTypeCompositeELResolver);
                }
                catch (IllegalStateException illegalStateException) {
                    ApplicationFactory applicationFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
                    Application application = applicationFactory.getApplication();
                    if (application.getProjectStage() == ProjectStage.UnitTest || bl) break block8;
                    throw illegalStateException;
                }
            }
            ELContextListenerImpl eLContextListenerImpl = new ELContextListenerImpl();
            jspApplicationContext.addELContextListener((ELContextListener)eLContextListenerImpl);
        }
    }

    private boolean installExpressionFactory(ServletContext servletContext, String string) {
        if (string == null) {
            return false;
        }
        try {
            ExpressionFactory expressionFactory = (ExpressionFactory)Util.loadClass(string, this).newInstance();
            ApplicationAssociate applicationAssociate = ApplicationAssociate.getInstance(servletContext);
            if (applicationAssociate != null) {
                applicationAssociate.setExpressionFactory(expressionFactory);
            }
            return true;
        }
        catch (Exception exception) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.severe(MessageFormat.format("Unable to instantiate ExpressionFactory ''{0}''", string));
            }
            return false;
        }
    }

    private InitFacesContext getInitFacesContext(ServletContext servletContext) {
        Map map = InitFacesContext.getInitContextServletContextMap();
        Set set = map.entrySet();
        InitFacesContext initFacesContext = null;
        for (Map.Entry entry : set) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (servletContext != v) continue;
            initFacesContext = (InitFacesContext)((Object)k);
            break;
        }
        return initFacesContext;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WebConfigResourceMonitor
    implements Runnable {
        private List<Monitor> monitors;
        private ServletContext sc;

        public WebConfigResourceMonitor(ServletContext servletContext, Collection<URI> collection) {
            assert (collection != null);
            this.sc = servletContext;
            for (URI uRI : collection) {
                if (this.monitors == null) {
                    this.monitors = new ArrayList<Monitor>(collection.size());
                }
                try {
                    Monitor monitor = new Monitor(uRI);
                    this.monitors.add(monitor);
                }
                catch (IOException iOException) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.severe("Unable to setup resource monitor for " + uRI.toString() + ".  Resource will not be monitored for changes.");
                    }
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.log(Level.FINE, iOException.toString(), iOException);
                }
            }
        }

        @Override
        public void run() {
            assert (this.monitors != null);
            boolean bl = false;
            Iterator<Monitor> iterator = this.monitors.iterator();
            while (iterator.hasNext()) {
                Monitor monitor = iterator.next();
                try {
                    if (!monitor.hasBeenModified() || bl) continue;
                    bl = true;
                }
                catch (IOException iOException) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.severe("Unable to access url " + monitor.uri.toString() + ".  Monitoring for this resource will no longer occur.");
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, iOException.toString(), iOException);
                    }
                    iterator.remove();
                }
            }
            if (bl) {
                ConfigureListener.this.reload(this.sc);
            }
        }

        private class Monitor {
            private URI uri;
            private long timestamp = -1L;

            Monitor(URI uRI) throws IOException {
                this.uri = uRI;
                this.timestamp = this.getLastModified();
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "Monitoring {0} for modifications", uRI.toURL().toExternalForm());
                }
            }

            boolean hasBeenModified() throws IOException {
                long l = this.getLastModified();
                if (this.timestamp < l) {
                    this.timestamp = l;
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.log(Level.INFO, "{0} changed!", this.uri.toURL().toExternalForm());
                    }
                    return true;
                }
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private long getLastModified() throws IOException {
                InputStream inputStream = null;
                try {
                    URLConnection uRLConnection = this.uri.toURL().openConnection();
                    uRLConnection.connect();
                    inputStream = uRLConnection.getInputStream();
                    long l = uRLConnection.getLastModified();
                    return l;
                }
                finally {
                    block8: {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {
                                if (!LOGGER.isLoggable(Level.FINEST)) break block8;
                                LOGGER.log(Level.FINEST, "Exception while closing stream", iOException);
                            }
                        }
                    }
                }
            }
        }
    }

    private static class WebXmlProcessor {
        private static final String WEB_XML_PATH = "/WEB-INF/web.xml";
        private static final String WEB_FRAGMENT_PATH = "META-INF/web-fragment.xml";
        private boolean facesServletPresent;
        private boolean errorPagePresent;
        private boolean distributablePresent;

        WebXmlProcessor(ServletContext servletContext) {
            if (servletContext != null) {
                this.scanForFacesServlet(servletContext);
            }
        }

        boolean isFacesServletPresent() {
            return this.facesServletPresent;
        }

        boolean isErrorPagePresent() {
            return this.errorPagePresent;
        }

        public boolean isDistributablePresent() {
            return this.distributablePresent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scanForFacesServlet(ServletContext servletContext) {
            Object object;
            InputStream inputStream = servletContext.getResourceAsStream(WEB_XML_PATH);
            if (inputStream == null && servletContext.getMajorVersion() < 3) {
                throw new ConfigurationException("no web.xml present");
            }
            SAXParserFactory sAXParserFactory = this.getConfiguredFactory();
            if (inputStream != null) {
                try {
                    object = sAXParserFactory.newSAXParser();
                    ((SAXParser)object).parse(inputStream, (DefaultHandler)new WebXmlHandler());
                }
                catch (Exception exception) {
                    this.warnProcessingError(exception, servletContext);
                    this.facesServletPresent = true;
                    return;
                }
                finally {
                    block31: {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Exception exception) {
                                if (!LOGGER.isLoggable(Level.FINEST)) break block31;
                                LOGGER.log(Level.FINEST, "Closing stream", exception);
                            }
                        }
                    }
                }
            }
            if (!this.facesServletPresent && servletContext.getMajorVersion() >= 3) {
                Enumeration<URL> enumeration;
                object = Util.getCurrentLoader(this);
                try {
                    enumeration = ((ClassLoader)object).getResources(WEB_FRAGMENT_PATH);
                }
                catch (IOException iOException) {
                    throw new ConfigurationException(iOException);
                }
                if (enumeration != null) {
                    while (enumeration.hasMoreElements() && !this.facesServletPresent) {
                        InputStream inputStream2 = null;
                        try {
                            URL uRL = enumeration.nextElement();
                            URLConnection uRLConnection = uRL.openConnection();
                            uRLConnection.setUseCaches(false);
                            inputStream2 = uRLConnection.getInputStream();
                            SAXParser sAXParser = sAXParserFactory.newSAXParser();
                            sAXParser.parse(inputStream2, (DefaultHandler)new WebXmlHandler());
                        }
                        catch (Exception exception) {
                            this.warnProcessingError(exception, servletContext);
                            this.facesServletPresent = true;
                            return;
                        }
                        finally {
                            if (inputStream2 == null) continue;
                            try {
                                inputStream2.close();
                            }
                            catch (IOException iOException) {
                                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                                LOGGER.log(Level.WARNING, "Exception whil scanning for FacesServlet", iOException);
                            }
                        }
                    }
                }
            }
        }

        private SAXParserFactory getConfiguredFactory() {
            SAXParserFactory sAXParserFactory = Util.createSAXParserFactory();
            sAXParserFactory.setValidating(false);
            sAXParserFactory.setNamespaceAware(true);
            return sAXParserFactory;
        }

        private void warnProcessingError(Exception exception, ServletContext servletContext) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, MessageFormat.format("jsf.configuration.web.xml.parse.failed", ConfigureListener.getServletContextIdentifier(servletContext)), exception);
            }
        }

        private class WebXmlHandler
        extends DefaultHandler {
            private static final String ERROR_PAGE = "error-page";
            private static final String SERVLET_CLASS = "servlet-class";
            private static final String FACES_SERVLET = "javax.faces.webapp.FacesServlet";
            private boolean servletClassFound;
            private StringBuffer content;

            private WebXmlHandler() {
            }

            public InputSource resolveEntity(String string, String string2) throws SAXException {
                return new InputSource(new StringReader(""));
            }

            public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                if (!WebXmlProcessor.this.errorPagePresent && ERROR_PAGE.equals(string2)) {
                    WebXmlProcessor.this.errorPagePresent = true;
                    return;
                }
                if (!WebXmlProcessor.this.facesServletPresent) {
                    if (SERVLET_CLASS.equals(string2)) {
                        this.servletClassFound = true;
                        this.content = new StringBuffer();
                    } else {
                        this.servletClassFound = false;
                    }
                }
                if ("distributable".equals(string2)) {
                    WebXmlProcessor.this.distributablePresent = true;
                }
            }

            public void characters(char[] cArray, int n, int n2) throws SAXException {
                if (this.servletClassFound && !WebXmlProcessor.this.facesServletPresent) {
                    this.content.append(cArray, n, n2);
                }
            }

            public void endElement(String string, String string2, String string3) throws SAXException {
                if (this.servletClassFound && !WebXmlProcessor.this.facesServletPresent && FACES_SERVLET.equals(this.content.toString().trim())) {
                    WebXmlProcessor.this.facesServletPresent = true;
                }
            }
        }
    }
}

