/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.el.ELUtils;
import com.sun.faces.mgbean.BeanManager;
import com.sun.faces.mgbean.ManagedBeanInfo;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.TypedCollections;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.bean.ManagedBean;
import javax.servlet.ServletContext;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ManagedBeanConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String MANAGED_BEAN = "managed-bean";
    private static final String DESCRIPTION = "description";
    private static final String MGBEAN_NAME = "managed-bean-name";
    private static final String MGBEAN_CLASS = "managed-bean-class";
    private static final String MGBEAN_SCOPE = "managed-bean-scope";
    private static final String MG_PROPERTY = "managed-property";
    private static final String MG_PROPERTY_NAME = "property-name";
    private static final String MG_PROPERTY_TYPE = "property-class";
    private static final String NULL_VALUE = "null-value";
    private static final String VALUE = "value";
    private static final String KEY = "key";
    private static final String MAP_KEY_CLASS = "key-class";
    private static final String VALUE_CLASS = "value-class";
    private static final String MAP_ENTRY = "map-entry";
    private static final String MAP_ENTRIES = "map-entries";
    private static final String LIST_ENTRIES = "list-entries";
    private static final String EAGER_ATTRIBUTE = "eager";
    private static final String DEFAULT_SCOPE = "request";

    public void process(ServletContext servletContext, DocumentInfo[] documentInfoArray) throws Exception {
        this.processAnnotations(ManagedBean.class);
        BeanManager beanManager = ApplicationAssociate.getInstance(servletContext).getBeanManager();
        for (int i = 0; i < documentInfoArray.length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing managed-bean elements for document: ''{0}''", documentInfoArray[i].getSourceURI()));
            }
            Document document = documentInfoArray[i].getDocument();
            String string = document.getDocumentElement().getNamespaceURI();
            NodeList nodeList = document.getDocumentElement().getElementsByTagNameNS(string, MANAGED_BEAN);
            if (nodeList == null || nodeList.getLength() <= 0) continue;
            int n = nodeList.getLength();
            for (int j = 0; j < n; ++j) {
                this.addManagedBean(beanManager, nodeList.item(j));
            }
        }
        beanManager.preProcessesBeans();
        this.invokeNext(servletContext, documentInfoArray);
    }

    private void addManagedBean(BeanManager beanManager, Node node) {
        NodeList nodeList = node.getChildNodes();
        String string = null;
        String string2 = null;
        String string3 = null;
        ManagedBeanInfo.ListEntry listEntry = null;
        ManagedBeanInfo.MapEntry mapEntry = null;
        ArrayList<Node> arrayList = null;
        ArrayList<Node> arrayList2 = null;
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if (MGBEAN_NAME.equals(node2.getLocalName())) {
                string = this.getNodeText(node2);
                continue;
            }
            if (MGBEAN_CLASS.equals(node2.getLocalName())) {
                string2 = this.getNodeText(node2);
                continue;
            }
            if (MGBEAN_SCOPE.equals(node2.getLocalName())) {
                string3 = this.getNodeText(node2);
                if (string3 != null) continue;
                string3 = DEFAULT_SCOPE;
                continue;
            }
            if (LIST_ENTRIES.equals(node2.getLocalName())) {
                listEntry = this.buildListEntry(node2);
                continue;
            }
            if (MAP_ENTRIES.equals(node2.getLocalName())) {
                mapEntry = this.buildMapEntry(node2);
                continue;
            }
            if (MG_PROPERTY.equals(node2.getLocalName())) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Node>(n);
                }
                arrayList.add(node2);
                continue;
            }
            if (!DESCRIPTION.equals(node2.getLocalName())) continue;
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<Node>(4);
            }
            arrayList2.add(node2);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Begin processing managed bean ''{0}''", string);
        }
        ArrayList<ManagedBeanInfo.ManagedProperty> arrayList3 = null;
        if (arrayList != null && !arrayList.isEmpty()) {
            arrayList3 = new ArrayList<ManagedBeanInfo.ManagedProperty>(arrayList.size());
            for (Node node2 : arrayList) {
                arrayList3.add(this.buildManagedProperty(node2));
            }
        }
        beanManager.register(new ManagedBeanInfo(string, string2, string3, this.isEager(node, string, string3), mapEntry, listEntry, arrayList3, this.getTextMap(arrayList2)));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Completed processing bean ''{0}''", string);
        }
    }

    private ManagedBeanInfo.ListEntry buildListEntry(Node node) {
        if (node != null) {
            String string = "java.lang.String";
            List<String> list = null;
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                if (VALUE_CLASS.equals(node2.getLocalName())) {
                    string = this.getNodeText(node2);
                    continue;
                }
                if (VALUE.equals(node2.getLocalName())) {
                    if (list == null) {
                        list = new ArrayList<String>(n);
                    }
                    list.add(this.getNodeText(node2));
                    continue;
                }
                if (!NULL_VALUE.equals(node2.getLocalName())) continue;
                if (list == null) {
                    list = new ArrayList<String>(n);
                }
                list.add("null_value");
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Created ListEntry valueClass={1}, values={3}", string, list != null && !list.isEmpty() ? list.toString() : "none"));
            }
            return new ManagedBeanInfo.ListEntry(string, list == null ? TypedCollections.dynamicallyCastList(Collections.emptyList(), String.class) : list);
        }
        return null;
    }

    private ManagedBeanInfo.MapEntry buildMapEntry(Node node) {
        if (node != null) {
            String string = "java.lang.String";
            String string2 = "java.lang.String";
            LinkedHashMap<String, String> linkedHashMap = null;
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                if (VALUE_CLASS.equals(node2.getLocalName())) {
                    string = this.getNodeText(node2);
                    continue;
                }
                if (MAP_KEY_CLASS.equals(node2.getLocalName())) {
                    string2 = this.getNodeText(node2);
                    continue;
                }
                if (!MAP_ENTRY.equals(node2.getLocalName())) continue;
                if (linkedHashMap == null) {
                    linkedHashMap = new LinkedHashMap<String, String>(8, 1.0f);
                }
                NodeList nodeList2 = node2.getChildNodes();
                String string3 = null;
                String string4 = null;
                int n2 = nodeList2.getLength();
                for (int j = 0; j < n2; ++j) {
                    Node node3 = nodeList2.item(j);
                    if (node3.getNodeType() != 1) continue;
                    if (KEY.equals(node3.getLocalName())) {
                        string3 = this.getNodeText(node3);
                        continue;
                    }
                    if (VALUE.equals(node3.getLocalName())) {
                        string4 = this.getNodeText(node3);
                        continue;
                    }
                    if (!NULL_VALUE.equals(node3.getLocalName())) continue;
                    string4 = "null_value";
                }
                linkedHashMap.put(string3, string4);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Created MapEntry keyClass={0}, valueClass={1}, entries={3}", string2, string, linkedHashMap != null ? ((Object)linkedHashMap).toString() : "none"));
            }
            return new ManagedBeanInfo.MapEntry(string2, string, linkedHashMap);
        }
        return null;
    }

    private ManagedBeanInfo.ManagedProperty buildManagedProperty(Node node) {
        if (node != null) {
            String string = null;
            String string2 = null;
            String string3 = null;
            ManagedBeanInfo.MapEntry mapEntry = null;
            ManagedBeanInfo.ListEntry listEntry = null;
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                if (MG_PROPERTY_NAME.equals(node2.getLocalName())) {
                    string = this.getNodeText(node2);
                    continue;
                }
                if (MG_PROPERTY_TYPE.equals(node2.getLocalName())) {
                    string2 = this.getNodeText(node2);
                    continue;
                }
                if (VALUE.equals(node2.getLocalName())) {
                    string3 = this.getNodeText(node2);
                    continue;
                }
                if (NULL_VALUE.equals(node2.getLocalName())) {
                    string3 = "null_value";
                    continue;
                }
                if (LIST_ENTRIES.equals(node2.getLocalName())) {
                    listEntry = this.buildListEntry(node2);
                    continue;
                }
                if (!MAP_ENTRIES.equals(node2.getLocalName())) continue;
                mapEntry = this.buildMapEntry(node2);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Adding ManagedProperty propertyName={0}, propertyClass={1}, propertyValue={2}, hasMapEntry={3}, hasListEntry={4}", string, string2 != null ? string2 : "inferred", string3, mapEntry != null, listEntry != null));
            }
            return new ManagedBeanInfo.ManagedProperty(string, string2, string3, mapEntry, listEntry);
        }
        return null;
    }

    private boolean isEager(Node node, String string, String string2) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem(EAGER_ATTRIBUTE);
        boolean bl = false;
        if (node2 != null && (bl = Boolean.valueOf(this.getNodeText(node2)).booleanValue()) && (string2 == null || !ELUtils.Scope.APPLICATION.toString().equals(string2))) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.configuration.illegal.eager.bean", new Object[]{string, string2});
            }
            bl = false;
        }
        return bl;
    }
}

