/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.flow;

import com.sun.faces.flow.FlowCDIContext;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import com.sun.faces.util.cdi11.CDIUtil;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;
import javax.faces.flow.FlowScoped;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowCDIExtension
implements Extension {
    private Map<Contextual<?>, FlowCDIContext.FlowBeanInfo> flowScopedBeanFlowIds = new ConcurrentHashMap();
    private boolean isCdiOneOneOrGreater = Util.isCdiOneOneOrGreater();
    private CDIUtil cdiUtil = null;
    private static final Logger LOGGER = FacesLogger.FLOW.getLogger();

    public void processBean(@Observes ProcessBean<?> processBean) {
        FlowScoped flowScoped = (FlowScoped)processBean.getAnnotated().getAnnotation(FlowScoped.class);
        if (null != flowScoped) {
            FlowCDIContext.FlowBeanInfo flowBeanInfo = new FlowCDIContext.FlowBeanInfo();
            flowBeanInfo.definingDocumentId = flowScoped.definingDocumentId();
            flowBeanInfo.id = flowScoped.value();
            this.flowScopedBeanFlowIds.put((Contextual<?>)processBean.getBean(), flowBeanInfo);
        }
    }

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        beforeBeanDiscovery.addScope(FlowScoped.class, true, true);
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        afterBeanDiscovery.addContext((Context)new FlowCDIContext(this.flowScopedBeanFlowIds));
        this.flowScopedBeanFlowIds.clear();
        if (this.isCdiOneOneOrGreater) {
            Bean bean;
            Class<?> clazz = null;
            try {
                clazz = Class.forName("com.sun.faces.flow.FlowCDIEventFireHelperImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "CDI 1.1 events not enabled", classNotFoundException);
                }
                return;
            }
            if (null == this.cdiUtil) {
                bean = ServiceLoader.load(CDIUtil.class);
                for (CDIUtil cDIUtil : bean) {
                    if (null != this.cdiUtil) {
                        String string = "Must only have one implementation of CDIUtil available";
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, string);
                        }
                        throw new IllegalStateException(string);
                    }
                    this.cdiUtil = cDIUtil;
                }
            }
            if (null != this.cdiUtil) {
                bean = this.cdiUtil.createHelperBean(beanManager, clazz);
                afterBeanDiscovery.addBean(bean);
            } else if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Unable to obtain CDI 1.1 utilities for Mojarra");
            }
        }
    }
}

