/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.runtime;

import com.swoval.runtime.Platform;
import com.swoval.runtime.ShutdownHooks;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class NativeLoader {
    private static final String NATIVE_LIBRARY = "swoval-files0";
    private static final String lib = System.mapLibraryName("swoval-files0");
    private static boolean loaded = false;

    private static void cleanupTask(Path path) {
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    if (Platform.isWin()) {
                        try {
                            Files.deleteIfExists(path);
                        }
                        catch (IOException iOException) {}
                    } else if (path.toString().endsWith(".pid")) {
                        String string = new String(Files.readAllBytes(path));
                        boolean bl = true;
                        if (ShutdownHooks.isShutdown()) {
                            bl = !string.equals(ShutdownHooks.getPid());
                        } else {
                            Process process = new ProcessBuilder("ps", "-p", string).start();
                            try {
                                process.waitFor();
                                InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
                                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                                String string2 = bufferedReader.readLine();
                                while (string2 != null) {
                                    bl = string2.contains(string + " ");
                                    string2 = bufferedReader.readLine();
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if (!bl) {
                            Files.deleteIfExists(Paths.get(path.toString().replaceAll(".pid", ""), new String[0]));
                            Files.deleteIfExists(path);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path path, IOException iOException) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
                    try {
                        Files.deleteIfExists(path);
                    }
                    catch (DirectoryNotEmptyException directoryNotEmptyException) {
                    }
                    catch (IOException iOException2) {
                        throw iOException2;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void loadPackaged(String string) throws IOException {
        Object object;
        final Path path = Files.createDirectories(Paths.get(System.getProperty("swoval.tmpdir", System.getProperty("java.io.tmpdir", "/tmp")), new String[0]).resolve("swoval-jni"), new FileAttribute[0]);
        String string2 = Platform.isFreeBSD() ? "/freebsd" : "/";
        String string3 = "/native/" + string + string2 + lib;
        InputStream inputStream = NativeLoader.class.getResourceAsStream(string3);
        if (inputStream == null) {
            String string4 = "Native library " + lib + " (" + string3 + ") can't be loaded.";
            throw new UnsatisfiedLinkError(string4);
        }
        Path path2 = Files.createTempFile(path, "", "-" + lib, new FileAttribute[0]);
        FileOutputStream fileOutputStream = new FileOutputStream(path2.toFile());
        try {
            int n;
            object = new byte[1024];
            while ((n = inputStream.read((byte[])object)) >= 0) {
                ((OutputStream)fileOutputStream).write((byte[])object, 0, n);
            }
        }
        catch (Exception exception) {
            throw new UnsatisfiedLinkError("Error while extracting native library: " + exception);
        }
        finally {
            inputStream.close();
            ((OutputStream)fileOutputStream).close();
        }
        object = new Runnable(){

            @Override
            public void run() {
                NativeLoader.cleanupTask(path);
            }
        };
        try {
            System.load(path2.toString());
            if (!Platform.isWin()) {
                Files.write(Paths.get(path2.toString() + ".pid", new String[0]), ShutdownHooks.getPid().getBytes(), new OpenOption[0]);
                ShutdownHooks.addHook(1, (Runnable)object);
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Files.deleteIfExists(path2);
            throw unsatisfiedLinkError;
        }
        Thread thread = new Thread((Runnable)object, "com.swoval.runtime.NativeLoader.cleanupThread");
        thread.setDaemon(true);
        thread.start();
    }

    public static synchronized void loadPackaged() throws IOException, UnsatisfiedLinkError {
        if (!loaded) {
            try {
                System.loadLibrary(NATIVE_LIBRARY);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                boolean bl = System.getProperty("sun.arch.data.model", "64").equals("64");
                if (!bl) {
                    throw new UnsatisfiedLinkError("No 32 bit native libraries are provided.");
                }
                if (!(Platform.isFreeBSD() || Platform.isMac() || Platform.isLinux() || Platform.isWin())) {
                    throw new UnsatisfiedLinkError("No native libary is available for '" + System.getProperty("os.name", ""));
                }
                NativeLoader.loadPackaged("x86_64");
            }
            loaded = true;
        }
    }
}

