/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.text.renderers;

import com.taobao.text.LineRenderer;
import com.taobao.text.Renderer;
import com.taobao.text.ui.LabelElement;
import com.taobao.text.ui.RowElement;
import com.taobao.text.ui.TableElement;
import java.util.Iterator;

public class BindingRenderer
extends Renderer<BindingData> {
    @Override
    public Class<BindingData> getType() {
        return BindingData.class;
    }

    @Override
    public LineRenderer renderer(Iterator<BindingData> stream) {
        TableElement table = new TableElement();
        table.setRightCellPadding(1);
        RowElement header = new RowElement(true);
        header.add("NAME");
        table.add(header);
        while (stream.hasNext()) {
            BindingData binding = stream.next();
            RowElement row = new RowElement();
            row.add(binding.name);
            if (binding.verbose.booleanValue()) {
                row.add(new LabelElement(binding.type));
                if (header.getSize() == 1) {
                    header.add("CLASS");
                }
            }
            table.add(row);
        }
        return table.renderer();
    }

    public static class BindingData {
        public final String name;
        public final String type;
        public final Object instance;
        public final Boolean verbose;

        public BindingData(String name, String type, Object instance, Boolean verbose) {
            this.name = name;
            this.type = type;
            this.instance = instance;
            this.verbose = verbose != null ? verbose : false;
        }
    }
}

