/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.asn1;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1Messages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ASN1Integer
extends ASN1Element {
    private static final long serialVersionUID = -733929804601994372L;
    private final int intValue;

    public ASN1Integer(int intValue) {
        super((byte)2, ASN1Integer.encodeIntValue(intValue));
        this.intValue = intValue;
    }

    public ASN1Integer(byte type, int intValue) {
        super(type, ASN1Integer.encodeIntValue(intValue));
        this.intValue = intValue;
    }

    private ASN1Integer(byte type, int intValue, @NotNull byte[] value) {
        super(type, value);
        this.intValue = intValue;
    }

    @NotNull
    static byte[] encodeIntValue(int intValue) {
        if (intValue < 0) {
            if ((intValue & 0xFFFFFF80) == -128) {
                return new byte[]{(byte)(intValue & 0xFF)};
            }
            if ((intValue & Short.MIN_VALUE) == Short.MIN_VALUE) {
                return new byte[]{(byte)(intValue >> 8 & 0xFF), (byte)(intValue & 0xFF)};
            }
            if ((intValue & 0xFF800000) == -8388608) {
                return new byte[]{(byte)(intValue >> 16 & 0xFF), (byte)(intValue >> 8 & 0xFF), (byte)(intValue & 0xFF)};
            }
            return new byte[]{(byte)(intValue >> 24 & 0xFF), (byte)(intValue >> 16 & 0xFF), (byte)(intValue >> 8 & 0xFF), (byte)(intValue & 0xFF)};
        }
        if ((intValue & 0x7F) == intValue) {
            return new byte[]{(byte)(intValue & 0x7F)};
        }
        if ((intValue & Short.MAX_VALUE) == intValue) {
            return new byte[]{(byte)(intValue >> 8 & 0x7F), (byte)(intValue & 0xFF)};
        }
        if ((intValue & 0x7FFFFF) == intValue) {
            return new byte[]{(byte)(intValue >> 16 & 0x7F), (byte)(intValue >> 8 & 0xFF), (byte)(intValue & 0xFF)};
        }
        return new byte[]{(byte)(intValue >> 24 & 0x7F), (byte)(intValue >> 16 & 0xFF), (byte)(intValue >> 8 & 0xFF), (byte)(intValue & 0xFF)};
    }

    public int intValue() {
        return this.intValue;
    }

    @NotNull
    public static ASN1Integer decodeAsInteger(@NotNull byte[] elementBytes) throws ASN1Exception {
        try {
            int intValue;
            int valueStartPos = 2;
            int length = elementBytes[1] & 0x7F;
            if (length != elementBytes[1]) {
                int numLengthBytes = length;
                length = 0;
                for (int i = 0; i < numLengthBytes; ++i) {
                    length <<= 8;
                    length |= elementBytes[valueStartPos++] & 0xFF;
                }
            }
            if (elementBytes.length - valueStartPos != length) {
                throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_LENGTH_MISMATCH.get(length, elementBytes.length - valueStartPos));
            }
            byte[] value = new byte[length];
            System.arraycopy(elementBytes, valueStartPos, value, 0, length);
            switch (value.length) {
                case 1: {
                    intValue = value[0] & 0xFF;
                    if ((value[0] & 0x80) == 0) break;
                    intValue |= 0xFFFFFF00;
                    break;
                }
                case 2: {
                    intValue = (value[0] & 0xFF) << 8 | value[1] & 0xFF;
                    if ((value[0] & 0x80) == 0) break;
                    intValue |= 0xFFFF0000;
                    break;
                }
                case 3: {
                    intValue = (value[0] & 0xFF) << 16 | (value[1] & 0xFF) << 8 | value[2] & 0xFF;
                    if ((value[0] & 0x80) == 0) break;
                    intValue |= 0xFF000000;
                    break;
                }
                case 4: {
                    intValue = (value[0] & 0xFF) << 24 | (value[1] & 0xFF) << 16 | (value[2] & 0xFF) << 8 | value[3] & 0xFF;
                    break;
                }
                default: {
                    throw new ASN1Exception(ASN1Messages.ERR_ENUMERATED_INVALID_LENGTH.get(value.length));
                }
            }
            return new ASN1Integer(elementBytes[0], intValue, value);
        }
        catch (ASN1Exception ae) {
            Debug.debugException(ae);
            throw ae;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_DECODE_EXCEPTION.get(e), e);
        }
    }

    @NotNull
    public static ASN1Integer decodeAsInteger(@NotNull ASN1Element element) throws ASN1Exception {
        int intValue;
        byte[] value = element.getValue();
        switch (value.length) {
            case 1: {
                intValue = value[0] & 0xFF;
                if ((value[0] & 0x80) == 0) break;
                intValue |= 0xFFFFFF00;
                break;
            }
            case 2: {
                intValue = (value[0] & 0xFF) << 8 | value[1] & 0xFF;
                if ((value[0] & 0x80) == 0) break;
                intValue |= 0xFFFF0000;
                break;
            }
            case 3: {
                intValue = (value[0] & 0xFF) << 16 | (value[1] & 0xFF) << 8 | value[2] & 0xFF;
                if ((value[0] & 0x80) == 0) break;
                intValue |= 0xFF000000;
                break;
            }
            case 4: {
                intValue = (value[0] & 0xFF) << 24 | (value[1] & 0xFF) << 16 | (value[2] & 0xFF) << 8 | value[3] & 0xFF;
                break;
            }
            default: {
                throw new ASN1Exception(ASN1Messages.ERR_INTEGER_INVALID_LENGTH.get(value.length));
            }
        }
        return new ASN1Integer(element.getType(), intValue, value);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append(this.intValue);
    }
}

