/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum OperationType {
    ABANDON,
    ADD,
    BIND,
    COMPARE,
    DELETE,
    EXTENDED,
    MODIFY,
    MODIFY_DN,
    SEARCH,
    UNBIND;


    @Nullable
    public static OperationType forName(@NotNull String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "abandon": {
                return ABANDON;
            }
            case "add": {
                return ADD;
            }
            case "bind": {
                return BIND;
            }
            case "compare": {
                return COMPARE;
            }
            case "delete": 
            case "del": {
                return DELETE;
            }
            case "extended": 
            case "extendedoperation": 
            case "extended-operation": 
            case "extended_operation": 
            case "extendedop": 
            case "extended-op": 
            case "extended_op": 
            case "extop": 
            case "ext-op": 
            case "ext_op": {
                return EXTENDED;
            }
            case "modify": 
            case "mod": {
                return MODIFY;
            }
            case "modifydn": 
            case "modify-dn": 
            case "modify_dn": 
            case "moddn": 
            case "mod-dn": 
            case "mod_dn": 
            case "modifyrdn": 
            case "modify-rdn": 
            case "modify_rdn": 
            case "modrdn": 
            case "mod-rdn": 
            case "mod_rdn": {
                return MODIFY_DN;
            }
            case "search": {
                return SEARCH;
            }
            case "unbind": {
                return UNBIND;
            }
        }
        return null;
    }
}

