/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.toc.internal;

import com.vladsch.flexmark.ext.toc.internal.TocLevelsOptionParser;
import com.vladsch.flexmark.ext.toc.internal.TocOptions;
import com.vladsch.flexmark.util.Pair;
import com.vladsch.flexmark.util.options.BooleanOptionParser;
import com.vladsch.flexmark.util.options.MessageProvider;
import com.vladsch.flexmark.util.options.OptionParser;
import com.vladsch.flexmark.util.options.ParsedOption;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.List;

public enum SimTocOptionTypes implements OptionParser<TocOptions>
{
    LEVELS(new TocLevelsOptionParser("levels")),
    HTML((OptionParser<TocOptions>)new BooleanOptionParser<TocOptions>("html"){

        protected boolean isOptionSet(TocOptions options) {
            return options.isHtml;
        }

        protected TocOptions setOptions(TocOptions options) {
            return options.withIsHtml(true);
        }
    }),
    MARKDOWN((OptionParser<TocOptions>)new BooleanOptionParser<TocOptions>("markdown"){

        protected boolean isOptionSet(TocOptions options) {
            return !options.isHtml;
        }

        public TocOptions setOptions(TocOptions options) {
            return options.withIsHtml(false);
        }
    }),
    BULLETS((OptionParser<TocOptions>)new BooleanOptionParser<TocOptions>("bullet"){

        protected boolean isOptionSet(TocOptions options) {
            return !options.isNumbered;
        }

        public TocOptions setOptions(TocOptions options) {
            return options.withIsNumbered(false);
        }
    }),
    NUMERIC((OptionParser<TocOptions>)new BooleanOptionParser<TocOptions>("numbered"){

        protected boolean isOptionSet(TocOptions options) {
            return options.isNumbered;
        }

        public TocOptions setOptions(TocOptions options) {
            return options.withIsNumbered(true);
        }
    }),
    TEXT((OptionParser<TocOptions>)new BooleanOptionParser<TocOptions>("text"){

        protected boolean isOptionSet(TocOptions options) {
            return options.isTextOnly;
        }

        public TocOptions setOptions(TocOptions options) {
            return options.withIsTextOnly(true);
        }
    }),
    FORMATTED((OptionParser<TocOptions>)new BooleanOptionParser<TocOptions>("formatted"){

        protected boolean isOptionSet(TocOptions options) {
            return !options.isTextOnly;
        }

        public TocOptions setOptions(TocOptions options) {
            return options.withIsTextOnly(false);
        }
    }),
    HIERARCHY((OptionParser<TocOptions>)new BooleanOptionParser<TocOptions>("hierarchy"){

        protected boolean isOptionSet(TocOptions options) {
            return options.listType == TocOptions.ListType.HIERARCHY;
        }

        public TocOptions setOptions(TocOptions options) {
            return options.withListType(TocOptions.ListType.HIERARCHY);
        }
    }),
    FLAT((OptionParser<TocOptions>)new BooleanOptionParser<TocOptions>("flat"){

        protected boolean isOptionSet(TocOptions options) {
            return options.listType == TocOptions.ListType.FLAT;
        }

        public TocOptions setOptions(TocOptions options) {
            return options.withListType(TocOptions.ListType.FLAT);
        }
    }),
    FLAT_REVERSED((OptionParser<TocOptions>)new BooleanOptionParser<TocOptions>("reversed"){

        protected boolean isOptionSet(TocOptions options) {
            return options.listType == TocOptions.ListType.FLAT_REVERSED;
        }

        public TocOptions setOptions(TocOptions options) {
            return options.withListType(TocOptions.ListType.FLAT_REVERSED);
        }
    }),
    SORTED((OptionParser<TocOptions>)new BooleanOptionParser<TocOptions>("increasing"){

        protected boolean isOptionSet(TocOptions options) {
            return options.listType == TocOptions.ListType.SORTED;
        }

        public TocOptions setOptions(TocOptions options) {
            return options.withListType(TocOptions.ListType.SORTED);
        }
    }),
    SORTED_REVERSED((OptionParser<TocOptions>)new BooleanOptionParser<TocOptions>("decreasing"){

        protected boolean isOptionSet(TocOptions options) {
            return options.listType == TocOptions.ListType.SORTED_REVERSED;
        }

        public TocOptions setOptions(TocOptions options) {
            return options.withListType(TocOptions.ListType.SORTED_REVERSED);
        }
    });

    public final OptionParser<TocOptions> parser;
    public static final OptionParser<TocOptions>[] OPTIONS;

    public String getOptionName() {
        return this.parser.getOptionName();
    }

    public Pair<TocOptions, List<ParsedOption<TocOptions>>> parseOption(BasedSequence optionText, TocOptions options, MessageProvider provider) {
        return this.parser.parseOption(optionText, (Object)options, provider);
    }

    public String getOptionText(TocOptions options, TocOptions defaultOptions) {
        return this.parser.getOptionText((Object)options, (Object)defaultOptions);
    }

    private SimTocOptionTypes(OptionParser<TocOptions> parser) {
        this.parser = parser;
    }

    static {
        OPTIONS = SimTocOptionTypes.values();
    }

    private static class Constants {
        static final String OPTION_BULLET = "bullet";
        static final String OPTION_NUMBERED = "numbered";
        static final String OPTION_MARKDOWN = "markdown";
        static final String OPTION_HTML = "html";
        static final String OPTION_TEXT = "text";
        static final String OPTION_FORMATTED = "formatted";
        static final String OPTION_HIERARCHY = "hierarchy";
        static final String OPTION_FLAT = "flat";
        static final String OPTION_FLAT_REVERSED = "reversed";
        static final String OPTION_SORTED = "increasing";
        static final String OPTION_SORTED_REVERSED = "decreasing";
        static final String OPTION_LEVELS = "levels";

        private Constants() {
        }
    }
}

