/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.pgsql.handlers;

import de.bytefish.pgbulkinsert.exceptions.ValueHandlerAlreadyRegisteredException;
import de.bytefish.pgbulkinsert.exceptions.ValueHandlerNotRegisteredException;
import de.bytefish.pgbulkinsert.pgsql.constants.DataType;
import de.bytefish.pgbulkinsert.pgsql.handlers.BigDecimalValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.BooleanValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.BoxValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.ByteArrayValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.ByteValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.CircleValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.DoubleValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.FloatValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.HstoreValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.IValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.IValueHandlerProvider;
import de.bytefish.pgbulkinsert.pgsql.handlers.Inet4AddressValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.Inet6AddressValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.IntegerValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.JsonbValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LineSegmentValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LineValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LocalDateTimeValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LocalDateValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LongValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.MacAddressValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.PathValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.PointValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.PolygonValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.ShortValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.StringValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.UUIDValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.ValueHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class ValueHandlerProvider
implements IValueHandlerProvider {
    private Map<DataType, ValueHandler> valueHandlers = new HashMap<DataType, ValueHandler>();

    public ValueHandlerProvider() {
        this.add(new BooleanValueHandler());
        this.add(new ByteValueHandler());
        this.add(new DoubleValueHandler());
        this.add(new FloatValueHandler());
        this.add(new LocalDateValueHandler());
        this.add(new LocalDateTimeValueHandler());
        this.add(new IntegerValueHandler());
        this.add(new ShortValueHandler());
        this.add(new LongValueHandler());
        this.add(new StringValueHandler());
        this.add(new Inet4AddressValueHandler());
        this.add(new Inet6AddressValueHandler());
        this.add(new UUIDValueHandler());
        this.add(new ByteArrayValueHandler());
        this.add(new JsonbValueHandler());
        this.add(new HstoreValueHandler());
        this.add(new PointValueHandler());
        this.add(new BoxValueHandler());
        this.add(new LineValueHandler());
        this.add(new LineSegmentValueHandler());
        this.add(new PathValueHandler());
        this.add(new PolygonValueHandler());
        this.add(new CircleValueHandler());
        this.add(new MacAddressValueHandler());
        this.add(new BigDecimalValueHandler());
    }

    public <TTargetType> ValueHandlerProvider add(IValueHandler<TTargetType> valueHandler) {
        DataType targetType = valueHandler.getDataType();
        if (this.valueHandlers.containsKey((Object)targetType)) {
            throw new ValueHandlerAlreadyRegisteredException(String.format("TargetType '%s' has already been registered", new Object[]{targetType}));
        }
        this.valueHandlers.put(valueHandler.getDataType(), valueHandler);
        return this;
    }

    @Override
    public <TTargetType> IValueHandler<TTargetType> resolve(DataType dataType) {
        if (!this.valueHandlers.containsKey((Object)dataType)) {
            throw new ValueHandlerNotRegisteredException(String.format("DataType '%s' has not been registered", new Object[]{dataType}));
        }
        return (IValueHandler)this.valueHandlers.get((Object)dataType);
    }

    public <TTargetType> ValueHandlerProvider override(IValueHandler<TTargetType> valueHandler) {
        this.valueHandlers.put(valueHandler.getDataType(), valueHandler);
        return this;
    }

    public String toString() {
        String valueHandlersString = this.valueHandlers.entrySet().stream().map(e -> ((ValueHandler)e.getValue()).toString()).collect(Collectors.joining(", "));
        return "ValueHandlerProvider{valueHandlers=[" + valueHandlersString + "]" + '}';
    }
}

