/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.trust;

import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.helpers.KeyStoreHelper;
import eu.emi.security.authn.x509.helpers.ObserversHandler;
import eu.emi.security.authn.x509.helpers.trust.JDKInMemoryTrustAnchorStore;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Timer;

public class JDKFSTrustAnchorStore
extends JDKInMemoryTrustAnchorStore {
    private final String truststorePath;
    private final transient char[] password;
    private final String type;

    public JDKFSTrustAnchorStore(String truststorePath, char[] password, String type, Timer t, long updateInterval, ObserversHandler observers) throws KeyStoreException, IOException {
        super(JDKFSTrustAnchorStore.readKeyStore(truststorePath, password, type), t, updateInterval, observers);
        this.truststorePath = truststorePath;
        this.type = type;
        this.password = password;
        this.update();
    }

    private static KeyStore readKeyStore(String truststorePath, char[] password, String type) throws IOException, KeyStoreException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(truststorePath));
        KeyStore ks = KeyStoreHelper.getInstance(type);
        try {
            ks.load(is, password);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyStoreException("Unsupported keystore integrity algorithm, keystore path: " + truststorePath, e);
        }
        catch (CertificateException e) {
            throw new KeyStoreException("Some of the certificates found in the keystore can not be loaded, keystore path: " + truststorePath, e);
        }
        finally {
            ((InputStream)is).close();
        }
        return ks;
    }

    @Override
    protected void update() {
        try {
            KeyStore ks;
            this.keystore = ks = JDKFSTrustAnchorStore.readKeyStore(this.truststorePath, this.password, this.type);
            this.load();
            this.observers.notifyObservers(this.truststorePath, "CA Certificate", StoreUpdateListener.Severity.NOTIFICATION, null);
        }
        catch (Exception e) {
            this.observers.notifyObservers(this.truststorePath, "CA Certificate", StoreUpdateListener.Severity.ERROR, e);
        }
    }

    public String getTruststorePath() {
        return this.truststorePath;
    }
}

