/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.optional;

import com.google.common.base.Preconditions;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.OptionalDouble;
import javax.inject.Singleton;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;

@Singleton
public class OptionalDoubleParamConverterProvider
implements ParamConverterProvider {
    private final OptionalDoubleParamConverter paramConverter = new OptionalDoubleParamConverter();

    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        return OptionalDouble.class.equals(rawType) ? this.paramConverter : null;
    }

    public static class OptionalDoubleParamConverter
    implements ParamConverter<OptionalDouble> {
        public OptionalDouble fromString(String value) {
            if (value == null) {
                return OptionalDouble.empty();
            }
            try {
                return OptionalDouble.of(Double.parseDouble(value));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public String toString(OptionalDouble value) {
            Preconditions.checkArgument((value != null ? 1 : 0) != 0);
            return value.isPresent() ? Double.toString(value.getAsDouble()) : "";
        }
    }
}

