/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.compiler;

import io.gatling.compiler.config.CompilerConfiguration;
import io.gatling.compiler.config.CompilerConfiguration$;
import io.gatling.compiler.config.ConfigUtils$;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sbt.internal.inc.AnalyzingCompiler;
import sbt.internal.inc.FileAnalysisStore$;
import sbt.internal.inc.Locate$;
import sbt.internal.inc.LoggedReporter;
import sbt.internal.inc.PlainVirtualFile;
import sbt.internal.inc.PlainVirtualFileConverter$;
import sbt.internal.inc.ProblemStringFormats;
import sbt.internal.inc.ScalaInstance;
import sbt.internal.inc.ZincUtil$;
import sbt.internal.inc.classpath.ClasspathUtil$;
import sbt.util.Level$;
import sbt.util.ShowLines;
import sbt.util.ShowLines$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.io.Directory$;
import scala.reflect.io.Path$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.matching.Regex;
import xsbti.Problem;
import xsbti.Reporter;
import xsbti.T2;
import xsbti.VirtualFile;
import xsbti.compile.AnalysisContents;
import xsbti.compile.AnalysisStore;
import xsbti.compile.ClasspathOptionsUtil;
import xsbti.compile.CompileAnalysis;
import xsbti.compile.CompileOptions;
import xsbti.compile.CompileOrder;
import xsbti.compile.CompileResult;
import xsbti.compile.CompilerCache;
import xsbti.compile.Compilers;
import xsbti.compile.DefinesClass;
import xsbti.compile.GlobalsCache;
import xsbti.compile.IncOptions;
import xsbti.compile.IncrementalCompiler;
import xsbti.compile.Inputs;
import xsbti.compile.MiniSetup;
import xsbti.compile.PerClasspathEntryLookup;
import xsbti.compile.PreviousResult;
import xsbti.compile.ScalaCompiler;
import xsbti.compile.Setup;
import xsbti.compile.ZincCompilerUtil;

public final class ZincCompiler$
implements ProblemStringFormats {
    public static final ZincCompiler$ MODULE$ = new ZincCompiler$();
    private static final Logger io$gatling$compiler$ZincCompiler$$logger;
    private static ShowLines<Problem> ProblemStringFormat;
    private static volatile boolean bitmap$0;

    static {
        ProblemStringFormats.$init$((ProblemStringFormats)MODULE$);
        io$gatling$compiler$ZincCompiler$$logger = LoggerFactory.getLogger(MODULE$.getClass());
    }

    private ShowLines<Problem> ProblemStringFormat$lzycompute() {
        ZincCompiler$ zincCompiler$ = this;
        synchronized (zincCompiler$) {
            if (!bitmap$0) {
                ProblemStringFormat = ProblemStringFormats.ProblemStringFormat$((ProblemStringFormats)this);
                bitmap$0 = true;
            }
        }
        return ProblemStringFormat;
    }

    public ShowLines<Problem> ProblemStringFormat() {
        if (!bitmap$0) {
            return this.ProblemStringFormat$lzycompute();
        }
        return ProblemStringFormat;
    }

    public Logger io$gatling$compiler$ZincCompiler$$logger() {
        return io$gatling$compiler$ZincCompiler$$logger;
    }

    private File[] manifestClasspath() {
        Iterator manifests = CollectionConverters$.MODULE$.EnumerationHasAsScala(Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF")).asScala().map((Function1 & Serializable)url -> {
            Manifest manifest;
            try (InputStream is = url.openStream();){
                manifest = new Manifest(is);
            }
            return manifest;
        });
        Iterator classPathEntries = manifests.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Manifest, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                String string = A1.getMainAttributes().getValue("GATLING_ZINC");
                String string2 = "true";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return (B1)ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])A1.getMainAttributes().getValue(Attributes.Name.CLASS_PATH).split(" ")), (Function1 & Serializable)url -> new File(new URL((String)url).toURI()), ClassTag$.MODULE$.apply(File.class));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Manifest x1) {
                Manifest manifest = x1;
                String string = manifest.getMainAttributes().getValue("GATLING_ZINC");
                String string2 = "true";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(java.lang.String )}, serializedLambda);
            }
        });
        return (File[])classPathEntries.flatten((Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs)).toArray(ClassTag$.MODULE$.apply(File.class));
    }

    private File jarMatching(File[] classpath, String regex) {
        return (File)ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])classpath), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)ZincCompiler$.$anonfun$jarMatching$1(regex, file))).getOrElse((Function0 & Serializable)() -> {
            throw new RuntimeException(new StringBuilder(28).append("Can't find the jar matching ").append(regex).toString());
        });
    }

    private void doCompile(String[] args) {
        PreviousResult previousResult;
        Option option;
        CompilerConfiguration configuration = CompilerConfiguration$.MODULE$.configuration(args);
        Files.createDirectories(configuration.binariesDirectory(), new FileAttribute[0]);
        File[] files = (File[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])System.getProperty("java.class.path").split(File.pathSeparator)), (Function1 & Serializable)x$1 -> new File((String)x$1), ClassTag$.MODULE$.apply(File.class));
        File[] classpath = ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ZincCompiler$.$anonfun$doCompile$2(x$2))) ? this.manifestClasspath() : files;
        File scalaLibraryJar = this.jarMatching(classpath, "scala-library-.*\\.jar$");
        File scalaReflectJar = this.jarMatching(classpath, "scala-reflect-.*\\.jar$");
        File scalaCompilerJar = this.jarMatching(classpath, "scala-compiler-.*\\.jar$");
        File[] allScalaJars = (File[])((Object[])new File[]{scalaCompilerJar, scalaLibraryJar, scalaReflectJar});
        File compilerBridgeJar = this.jarMatching(classpath, "compiler-bridge_.*\\.jar$");
        File cacheFile = ConfigUtils$.MODULE$.GatlingHome().resolve("target").resolve("inc_compile.zip").toFile();
        Regex scalaVersionExtractor = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("scala-library-(.*)\\.jar$"));
        String string = scalaLibraryJar.getName();
        if (string == null || (option = scalaVersionExtractor.unapplySeq((CharSequence)string)).isEmpty() || option.get() == null || ((List)option.get()).lengthCompare(1) != 0) {
            throw new MatchError((Object)string);
        }
        String version = (String)((LinearSeqOps)option.get()).apply(0);
        String scalaVersion = version;
        ScalaInstance scalaInstance = new ScalaInstance(scalaVersion, (ClassLoader)new URLClassLoader((URL[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])allScalaJars), (Function1 & Serializable)x$3 -> x$3.toURI().toURL(), ClassTag$.MODULE$.apply(URL.class))), (ClassLoader)new URLClassLoader((URL[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])allScalaJars), (Function1 & Serializable)x$4 -> x$4.toURI().toURL(), ClassTag$.MODULE$.apply(URL.class))), ClasspathUtil$.MODULE$.rootLoader(), (File[])((Object[])new File[]{scalaLibraryJar}), (File[])((Object[])new File[]{scalaCompilerJar}), allScalaJars, (Option)new Some((Object)scalaVersion));
        sbt.util.Logger sbtLogger = new sbt.util.Logger(){

            public void trace(Function0<Throwable> t) {
                ZincCompiler$.MODULE$.io$gatling$compiler$ZincCompiler$$logger().debug((String)Option$.MODULE$.apply((Object)((Throwable)t.apply()).getMessage()).getOrElse((Function0 & Serializable)() -> "error"), (Throwable)t.apply());
            }

            public void success(Function0<String> message) {
                ZincCompiler$.MODULE$.io$gatling$compiler$ZincCompiler$$logger().info(new StringBuilder(9).append("Success: ").append(message.apply()).toString());
            }

            public void log(Enumeration.Value level, Function0<String> message) {
                Enumeration.Value value = level;
                Enumeration.Value value2 = Level$.MODULE$.Error();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    if (((String)message.apply()).startsWith("## Exception when compiling")) {
                        ZincCompiler$.MODULE$.io$gatling$compiler$ZincCompiler$$logger().error(((String)message.apply()).substring(0, ((String)message.apply()).indexOf("\n")));
                        return;
                    }
                    ZincCompiler$.MODULE$.io$gatling$compiler$ZincCompiler$$logger().error((String)message.apply());
                    return;
                }
                Enumeration.Value value4 = Level$.MODULE$.Warn();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    ZincCompiler$.MODULE$.io$gatling$compiler$ZincCompiler$$logger().warn((String)message.apply());
                    return;
                }
                Enumeration.Value value6 = Level$.MODULE$.Info();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    ZincCompiler$.MODULE$.io$gatling$compiler$ZincCompiler$$logger().info((String)message.apply());
                    return;
                }
                Enumeration.Value value8 = Level$.MODULE$.Debug();
                Enumeration.Value value9 = value;
                if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                    ZincCompiler$.MODULE$.io$gatling$compiler$ZincCompiler$$logger().debug((String)message.apply());
                    return;
                }
                throw new MatchError((Object)value);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$trace$1()}, serializedLambda);
            }
        };
        IncrementalCompiler compiler = ZincUtil$.MODULE$.defaultIncrementalCompiler();
        AnalyzingCompiler scalaCompiler = new AnalyzingCompiler((xsbti.compile.ScalaInstance)scalaInstance, ZincCompilerUtil.constantBridgeProvider((xsbti.compile.ScalaInstance)scalaInstance, (File)compilerBridgeJar), ClasspathOptionsUtil.auto(), (Function1 & Serializable)x$5 -> {
            ZincCompiler$.$anonfun$doCompile$5(x$5);
            return BoxedUnit.UNIT;
        }, (Option)None$.MODULE$);
        Compilers compilers = ZincUtil$.MODULE$.compilers((xsbti.compile.ScalaInstance)scalaInstance, ClasspathOptionsUtil.boot(), (Option)None$.MODULE$, (ScalaCompiler)scalaCompiler);
        PerClasspathEntryLookup lookup = new PerClasspathEntryLookup(){

            public Optional<CompileAnalysis> analysis(VirtualFile classpathEntry) {
                return Optional.empty();
            }

            public DefinesClass definesClass(VirtualFile classpathEntry) {
                return Locate$.MODULE$.definesClass(classpathEntry);
            }
        };
        int maxErrors = 100;
        LoggedReporter reporter = new LoggedReporter(maxErrors, sbtLogger){

            public void logError(Problem problem) {
                ZincCompiler$.MODULE$.io$gatling$compiler$ZincCompiler$$logger().error(ShowLines$.MODULE$.ShowLinesOp((Object)problem, ZincCompiler$.MODULE$.ProblemStringFormat()).lines().mkString("\n"));
            }

            public void logWarning(Problem problem) {
                ZincCompiler$.MODULE$.io$gatling$compiler$ZincCompiler$$logger().warn(ShowLines$.MODULE$.ShowLinesOp((Object)problem, ZincCompiler$.MODULE$.ProblemStringFormat()).lines().mkString("\n"));
            }

            public void logInfo(Problem problem) {
                ZincCompiler$.MODULE$.io$gatling$compiler$ZincCompiler$$logger().info(ShowLines$.MODULE$.ShowLinesOp((Object)problem, ZincCompiler$.MODULE$.ProblemStringFormat()).lines().mkString("\n"));
            }
        };
        Setup setup = Setup.of((PerClasspathEntryLookup)lookup, (boolean)false, (File)cacheFile, (GlobalsCache)CompilerCache.fresh(), (IncOptions)IncOptions.of(), (Reporter)reporter, Optional.empty(), (T2[])((T2[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(T2.class))));
        File[] sources = (File[])Directory$.MODULE$.apply(Path$.MODULE$.string2path(((Object)configuration.simulationsDirectory()).toString())).deepFiles().collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends scala.reflect.io.File, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1.hasExtension("scala", (Seq)Nil$.MODULE$) || A1.hasExtension("java", (Seq)Nil$.MODULE$)) {
                    return (B1)A1.jfile();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(scala.reflect.io.File x1) {
                scala.reflect.io.File file = x1;
                return file.hasExtension("scala", (Seq)Nil$.MODULE$) || file.hasExtension("java", (Seq)Nil$.MODULE$);
            }
        }).toArray(ClassTag$.MODULE$.apply(File.class));
        AnalysisStore analysisStore = AnalysisStore.getCachedStore((AnalysisStore)FileAnalysisStore$.MODULE$.binary(cacheFile));
        Optional analysisContents = analysisStore.get();
        if (analysisContents.isPresent()) {
            AnalysisContents analysisContents0 = (AnalysisContents)analysisContents.get();
            CompileAnalysis previousAnalysis = analysisContents0.getAnalysis();
            MiniSetup previousSetup = analysisContents0.getMiniSetup();
            previousResult = PreviousResult.of(Optional.of(previousAnalysis), Optional.of(previousSetup));
        } else {
            previousResult = PreviousResult.of(Optional.empty(), Optional.empty());
        }
        PreviousResult previousResult2 = previousResult;
        CompileOptions options = CompileOptions.of((VirtualFile[])((VirtualFile[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])classpath), (Object)configuration.binariesDirectory().toFile(), ClassTag$.MODULE$.apply(File.class))), (Function1 & Serializable)file -> new PlainVirtualFile(file.toPath()), ClassTag$.MODULE$.apply(VirtualFile.class))), (VirtualFile[])((VirtualFile[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])sources), (Function1 & Serializable)file -> new PlainVirtualFile(file.toPath()), ClassTag$.MODULE$.apply(VirtualFile.class))), (Path)configuration.binariesDirectory(), (String[])((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{"-encoding", configuration.encoding(), "-target:jvm-1.8", "-deprecation", "-feature", "-unchecked", "-language:implicitConversions", "-language:postfixOps"}), configuration.extraScalacOptions(), ClassTag$.MODULE$.apply(String.class))), (String[])((String[])configuration.extraJavacOptions().toArray(ClassTag$.MODULE$.apply(String.class))), (int)100, position -> position, (CompileOrder)CompileOrder.Mixed, Optional.empty(), Optional.of(PlainVirtualFileConverter$.MODULE$.converter()), Optional.empty(), Optional.empty());
        Inputs inputs = Inputs.of((Compilers)compilers, (CompileOptions)options, (Setup)setup, (PreviousResult)previousResult2);
        CompileResult newResult = compiler.compile(inputs, (xsbti.Logger)sbtLogger);
        analysisStore.set(AnalysisContents.create((CompileAnalysis)newResult.analysis(), (MiniSetup)newResult.setup()));
    }

    public void main(String[] args) {
        try {
            this.doCompile(args);
            this.io$gatling$compiler$ZincCompiler$$logger().debug("Compilation successful");
        }
        catch (Throwable t) {
            this.io$gatling$compiler$ZincCompiler$$logger().error("Compilation crashed", t);
            System.exit(1);
        }
    }

    public static final /* synthetic */ boolean $anonfun$jarMatching$1(String regex$1, File file) {
        return !file.getName().startsWith(".") && StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(regex$1)).findFirstMatchIn((CharSequence)file.getName()).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$doCompile$2(File x$2) {
        return x$2.getName().startsWith("gatlingbooter");
    }

    public static final /* synthetic */ void $anonfun$doCompile$5(Seq x$5) {
    }

    private ZincCompiler$() {
    }
}

