/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.openvulnerability.client.nvd;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.jeremylong.openvulnerability.client.nvd.DefCveItem;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"resultsPerPage", "startIndex", "totalResults", "format", "version", "timestamp", "vulnerabilities"})
public class CveApiJson20
implements Serializable {
    private static final long serialVersionUID = -7123674591462255117L;
    @JsonProperty(value="resultsPerPage")
    private Integer resultsPerPage;
    @JsonProperty(value="startIndex")
    private Integer startIndex;
    @JsonProperty(value="totalResults")
    private Integer totalResults;
    @JsonProperty(value="format")
    private String format;
    @JsonProperty(value="version")
    private String version;
    @JsonProperty(value="timestamp")
    @JsonFormat(pattern="uuuu-MM-dd'T'HH:mm:ss.SSS", timezone="UTC")
    private ZonedDateTime timestamp;
    @JsonProperty(value="vulnerabilities")
    @JsonPropertyDescription(value="NVD feed array of CVE")
    private List<DefCveItem> vulnerabilities;

    public CveApiJson20() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"}, justification="I prefer to suppress these FindBugs warnings")
    public CveApiJson20(Integer resultsPerPage, Integer startIndex, Integer totalResults, String format, String version, ZonedDateTime timestamp, List<DefCveItem> vulnerabilities) {
        this.resultsPerPage = resultsPerPage;
        this.startIndex = startIndex;
        this.totalResults = totalResults;
        this.format = format;
        this.version = version;
        this.timestamp = timestamp;
        this.vulnerabilities = vulnerabilities;
    }

    @JsonProperty(value="resultsPerPage")
    public Integer getResultsPerPage() {
        return this.resultsPerPage;
    }

    @JsonProperty(value="startIndex")
    public Integer getStartIndex() {
        return this.startIndex;
    }

    @JsonProperty(value="totalResults")
    public Integer getTotalResults() {
        return this.totalResults;
    }

    @JsonProperty(value="format")
    public String getFormat() {
        return this.format;
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="timestamp")
    public ZonedDateTime getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="vulnerabilities")
    @SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"}, justification="I prefer to suppress these FindBugs warnings")
    public List<DefCveItem> getVulnerabilities() {
        return this.vulnerabilities;
    }

    public String toString() {
        return "CveApiJson20{resultsPerPage=" + this.resultsPerPage + ", startIndex=" + this.startIndex + ", totalResults=" + this.totalResults + ", format='" + this.format + "', version='" + this.version + "', timestamp=" + this.timestamp + ", vulnerabilities=" + this.vulnerabilities + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CveApiJson20 that = (CveApiJson20)o;
        return Objects.equals(this.resultsPerPage, that.resultsPerPage) && Objects.equals(this.startIndex, that.startIndex) && Objects.equals(this.totalResults, that.totalResults) && Objects.equals(this.format, that.format) && Objects.equals(this.version, that.version) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.vulnerabilities, that.vulnerabilities);
    }

    public int hashCode() {
        return Objects.hash(this.resultsPerPage, this.startIndex, this.totalResults, this.format, this.version, this.timestamp, this.vulnerabilities);
    }
}

