/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.baggage;

import io.grpc.Context;
import io.opentelemetry.baggage.Baggage;
import io.opentelemetry.baggage.BaggageManager;
import io.opentelemetry.baggage.BaggageUtils;
import io.opentelemetry.baggage.EmptyBaggage;
import io.opentelemetry.baggage.EntryMetadata;
import io.opentelemetry.context.Scope;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class DefaultBaggageManager
implements BaggageManager {
    private static final DefaultBaggageManager INSTANCE = new DefaultBaggageManager();

    public static BaggageManager getInstance() {
        return INSTANCE;
    }

    @Override
    public Baggage getCurrentBaggage() {
        return BaggageUtils.getCurrentBaggage();
    }

    @Override
    public Baggage.Builder baggageBuilder() {
        return new NoopBaggageBuilder();
    }

    @Override
    public Scope withContext(Baggage distContext) {
        return BaggageUtils.currentContextWith(distContext);
    }

    @Immutable
    private static final class NoopBaggageBuilder
    implements Baggage.Builder {
        private NoopBaggageBuilder() {
        }

        @Override
        public Baggage.Builder setParent(Baggage parent) {
            Objects.requireNonNull(parent, "parent");
            return this;
        }

        @Override
        public Baggage.Builder setParent(Context context) {
            Objects.requireNonNull(context, "context");
            return this;
        }

        @Override
        public Baggage.Builder setNoParent() {
            return this;
        }

        @Override
        public Baggage.Builder put(String key, String value, EntryMetadata entryMetadata) {
            Objects.requireNonNull(key, "key");
            Objects.requireNonNull(value, "value");
            Objects.requireNonNull(entryMetadata, "entryMetadata");
            return this;
        }

        @Override
        public Baggage.Builder remove(String key) {
            Objects.requireNonNull(key, "key");
            return this;
        }

        @Override
        public Baggage build() {
            return EmptyBaggage.getInstance();
        }
    }
}

