/*
 * Decompiled with CFR 0.152.
 */
package io.pebbletemplates.pebble.extension.core;

import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.extension.Filter;
import io.pebbletemplates.pebble.template.EvaluationContext;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class JoinFilter
implements Filter {
    private final List<String> argumentNames = new ArrayList<String>();

    public JoinFilter() {
        this.argumentNames.add("separator");
    }

    @Override
    public List<String> getArgumentNames() {
        return this.argumentNames;
    }

    @Override
    public Object apply(Object input, Map<String, Object> args, PebbleTemplate self, EvaluationContext context, int lineNumber) throws PebbleException {
        if (input == null) {
            return null;
        }
        String glue = null;
        if (args.containsKey("separator")) {
            glue = (String)args.get("separator");
        }
        if (input.getClass().isArray()) {
            ArrayList<Object> items = new ArrayList<Object>();
            int length = Array.getLength(input);
            for (int i = 0; i < length; ++i) {
                items.add(Array.get(input, i));
            }
            return this.join(items, glue);
        }
        if (input instanceof Collection) {
            return this.join((Collection)input, glue);
        }
        throw new PebbleException(null, "The 'join' filter expects that the input is either a collection or an array.", lineNumber, self.getName());
    }

    private String join(Collection<?> inputCollection, String glue) {
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (Object entry : inputCollection) {
            if (!isFirst && glue != null) {
                builder.append(glue);
            }
            builder.append(entry);
            isFirst = false;
        }
        return builder.toString();
    }
}

