/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net.http;

import reactor.Environment;
import reactor.core.Dispatcher;
import reactor.io.buffer.Buffer;
import reactor.io.codec.Codec;
import reactor.io.net.ReactorChannelHandler;
import reactor.io.net.ReactorClient;
import reactor.io.net.config.ClientSocketOptions;
import reactor.io.net.http.HttpChannel;
import reactor.io.net.http.model.Method;
import reactor.rx.Promise;

public abstract class HttpClient<IN, OUT>
extends ReactorClient<IN, OUT, HttpChannel<IN, OUT>> {
    protected HttpClient(Environment env, Dispatcher dispatcher, Codec<Buffer, IN, OUT> codec, ClientSocketOptions options) {
        super(env, dispatcher, codec, options.prefetch());
    }

    public final Promise<? extends HttpChannel<IN, OUT>> get(String url, ReactorChannelHandler<IN, OUT, HttpChannel<IN, OUT>> handler) {
        return this.request(Method.GET, url, handler);
    }

    public final Promise<? extends HttpChannel<IN, OUT>> get(String url) {
        return this.request(Method.GET, url, null);
    }

    public final Promise<? extends HttpChannel<IN, OUT>> post(String url, ReactorChannelHandler<IN, OUT, HttpChannel<IN, OUT>> handler) {
        return this.request(Method.POST, url, handler);
    }

    public final Promise<? extends HttpChannel<IN, OUT>> put(String url, ReactorChannelHandler<IN, OUT, HttpChannel<IN, OUT>> handler) {
        return this.request(Method.PUT, url, handler);
    }

    public final Promise<? extends HttpChannel<IN, OUT>> delete(String url, ReactorChannelHandler<IN, OUT, HttpChannel<IN, OUT>> handler) {
        return this.request(Method.DELETE, url, handler);
    }

    public final Promise<? extends HttpChannel<IN, OUT>> delete(String url) {
        return this.request(Method.DELETE, url, null);
    }

    public final Promise<? extends HttpChannel<IN, OUT>> ws(String url) {
        return this.request(Method.WS, url, null);
    }

    public final Promise<? extends HttpChannel<IN, OUT>> ws(String url, ReactorChannelHandler<IN, OUT, HttpChannel<IN, OUT>> handler) {
        return this.request(Method.WS, url, handler);
    }

    public abstract Promise<? extends HttpChannel<IN, OUT>> request(Method var1, String var2, ReactorChannelHandler<IN, OUT, HttpChannel<IN, OUT>> var3);
}

