/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net.impl.netty;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.internal.PlatformDependent;
import java.util.concurrent.ThreadFactory;

public class NettyNativeDetector {
    private static boolean epoll;

    public static EventLoopGroup newEventLoopGroup(int threads, ThreadFactory factory) {
        return epoll ? new EpollEventLoopGroup(threads, factory) : new NioEventLoopGroup(threads, factory);
    }

    public static Class<? extends ServerChannel> getServerChannel(EventLoopGroup group) {
        return EpollEventLoopGroup.class.isAssignableFrom(group.getClass()) && epoll ? EpollServerSocketChannel.class : NioServerSocketChannel.class;
    }

    public static Class<? extends Channel> getChannel(EventLoopGroup group) {
        return EpollEventLoopGroup.class.isAssignableFrom(group.getClass()) && epoll ? EpollSocketChannel.class : NioSocketChannel.class;
    }

    public static Class<? extends Channel> getDatagramChannel(EventLoopGroup group) {
        return EpollEventLoopGroup.class.isAssignableFrom(group.getClass()) && epoll ? EpollDatagramChannel.class : NioDatagramChannel.class;
    }

    static {
        if (!PlatformDependent.isWindows() && Boolean.parseBoolean(System.getProperty("reactor.io.epoll", "true"))) {
            epoll = Epoll.isAvailable();
        }
    }
}

