/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.transport;

import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.VertxInputStream;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.ReadListener;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.apache.cxf.common.util.UrlUtils;
import org.jboss.logging.Logger;

public class VertxHttpServletRequest
implements HttpServletRequest {
    private static final Logger LOG = Logger.getLogger(VertxHttpServletRequest.class);
    private final RoutingContext context;
    private final VertxInputStream in;
    private final HttpServerRequest request;
    private final HttpServerResponse response;
    private final String contextPath;
    private final String servletPath;
    private final Map<String, Object> attributes;

    public VertxHttpServletRequest(RoutingContext context, String contextPath, String servletPath) {
        this.request = context.request();
        this.response = context.response();
        this.contextPath = contextPath;
        this.servletPath = servletPath;
        this.attributes = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        this.context = context;
        this.in = new VertxInputStream(context, 10000L);
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public DispatcherType getDispatcherType() {
        LOG.trace((Object)"getDispatcherType()");
        throw new UnsupportedOperationException();
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getCharacterEncoding() {
        LOG.trace((Object)"getCharacterEncoding()");
        return null;
    }

    public int getContentLength() {
        LOG.trace((Object)"getContentLength()");
        return this.getIntHeader("Content-Length");
    }

    public String getContentType() {
        return this.request.getHeader("Content-Type");
    }

    public ServletInputStream getInputStream() throws IOException {
        return new ServletInputStream(){

            public int read() throws IOException {
                return VertxHttpServletRequest.this.in.read();
            }

            public int read(byte[] b, int off, int len) throws IOException {
                return VertxHttpServletRequest.this.in.read(b, off, len);
            }

            public boolean isFinished() {
                try {
                    return VertxHttpServletRequest.this.in.available() == -1;
                }
                catch (IOException e) {
                    return true;
                }
            }

            public boolean isReady() {
                return !this.isFinished();
            }

            public void setReadListener(ReadListener readListener) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String getLocalAddr() {
        LOG.trace((Object)"getLocalAddr()");
        try {
            return new URL(this.getRequestURI()).getHost();
        }
        catch (MalformedURLException e) {
            LOG.trace((Object)"getLocalAddr error", (Throwable)e);
            return null;
        }
    }

    public String getLocalName() {
        LOG.trace((Object)"getLocalName()");
        try {
            return new URL(this.request.absoluteURI()).getHost();
        }
        catch (MalformedURLException e) {
            LOG.trace((Object)"getLocalName error", (Throwable)e);
            return null;
        }
    }

    public int getLocalPort() {
        LOG.trace((Object)"getLocalPort()");
        try {
            return new URL(this.request.absoluteURI()).getPort();
        }
        catch (MalformedURLException e) {
            LOG.trace((Object)"getLocalPort error", (Throwable)e);
            return 0;
        }
    }

    public Locale getLocale() {
        LOG.trace((Object)"getLocale()");
        return null;
    }

    public Enumeration<Locale> getLocales() {
        LOG.trace((Object)"getLocales()");
        return null;
    }

    public String getParameter(String name) {
        if (LOG.isTraceEnabled()) {
            LOG.tracef("getParameter({0})", (Object)name);
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        LOG.trace((Object)"getParameterMap()");
        return Collections.emptyMap();
    }

    public Enumeration<String> getParameterNames() {
        LOG.trace((Object)"getParameterNames()");
        return null;
    }

    public String[] getParameterValues(String name) {
        if (LOG.isTraceEnabled()) {
            LOG.tracef("getParameterValues({0})", (Object)name);
        }
        return new String[0];
    }

    public String getProtocol() {
        LOG.trace((Object)"getProtocol");
        try {
            return new URL(this.request.absoluteURI()).getProtocol();
        }
        catch (MalformedURLException e) {
            LOG.trace((Object)"getProtocol error", (Throwable)e);
            return null;
        }
    }

    public BufferedReader getReader() throws IOException {
        LOG.trace((Object)"getReader");
        return new BufferedReader(new InputStreamReader((InputStream)this.in, StandardCharsets.UTF_8));
    }

    @Deprecated
    public String getRealPath(String path) {
        LOG.trace((Object)"getRealPath");
        return null;
    }

    public String getRemoteAddr() {
        LOG.trace((Object)"getRemoteAddr");
        return this.request.remoteAddress().host();
    }

    public String getRemoteHost() {
        LOG.trace((Object)"getRemoteHost");
        return this.request.remoteAddress().host();
    }

    public int getRemotePort() {
        LOG.trace((Object)"getRemotePort");
        return this.request.remoteAddress().port();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        LOG.trace((Object)"getRequestDispatcher");
        return null;
    }

    public String getScheme() {
        LOG.trace((Object)"getScheme");
        return this.request.scheme();
    }

    public String getServerName() {
        return this.getLocalName();
    }

    public int getServerPort() {
        LOG.trace((Object)"getServerPort");
        return this.getLocalPort();
    }

    public ServletContext getServletContext() {
        LOG.trace((Object)"getServletContext");
        return null;
    }

    public boolean isAsyncStarted() {
        LOG.trace((Object)"isAsyncStarted");
        return false;
    }

    public boolean isAsyncSupported() {
        LOG.trace((Object)"isAsyncSupported");
        return false;
    }

    public boolean isSecure() {
        LOG.trace((Object)"isSecure");
        return this.request.isSSL();
    }

    public void removeAttribute(String name) {
        LOG.trace((Object)"removeAttribute");
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object o) {
        LOG.trace((Object)"setAttribute");
        this.attributes.put(name, o);
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        LOG.trace((Object)"setCharacterEncoding");
    }

    public AsyncContext startAsync() {
        LOG.trace((Object)"startAsync");
        return null;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) {
        LOG.trace((Object)"startAsync");
        return null;
    }

    public boolean authenticate(HttpServletResponse servletResponse) throws IOException, ServletException {
        LOG.trace((Object)"authenticate");
        return false;
    }

    public String getAuthType() {
        String authorizationValue = this.request.getHeader("Authorization");
        if (authorizationValue == null) {
            return null;
        }
        return authorizationValue.split(" ")[0].trim();
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public Cookie[] getCookies() {
        LOG.trace((Object)"getCookies");
        return new Cookie[0];
    }

    public long getDateHeader(String name) {
        LOG.trace((Object)"getDateHeader");
        return 0L;
    }

    public String getHeader(String name) {
        LOG.trace((Object)"getHeader");
        return this.request.getHeader(name);
    }

    public Enumeration<String> getHeaderNames() {
        LOG.trace((Object)"getHeaderNames");
        return Collections.enumeration(this.request.headers().names());
    }

    public Enumeration<String> getHeaders(String name) {
        LOG.trace((Object)"getHeaders");
        if (this.request.headers().contains(name)) {
            return Collections.enumeration(this.request.headers().getAll(name));
        }
        return Collections.enumeration(Arrays.asList(new String[0]));
    }

    public int getIntHeader(String name) {
        LOG.trace((Object)"getIntHeader");
        String v = this.getHeader(name);
        return v == null ? -1 : Integer.parseInt(v);
    }

    public String getMethod() {
        LOG.trace((Object)"getMethod");
        return this.request.method().name();
    }

    public Part getPart(String name) throws IOException, ServletException {
        LOG.trace((Object)"getPart");
        return null;
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        LOG.trace((Object)"getParts");
        return Collections.emptyList();
    }

    public String getPathInfo() {
        String path = this.request.path();
        if (this.contextPath != null && !this.contextPath.equals("/") && this.contextPath.length() < path.length()) {
            path = path.substring(this.contextPath.length());
        }
        if (this.servletPath != null && !this.servletPath.equals("/") && this.servletPath.length() < path.length()) {
            path = path.substring(this.servletPath.length());
        }
        return UrlUtils.urlDecode((String)path);
    }

    public String getPathTranslated() {
        return null;
    }

    public String getQueryString() {
        LOG.trace((Object)"getQueryString");
        return this.request.query();
    }

    public String getRemoteUser() {
        LOG.trace((Object)"getRemoteUser");
        return null;
    }

    public String getRequestURI() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("getRequestURI " + this.request.uri()));
        }
        return this.request.uri();
    }

    public StringBuffer getRequestURL() {
        String url = this.request.absoluteURI();
        int index = url.indexOf("?");
        if (index > -1) {
            url = url.substring(0, index);
        }
        return new StringBuffer(url);
    }

    public String getRequestedSessionId() {
        LOG.trace((Object)"getRequestedSessionId");
        return null;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession() {
        LOG.trace((Object)"getSession");
        return null;
    }

    public HttpSession getSession(boolean create) {
        LOG.trace((Object)"getSession");
        return null;
    }

    public Principal getUserPrincipal() {
        QuarkusHttpUser user = (QuarkusHttpUser)this.context.user();
        if (user == null || user.getSecurityIdentity().isAnonymous()) {
            return null;
        }
        return user.getSecurityIdentity().getPrincipal();
    }

    public boolean isRequestedSessionIdFromCookie() {
        LOG.trace((Object)"isRequestedSessionIdFromCookie");
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        LOG.trace((Object)"isRequestedSessionIdFromURL");
        return false;
    }

    @Deprecated
    public boolean isRequestedSessionIdFromUrl() {
        LOG.trace((Object)"isRequestedSessionIdFromUrl");
        return false;
    }

    public boolean isRequestedSessionIdValid() {
        LOG.trace((Object)"isRequestedSessionIdValid");
        return false;
    }

    public boolean isUserInRole(String role) {
        SecurityIdentity user = CurrentIdentityAssociation.current();
        if (role.equals("**")) {
            return !user.isAnonymous();
        }
        return user.hasRole(role);
    }

    public void login(String username, String password) throws ServletException {
        LOG.trace((Object)"login");
    }

    public void logout() throws ServletException {
        LOG.trace((Object)"logout");
    }

    public long getContentLengthLong() {
        throw new UnsupportedOperationException();
    }

    public String changeSessionId() {
        throw new UnsupportedOperationException();
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> arg0) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }
}

