/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import io.quarkiverse.cxf.CxfClientConfig;
import io.quarkiverse.cxf.CxfEndpointConfig;
import io.quarkiverse.cxf.LoggingConfig;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefaults;
import io.smallrye.config.WithName;
import java.util.Map;
import java.util.Optional;

@ConfigMapping(prefix="quarkus.cxf")
@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public interface CxfConfig {
    public Optional<String> decoupledEndpointBase();

    @WithName(value="endpoint")
    @WithDefaults
    public Map<String, CxfEndpointConfig> endpoints();

    @WithName(value="client")
    @WithDefaults
    public Map<String, CxfClientConfig> clients();

    public InternalConfig internal();

    public LoggingConfig.GlobalLoggingConfig logging();

    default public boolean isClientPresent(String key) {
        return Optional.ofNullable(this.clients()).map(m -> m.containsKey(key)).orElse(false);
    }

    default public CxfClientConfig getClient(String key) {
        return Optional.ofNullable(this.clients()).map(m -> (CxfClientConfig)m.get(key)).orElse(null);
    }

    public static interface InternalConfig {
        public CxfClientConfig client();
    }
}

