/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletPathMatch;
import io.undertow.servlet.handlers.ServletPathMatches;
import io.undertow.util.RedirectBuilder;

public class RedirectDirHandler
implements HttpHandler {
    private static final String HTTP2_UPGRADE_PREFIX = "h2";
    private final HttpHandler next;
    private final ServletPathMatches paths;

    public RedirectDirHandler(HttpHandler next, ServletPathMatches paths) {
        this.next = next;
        this.paths = paths;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        boolean isUpgradeRequest;
        String path = exchange.getRelativePath();
        ServletPathMatch info = this.paths.getServletHandlerByPath(path);
        String upgradeString = exchange.getRequestHeader("Upgrade");
        boolean bl = isUpgradeRequest = upgradeString != null && !upgradeString.startsWith(HTTP2_UPGRADE_PREFIX);
        if (info.getType() == ServletPathMatch.Type.REDIRECT && !isUpgradeRequest) {
            if (exchange.getRequestMethod().equals("GET") || exchange.getRequestMethod().equals("GET")) {
                exchange.setStatusCode(302);
            } else {
                exchange.setStatusCode(307);
            }
            exchange.setResponseHeader("Location", RedirectBuilder.redirect((HttpServerExchange)exchange, (String)(exchange.getRelativePath() + "/"), (boolean)true));
            return;
        }
        this.next.handleRequest(exchange);
    }
}

