/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.apicurio.registry.binding;

import io.quarkus.kubernetes.service.binding.runtime.ServiceBinding;
import io.quarkus.kubernetes.service.binding.runtime.ServiceBindingConfigSource;
import io.quarkus.kubernetes.service.binding.runtime.ServiceBindingConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class ServiceRegistryBindingConverter
implements ServiceBindingConverter {
    private static Logger LOG = Logger.getLogger(ServiceRegistryBindingConverter.class.getName());
    private static final String INCOMING_PREFIX = "mp.messaging.incoming.";
    private static final String OUTGOING_PREFIX = "mp.messaging.outgoing.";

    public Optional<ServiceBindingConfigSource> convert(List<ServiceBinding> serviceBindings) {
        Optional matchingByType = ServiceBinding.singleMatchingByType((String)"serviceregistry", serviceBindings);
        Config config = ConfigProvider.getConfig();
        if (matchingByType.isEmpty()) {
            return Optional.empty();
        }
        ServiceBinding binding = (ServiceBinding)matchingByType.get();
        List<String> channels = this.extractChannels(config);
        HashMap<Object, String> properties = new HashMap<Object, String>();
        String registryUrl = (String)binding.getProperties().get("registryUrl");
        if (registryUrl == null) {
            registryUrl = (String)binding.getProperties().get("registryurl");
        }
        if (registryUrl != null) {
            properties.put("kafka.apicurio.registry.url", registryUrl);
        }
        Iterator<String> iterator = channels.iterator();
        while (iterator.hasNext()) {
            String clientSecret;
            String clientId;
            String channel;
            String prefix = channel = iterator.next();
            String oauthTokenUrl = (String)binding.getProperties().get("oauthTokenUrl");
            if (oauthTokenUrl == null) {
                oauthTokenUrl = (String)binding.getProperties().get("oauthtokenurl");
            }
            if (oauthTokenUrl != null) {
                properties.put(prefix + "apicurio.auth.service.token.endpoint", oauthTokenUrl);
            }
            if ((clientId = (String)binding.getProperties().get("clientId")) == null) {
                clientId = (String)binding.getProperties().get("clientid");
            }
            if (clientId != null) {
                properties.put(prefix + "apicurio.auth.client.id", clientId);
            }
            if ((clientSecret = (String)binding.getProperties().get("clientSecret")) == null) {
                clientSecret = (String)binding.getProperties().get("clientsecret");
            }
            if (clientSecret != null) {
                properties.put(prefix + "apicurio.auth.client.secret", clientSecret);
            }
            if (registryUrl == null) continue;
            properties.put(prefix + "apicurio.registry.url", registryUrl);
        }
        return Optional.of(new ServiceBindingConfigSource("serviceregistry-k8s-service-binding-source", properties));
    }

    private List<String> extractChannels(Config configIn) {
        ArrayList<String> list = new ArrayList<String>();
        for (String propertyName : configIn.getPropertyNames()) {
            String channelName;
            String channelAndProp;
            if (propertyName.startsWith(INCOMING_PREFIX)) {
                channelAndProp = StringUtils.substringAfter((String)propertyName, (String)INCOMING_PREFIX);
                channelName = StringUtils.substringBefore((String)channelAndProp, (String)".");
                if (StringUtils.isBlank((CharSequence)channelName)) continue;
                list.add(INCOMING_PREFIX + channelName + ".");
                continue;
            }
            if (!propertyName.startsWith(OUTGOING_PREFIX) || StringUtils.isBlank((CharSequence)(channelName = StringUtils.substringBefore((String)(channelAndProp = StringUtils.substringAfter((String)propertyName, (String)OUTGOING_PREFIX)), (String)".")))) continue;
            list.add(OUTGOING_PREFIX + channelName + ".");
        }
        return list;
    }
}

