/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.apicurio.registry.common;

import io.apicurio.registry.rest.client.RegistryClientFactory;
import io.apicurio.rest.client.VertxHttpClientProvider;
import io.apicurio.rest.client.spi.ApicurioHttpClientFactory;
import io.apicurio.rest.client.spi.ApicurioHttpClientProvider;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.Vertx;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.logging.Logger;

@Recorder
public class ApicurioRegistryClient {
    private static final Logger log = Logger.getLogger(ApicurioRegistryClient.class);

    public void setup(RuntimeValue<Vertx> vertx) {
        RegistryClientFactory.setProvider((ApicurioHttpClientProvider)new VertxHttpClientProvider((Vertx)vertx.getValue()));
    }

    public void clearHttpClient() {
        try {
            Field providerReference = ApicurioHttpClientFactory.class.getDeclaredField("providerReference");
            providerReference.setAccessible(true);
            AtomicReference ref = (AtomicReference)providerReference.get(null);
            ref.set(null);
        }
        catch (IllegalAccessException | NoSuchFieldException t) {
            log.error((Object)"Failed to clear Apicurio Http Client provider", (Throwable)t);
        }
    }
}

