/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import io.quarkus.bootstrap.model.AppArtifactCoords;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.model.PlatformReleaseInfo;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class PlatformStreamInfo
implements Serializable {
    private final String id;
    private final Map<String, PlatformReleaseInfo> releases = new HashMap<String, PlatformReleaseInfo>();

    public PlatformStreamInfo(String stream) {
        this.id = stream;
    }

    public String getId() {
        return this.id;
    }

    boolean isAligned(Collection<AppArtifactCoords> importedBoms) {
        if (this.releases.isEmpty()) {
            return true;
        }
        for (PlatformReleaseInfo release : this.releases.values()) {
            if (!release.getBoms().containsAll(importedBoms)) continue;
            return true;
        }
        return false;
    }

    List<List<String>> getPossibleAlignemnts(Collection<AppArtifactCoords> importedPlatformBoms) {
        HashMap<AppArtifactKey, String> importedKeys = new HashMap<AppArtifactKey, String>(importedPlatformBoms.size());
        for (AppArtifactCoords bom : importedPlatformBoms) {
            importedKeys.put(bom.getKey(), bom.getVersion());
        }
        ArrayList<List<String>> suggestions = new ArrayList<List<String>>();
        for (PlatformReleaseInfo release : this.releases.values()) {
            HashMap<AppArtifactKey, AppArtifactCoords> stackBoms = new HashMap<AppArtifactKey, AppArtifactCoords>(release.getBoms().size());
            for (AppArtifactCoords bom : release.getBoms()) {
                stackBoms.put(bom.getKey(), bom);
            }
            if (!stackBoms.keySet().containsAll(importedKeys.keySet())) continue;
            ArrayList<CallSite> suggestion = new ArrayList<CallSite>(importedPlatformBoms.size());
            suggestions.add(suggestion);
            for (Map.Entry bomKey : importedKeys.entrySet()) {
                AppArtifactCoords stackBom = (AppArtifactCoords)stackBoms.get(bomKey.getKey());
                if (!((String)bomKey.getValue()).equals(stackBom.getVersion())) {
                    suggestion.add((CallSite)((Object)(((AppArtifactKey)bomKey.getKey()).getGroupId() + ":" + ((AppArtifactKey)bomKey.getKey()).getArtifactId() + ":" + (String)bomKey.getValue() + " -> " + stackBom.getVersion())));
                    continue;
                }
                suggestion.add((CallSite)((Object)(stackBom.getGroupId() + ":" + stackBom.getArtifactId() + ":" + stackBom.getVersion())));
            }
        }
        return suggestions;
    }

    void addIfNotPresent(String version, Supplier<PlatformReleaseInfo> release) {
        if (!this.releases.containsKey(version)) {
            this.releases.put(version, release.get());
        }
    }

    Collection<PlatformReleaseInfo> getReleases() {
        return this.releases.values();
    }

    PlatformReleaseInfo getRelease(String version) {
        return this.releases.get(version);
    }
}

