/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.paths;

import io.quarkus.paths.ArchivePathTree;
import io.quarkus.paths.DirectoryPathTree;
import io.quarkus.paths.FilePathTree;
import io.quarkus.paths.OpenPathTree;
import io.quarkus.paths.PathFilter;
import io.quarkus.paths.PathVisit;
import io.quarkus.paths.PathVisitor;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.jar.Manifest;

public interface PathTree {
    public static PathTree ofDirectoryOrFile(Path p) {
        return PathTree.ofDirectoryOrFile(p, null);
    }

    public static PathTree ofDirectoryOrFile(Path p, PathFilter filter) {
        try {
            BasicFileAttributes fileAttributes = Files.readAttributes(p, BasicFileAttributes.class, new LinkOption[0]);
            return fileAttributes.isDirectory() ? new DirectoryPathTree(p, filter) : new FilePathTree(p, filter);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(p + " does not exist", e);
        }
    }

    public static PathTree ofDirectoryOrArchive(Path p) {
        return PathTree.ofDirectoryOrArchive(p, null);
    }

    public static PathTree ofDirectoryOrArchive(Path p, PathFilter filter) {
        try {
            BasicFileAttributes fileAttributes = Files.readAttributes(p, BasicFileAttributes.class, new LinkOption[0]);
            return fileAttributes.isDirectory() ? new DirectoryPathTree(p, filter) : PathTree.ofArchive(p, filter);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(p + " does not exist", e);
        }
    }

    public static PathTree ofArchive(Path archive) {
        return PathTree.ofArchive(archive, null);
    }

    public static PathTree ofArchive(Path archive, PathFilter filter) {
        if (!Files.exists(archive, new LinkOption[0])) {
            throw new IllegalArgumentException(archive + " does not exist");
        }
        return ArchivePathTree.forPath(archive, filter);
    }

    public Collection<Path> getRoots();

    default public boolean isEmpty() {
        return this.getRoots().isEmpty();
    }

    public Manifest getManifest();

    public void walk(PathVisitor var1);

    public <T> T apply(String var1, Function<PathVisit, T> var2);

    public void accept(String var1, Consumer<PathVisit> var2);

    default public void acceptAll(String relativePath, Consumer<PathVisit> consumer) {
        this.accept(relativePath, consumer);
    }

    public boolean contains(String var1);

    public OpenPathTree open();
}

