/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.app;

import io.quarkus.bootstrap.app.ArtifactResult;
import io.quarkus.bootstrap.app.JarResult;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class AugmentResult {
    private final List<ArtifactResult> results;
    private final JarResult jar;
    private final Path nativeImagePath;
    private final Map<String, String> graalVMInfo;

    public AugmentResult(List<ArtifactResult> results, JarResult jar, Path nativeImagePath, Map<String, String> graalVMInfo) {
        this.results = results;
        this.jar = jar;
        this.nativeImagePath = nativeImagePath;
        this.graalVMInfo = graalVMInfo;
    }

    public List<ArtifactResult> getResults() {
        return this.results;
    }

    public JarResult getJar() {
        return this.jar;
    }

    public Path getNativeResult() {
        return this.nativeImagePath;
    }

    public List<ArtifactResult> resultsMatchingType(Predicate<String> typePredicate) {
        if (this.results == null) {
            return Collections.emptyList();
        }
        ArrayList<ArtifactResult> res = new ArrayList<ArtifactResult>(1);
        for (ArtifactResult result : this.results) {
            if (!typePredicate.test(result.getType())) continue;
            res.add(result);
        }
        return res;
    }

    public Map<String, String> getGraalVMInfo() {
        return this.graalVMInfo;
    }
}

