/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime.noop;

import io.quarkus.cache.runtime.AbstractCache;
import io.smallrye.mutiny.Uni;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class NoOpCache
extends AbstractCache {
    private static final String NAME = NoOpCache.class.getName();

    public String getName() {
        return NAME;
    }

    public <K, V> Uni<V> get(final K key, final Function<K, V> valueLoader) {
        return Uni.createFrom().item(new Supplier<V>(){

            @Override
            public V get() {
                return valueLoader.apply(key);
            }
        });
    }

    public <K, V> Uni<V> getAsync(K key, Function<K, Uni<V>> valueLoader) {
        return valueLoader.apply(key);
    }

    public Uni<Void> invalidate(Object key) {
        return Uni.createFrom().voidItem();
    }

    public Uni<Void> invalidateAll() {
        return Uni.createFrom().voidItem();
    }

    public Uni<Void> invalidateIf(Predicate<Object> predicate) {
        return Uni.createFrom().voidItem();
    }
}

